<?php

namespace App\Http\Controllers\Utility;

use App\Models\BusinessDate;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Carbon\Carbon;

class BusinessDateController extends Controller
{
    public function businessDate()
    {
        $businessDate = BusinessDate::latest('business_date')->first();

        return response()->json([
            'status'      => 'success',
            'business_date' => Carbon::createFromFormat('Y-m-d H:i:s', $businessDate->business_date)->format('d-M-Y')
        ]);
    }
}
