<?php

namespace App\Http\Controllers\Utility;

use App\Models\Complain;
use App\Models\BusinessDate;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class ComplainController extends Controller
{
    public function complainList()
    {
        $user         = Auth::user();
        $complainList = Complain::where('portfolio_code', $user->investor_code)->where('status', 'P')->get();

        return response()->json([
            'status'        => 'success',
            'complain_list' => $complainList,
        ]);
    }


    public function submitComplain(Request $request)
    {
        $user                 = Auth::user();
        $businessDate         = BusinessDate::latest('business_date')->first();
        
        $validator = Validator::make(
            $request->all(),
            [
                'message'       => 'required',
            ],
            [
                'message.required'      => "The complain field is required",
            ]
        );

        if ($validator->fails()) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Form validation error',
                'errors'  => $validator->errors()->messages(),
            ], 400);
        }

        $complain                  = new Complain();
        $complain->portfolio_code  = $user->investor_code;
        $complain->request_message = $request->message;
        $complain->request_type    = 'complain';
        $complain->business_date   = $businessDate->business_date;
        $complain->request_date    = now();
        $complain->status          = 'P';
        $complain->save();

        return response()->json([
            'status'  => 'success',
            'message' => 'Complain submitted successfully'
        ]);
    }
}
