<?php

namespace App\Http\Controllers\Utility;

use Carbon\Carbon;
use App\Models\BusinessDate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\BankDetails;
use App\Models\BranchDetails;
use Illuminate\Support\Facades\Auth;

class UtilityController extends Controller
{
    public function businessDate()
    {
        $businessDate = BusinessDate::latest('business_date')->first();

        return response()->json([
            'status'      => 'success',
            'business_date' => Carbon::createFromFormat('Y-m-d H:i:s', $businessDate->business_date)->format('d-M-Y')
        ]);
    }

    public function purchasePower()
    {
        $user = Auth::user();
        $businessDate = BusinessDate::latest('business_date')->first();

        $purchasepower = DB::table('p_investor_portfolio_statement')
            ->selectRaw('distinct nvl(purchase_power, 0) as purchase_power')
            ->where('business_date', '=', $businessDate->business_date)
            ->where('portfolio_code', '=', $user->investor_code)
            ->first();

        // dd($purchasepower);

            
        return response()->json([
            'status'      => 'success',
            'purchase_power' => is_null($purchasepower) ? number_format(999999999, 2) : number_format($purchasepower->purchase_power, 2),
        ]);
    }
}
