<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvestorDetail extends Model
{
    use HasFactory;
    
    public $timestamps = false;
    protected $table = 'is_investor_details';
    protected $primaryKey = 'investor_details_id';

    public function templateDetails()
    {
        return $this->hasOne(Template::class, 'template_id', 'template_id');
    }

    public function nomineeInfo()
    {
        return $this->hasMany(NomineeInfo::class, 'investor_details_id', 'investor_details_id');
    }

    public function branchDetails()
    {
        return $this->hasOne(BranchDetails::class, 'org_branch_id', 'org_branch_id');
    }

    public function jointInvestorDetails()
    {
        return $this->hasOne(JointApplicant::class, 'investor_details_id', 'investor_details_id');
    }

    public function occupationDetails()
    {
        return $this->hasOne(Occupation::class, 'occupation_id', 'occupation_id');
    }

    public function nationalityDetails()
    {
        return $this->hasOne(Nationality::class, 'nationality_id', 'nationality_id');
    }
    
}
