<?php

namespace App\Http\Controllers\Report;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\BusinessDate;
use App\Models\FiscalYear;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class TaxCertificateController extends Controller
{
    public function fiscalYear() {
        $fiscalYear = FiscalYear::all(['fiscal_year_id', 'fiscal_year']);
        
        return response()->json([
            'status'      => 'success',
            'fiscal_year' => $fiscalYear,
        ]);
    }

    public function taxCertificateDownload(Request $request)
    {
        $validator = Validator::make(
            $request->all(),
            [
                'fiscal_year_id' => 'required',
            ],
            [
                'fiscal_year_id.required' => 'The fiscal year field is required',
            ]
        );

        if ($validator->fails()) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Form validation error',
                'errors' => $validator->errors()->messages(),
            ], 400);
        }

        $data = [
            'title' => 'Tax Certificate',
        ];

        $fiscalYear = FiscalYear::find($request->fiscal_year_id);

        $user                    = Auth::user();
		$investorDetail          = $user->investorDetail;		
        $fromDate                = Carbon::createFromFormat('Y-m-d H:i:s', $fiscalYear->fiscal_start);
        $fromDate1              = Carbon::createFromFormat('Y-m-d H:i:s', $fiscalYear->fiscal_start);
        $fromDateOp              = date( "Y-m-d", strtotime( "$fromDate1 -1 day" ) );
		$toDate                  = Carbon::createFromFormat('Y-m-d H:i:s', $fiscalYear->fiscal_end);
		$data['account_type']    = $investorDetail->templateDetails->product_short_name;
		$data['account_no']      = $investorDetail->portfolio_code;
		$data['bo_no']           = $investorDetail->bo_account_no;
		$data['inst_tin_no']     = $investorDetail->inst_tin_no;
		$data['margin_status']   = $investorDetail->is_margin_loan_active;
		$data['account_date']    = Carbon::createFromFormat('Y-m-d H:i:s', $investorDetail->business_date)->format(env('OUTPUT_DATE_FORMAT'));
		$data['account_name']    = $investorDetail->investor_name;
		$data['account_address'] = $investorDetail->mailing_address;
        $data['print_date']      = Carbon::createFromFormat('Y-m-d H:i:s', BusinessDate::getLastBusinessDate())->format('M d, Y');
        $data['report_date']     = $fromDate->format('d-m-Y') . ' To ' . $toDate->format('d-m-Y');
        $data['from_date']       = $fromDate->format('d-m-Y');
        $data['to_date']         = $toDate->format('d-m-Y');

        if ($investorDetail->account_enable_disable == 'e') {
			$data['account_status'] = 'Active';
		}

		if ($investorDetail->account_close == 'y') {
			$data['account_status'] = 'Close';
		}

		if ($investorDetail->account_suspend == 'y') {
			$data['account_status'] = 'Suspend';
		}

        $data['operation_mode'] = $investorDetail->operation_mode_id;
        $data['father_name'] = $investorDetail->father_name;
        $data['mother_name'] = $investorDetail->mother_name;
        $data['Date'] = '';

        $data['tax_data']      = $this->getTaxCertificateData($user->investor_code, $fromDate, $toDate, $fromDateOp);

        $reportName = 'TaxCertificate_' . $fromDate->format('d_m_Y') . '_' . $toDate->format('d_m_Y') . '.pdf';
        $pdf        = Pdf::loadView('taxcertificate.index', $data);
        $pdf->setPaper('a4');
        return $pdf->stream($reportName);
    }

    private function getTaxCertificateData($portfolioCode, $fromDate, $toDate, $fromDateOp)
    {
        $sql = "
        SELECT PSTM.PORTFOLIO_CODE,
								NVL (OPENINGVAL.OPENING_EQUITY, 0)				AS EQUITY,
								NVL (OPENINGVAL.OPENING_MKT_VALUE_SEC, 0)		AS OPENING_MKT_VALUE_SEC,
								NVL (OPENINGVAL.OPENING_COST_VAL_SEC, 0)		AS OPENING_COST_VAL_SEC,
								NVL (OPENINGVAL.OPENING_CURRENT_BALANCE, 0)		AS OPENING_CURRENT_BALANCE,
								NVL (OPENINGVAL.OPENING_RECEIVABLES_SALES, 0)	AS OPENING_RECEIVABLES_SALES,
								
								NVL (PSTM.MARGIN_EQUITY, 0)						AS MARGIN_EQUITY,
								NVL (PSTM.MARKET_VALUE_SECURITIES, 0)			AS MKT_VALUE_SECURITIES,
								NVL (PSTM.MATURE_MARKET_VALUE_SECURITIES, 0)	AS MAT_MKT_VALUE_SECURITIES,
								NVL(REAL_DATA.SALE_AMOUNT, 0)-NVL(REAL_DATA.BUY_AMOUNT, 0)-NVL(REAL_DATA.BROKER_COMMISSION, 0)					AS REALIZE_GAIN_LOSS,
								NVL (DEPO_AMT.TOTAL_DEPOSIT, 0)					AS TOTAL_DEPOSIT,
								NVL (PSTM.FUND_TRANSFER_IN, 0)					AS FUND_TRANSFER_IN,
								NVL (PSTM.FUND_TRANSFER_OUT, 0)					AS FUND_TRANSFER_OUT,
								NVL (DIV_DETAILS.RECEIVED_DIVIDEND, 0)			AS DIVIDEND_INCOME,
								NVL (WITHDRW.TOTAL_WITHDRAW,0)					AS TOTAL_WITHDRAW0,
								NVL (PSTM.ACCRUED_FEES_CHARGE, 0)				AS ACCRUED_FEES_CHARGE,
      							NVL (ACCD_INTER.INTEREST_AMT, 0)+NVL(OCRG.OTER_FEES_CHARGE,0)				AS APPLIED_INTR_AMT,
								NVL (IPO.IPO_APP_AMOUNT, 0)						AS IPO_APPLICATION,
								NVL (PSTM.RIGHT_APPLICATION, 0)					AS RIGHT_APPLICATION,
								NVL (LINKIN.TOTAL_LINK_IN, 0) 					AS SEC_TRANSFER_IN,
								NVL (LINKOUT.TOTAL_LINK_OUT, 0) 				AS SECT_TRANFER_OUT,
								NVL(CLOSIINGVAL.EQUITY,0)				        AS CLOSE_EQUITY,
								NVL(CLOSIINGVAL.CURRENT_BALANCE,0)				AS CURRENT_BALANCE,
								NVL(CLOSIINGVAL.MKT_VALUE_SECURITIES,0)			AS CLOSE_MKT_VAL,
								NVL(CLOSIINGVAL.COST_VAL_SECURITIES,0)			AS CLOSE_COST_VAL,
								NVL(CLOSIINGVAL.RECEIVABLES_SALES,0)			AS RECEIVABLES_SALES,
								NVL(DIV_DETAILS.RECEIVED_DIVIDEND, 0) 			AS RECEIVED_DIVIDEND,
								NVL(DIV_DETAILS.TAX_DIVIDEND, 0) 				AS TAX_DIVIDEND
									
							FROM P_PORTFOLIO_STATEMENT_TEMP PSTM
							LEFT JOIN
							(SELECT CLD.PORTFOLIO_CODE, NVL (SUM (CLD.AMOUNT), 0) AS TOTAL_DEPOSIT
								FROM IS_PORTFOLIO_MASTER MST, IS_PORTFOLIO_CHILD CLD
							WHERE     MST.TRAN_NO = CLD.TRAN_NO
									AND CLD.PORTFOLIO_CODE = : portfolio_code
									AND MST.TRAN_DATE BETWEEN : from_date  AND : to_date
									AND CLD.AC_CODE IN ('101001001')
							GROUP BY CLD.PORTFOLIO_CODE) DEPO_AMT
							ON PSTM.PORTFOLIO_CODE = DEPO_AMT.PORTFOLIO_CODE
							LEFT JOIN
							(SELECT CLD.PORTFOLIO_CODE, SUM (CLD.AMOUNT) AS TOTAL_WITHDRAW
								FROM IS_PORTFOLIO_MASTER MST, IS_PORTFOLIO_CHILD CLD
							WHERE     MST.TRAN_NO = CLD.TRAN_NO
									AND CLD.PORTFOLIO_CODE = : portfolio_code
									AND MST.TRAN_DATE BETWEEN : from_date  AND : to_date
									AND CLD.AC_CODE IN ('102001001')
							GROUP BY CLD.PORTFOLIO_CODE) WITHDRW
							ON PSTM.PORTFOLIO_CODE = WITHDRW.PORTFOLIO_CODE
							LEFT JOIN
							(  SELECT CLD.PORTFOLIO_CODE, SUM (CLD.AMOUNT) AS RECEIVED_DIVIDEND
								FROM IS_PORTFOLIO_MASTER MST, IS_PORTFOLIO_CHILD CLD
							WHERE     MST.TRAN_NO = CLD.TRAN_NO
									AND CLD.PORTFOLIO_CODE = : portfolio_code
									AND MST.TRAN_DATE BETWEEN : from_date  AND : to_date
									AND SUBSTR(CLD.AC_CODE, 1,6) LIKE '305001'
									AND CLD.NTR = 'C'
							GROUP BY CLD.PORTFOLIO_CODE) DIV_INCOME
							ON PSTM.PORTFOLIO_CODE = DIV_INCOME.PORTFOLIO_CODE
							LEFT JOIN 
							(  SELECT CLD.PORTFOLIO_CODE, SUM (CLD.AMOUNT) AS IPO_APP_AMOUNT
								FROM IS_PORTFOLIO_MASTER MST, IS_PORTFOLIO_CHILD CLD
							WHERE     MST.TRAN_NO = CLD.TRAN_NO
									AND CLD.PORTFOLIO_CODE = : portfolio_code
									AND MST.TRAN_DATE BETWEEN : from_date  AND : to_date
									AND SUBSTR(CLD.AC_CODE, 1,6) LIKE '302001'
							GROUP BY CLD.PORTFOLIO_CODE) IPO
							ON PSTM.PORTFOLIO_CODE = IPO.PORTFOLIO_CODE
							LEFT JOIN
							(  SELECT CMSTOCK.PORTFOLIO_CODE, SUM (CMSTOCK.NET_AMOUNT) AS TOTAL_LINK_IN
								FROM IS_CAP_MKT_STOCK CMSTOCK
							WHERE     CMSTOCK.PORTFOLIO_CODE = : portfolio_code
									AND CMSTOCK.STATUS IN ('li','lipo')
									AND CMSTOCK.STOCK_MATURE_DATE IS NULL
									AND CMSTOCK.BUSINESS_DATE BETWEEN : from_date  AND : to_date
							GROUP BY CMSTOCK.PORTFOLIO_CODE) LINKIN
							ON PSTM.PORTFOLIO_CODE = LINKIN.PORTFOLIO_CODE
							LEFT JOIN
							(  SELECT CMSTOCK.PORTFOLIO_CODE, SUM (CMSTOCK.TOTAL_AMOUNT) AS TOTAL_LINK_OUT
								FROM IS_CAP_MKT_STOCK CMSTOCK
							WHERE   CMSTOCK.PORTFOLIO_CODE = : portfolio_code
									AND CMSTOCK.STATUS = 'lo'
									AND CMSTOCK.STOCK_MATURE_DATE IS NULL
									AND CMSTOCK.BUSINESS_DATE BETWEEN : from_date  AND : to_date
							GROUP BY CMSTOCK.PORTFOLIO_CODE) LINKOUT
							ON PSTM.PORTFOLIO_CODE = LINKOUT.PORTFOLIO_CODE
							LEFT JOIN 
							(SELECT INTR.PORTFOLIO_CODE, SUM (INTR.INTEREST_TODAY) AS INTEREST_AMT
								FROM P_MARGIN_LOAN_INTEREST INTR
							WHERE     INTR.PORTFOLIO_CODE = : portfolio_code
									AND INTR.BUSINESS_DATE BETWEEN : from_date  AND : to_date
							GROUP BY INTR.PORTFOLIO_CODE) ACCD_INTER
							ON PSTM.PORTFOLIO_CODE = ACCD_INTER.PORTFOLIO_CODE
							LEFT JOIN 
							(SELECT CLD.PORTFOLIO_CODE, SUM (NVL (CLD.AMOUNT, 0)) AS OTER_FEES_CHARGE
                                FROM IS_PORTFOLIO_MASTER MST, IS_PORTFOLIO_CHILD CLD
                               WHERE     MST.TRAN_NO = CLD.TRAN_NO
                                     AND CLD.PORTFOLIO_CODE = : portfolio_code
									 AND MST.TRAN_DATE BETWEEN : from_date  AND : to_date
									 AND SUBSTR(CLD.AC_CODE, 1,6) LIKE '601001'
									 AND CLD.AC_CODE NOT IN ('601001000','601001004','601001012','601001007')
                            GROUP BY CLD.PORTFOLIO_CODE) OCRG
							ON PSTM.PORTFOLIO_CODE = OCRG.PORTFOLIO_CODE
							LEFT JOIN 
							(SELECT PSTM.PORTFOLIO_CODE,
									NVL (PSTM.EQUITY, 0)                      AS EQUITY,
									NVL (PSTM.MARGIN_EQUITY, 0)               AS MARGIN_EQUITY,
									NVL (PSTM.MARKET_VALUE_SECURITIES, 0)     AS MKT_VALUE_SECURITIES,
									NVL (CSOTVAL.COST_VAL_SECURITIES, 0)      AS COST_VAL_SECURITIES,
									NVL (PSTM.CURRENT_BALANCE, 0)             AS CURRENT_BALANCE,
									NVL (PSTM.RECEIVABLES_SALES, 0)           AS RECEIVABLES_SALES,
									NVL(PSTM.RECEIVED_DIVIDEND, 0) 			  AS RECEIVED_DIVIDEND,
									NVL(PSTM.DIVIDEND_INCOME, 0) 			  AS DIVIDEND_INCOME
								FROM P_PORTFOLIO_STATEMENT_TEMP  PSTM
									LEFT JOIN
									(  SELECT ISCMS.PORTFOLIO_CODE,
												SUM (ISCMS.TOTAL_SHARE * ISCMS.AVG_RATE)
													COST_VAL_SECURITIES
											FROM IS_CAP_MKT_STOCK       ISCMS,
												LS_INSTRUMENT_DETAILS  LSID,
												P_CAP_MKT_PRICE_HISTORY P_CAP_MKT_PRICE,
												IS_I_BROKER_CHARGE     IBRKCHG,
												IS_INVESTOR_DETAILS    INDV,
												GS_SECTOR
										WHERE     ISCMS.CAP_MKT_STOCK_ID =
													(SELECT MAX (ISCMSD.CAP_MKT_STOCK_ID)
														FROM IS_CAP_MKT_STOCK ISCMSD
													WHERE     ISCMSD.INSTRUMENT_DETAILS_ID =
																ISCMS.INSTRUMENT_DETAILS_ID
															AND ISCMS.PORTFOLIO_CODE = ISCMSD.PORTFOLIO_CODE
															AND LSID.INSTRUMENT_DETAILS_ID =
																ISCMSD.INSTRUMENT_DETAILS_ID
															AND P_CAP_MKT_PRICE.INSTRUMENT_DETAILS_ID =
																ISCMSD.INSTRUMENT_DETAILS_ID
															AND ISCMSD.PORTFOLIO_CODE = : portfolio_code
															AND ISCMSD.BUSINESS_DATE <= : to_date)
												AND P_CAP_MKT_PRICE.INSTRUMENT_DETAILS_ID =
													ISCMS.INSTRUMENT_DETAILS_ID
												AND P_CAP_MKT_PRICE.INSTRUMENT_DETAILS_ID =
													LSID.INSTRUMENT_DETAILS_ID
												AND ISCMS.I_BROKER_CHARGE_ID = IBRKCHG.I_BROKER_CHARGE_ID
												AND INDV.PORTFOLIO_CODE = ISCMS.PORTFOLIO_CODE
												AND ISCMS.PORTFOLIO_CODE = IBRKCHG.PORTFOLIO_CODE
												AND GS_SECTOR.SECTOR_ID = LSID.SECTOR_ID
												AND ISCMS.TOTAL_SHARE > 0
												AND P_CAP_MKT_PRICE.CAP_MKT_PRICE_HISTORY_ID =
													(SELECT MAX (
																P_CAP_MKT_PRICE_HISTORY.CAP_MKT_PRICE_HISTORY_ID)
														FROM P_CAP_MKT_PRICE_HISTORY
													WHERE     P_CAP_MKT_PRICE_HISTORY.INSTRUMENT_DETAILS_ID =
																LSID.INSTRUMENT_DETAILS_ID
															AND P_CAP_MKT_PRICE_HISTORY.BUSINESS_DATE =
																(SELECT MAX (
																			P_CAP_MKT_PRICE_HISTORY.BUSINESS_DATE)
																	FROM P_CAP_MKT_PRICE_HISTORY
																WHERE     P_CAP_MKT_PRICE_HISTORY.INSTRUMENT_DETAILS_ID =
																			LSID.INSTRUMENT_DETAILS_ID
																		AND P_CAP_MKT_PRICE_HISTORY.BUSINESS_DATE <= : to_date))
										GROUP BY ISCMS.PORTFOLIO_CODE) CSOTVAL
										ON PSTM.PORTFOLIO_CODE = CSOTVAL.PORTFOLIO_CODE
								WHERE PSTM.PORTFOLIO_CODE = : portfolio_code
								AND PSTM.BUSINESS_DATE = : to_date) CLOSIINGVAL
								ON PSTM.PORTFOLIO_CODE = CLOSIINGVAL.PORTFOLIO_CODE
								
								LEFT JOIN 
							(SELECT PSTM.PORTFOLIO_CODE,
									NVL (PSTM.EQUITY, 0)                      AS OPENING_EQUITY,
									NVL (PSTM.MARKET_VALUE_SECURITIES, 0)     AS OPENING_MKT_VALUE_SEC,
									NVL (CSOTVAL.COST_VAL_SECURITIES, 0)      AS OPENING_COST_VAL_SEC,
									NVL (PSTM.CURRENT_BALANCE, 0)             AS OPENING_CURRENT_BALANCE,
									NVL (PSTM.RECEIVABLES_SALES, 0)           AS OPENING_RECEIVABLES_SALES
								FROM P_PORTFOLIO_STATEMENT_TEMP  PSTM
									LEFT JOIN
									(  SELECT ISCMS.PORTFOLIO_CODE,
												SUM (ISCMS.TOTAL_SHARE * ISCMS.AVG_RATE)
													COST_VAL_SECURITIES
											FROM IS_CAP_MKT_STOCK       ISCMS,
												LS_INSTRUMENT_DETAILS  LSID,
												P_CAP_MKT_PRICE_HISTORY P_CAP_MKT_PRICE,
												IS_I_BROKER_CHARGE     IBRKCHG,
												IS_INVESTOR_DETAILS    INDV,
												GS_SECTOR
										WHERE     ISCMS.CAP_MKT_STOCK_ID =
													(SELECT MAX (ISCMSD.CAP_MKT_STOCK_ID)
														FROM IS_CAP_MKT_STOCK ISCMSD
													WHERE     ISCMSD.INSTRUMENT_DETAILS_ID =
																ISCMS.INSTRUMENT_DETAILS_ID
															AND ISCMS.PORTFOLIO_CODE = ISCMSD.PORTFOLIO_CODE
															AND LSID.INSTRUMENT_DETAILS_ID =
																ISCMSD.INSTRUMENT_DETAILS_ID
															AND P_CAP_MKT_PRICE.INSTRUMENT_DETAILS_ID =
																ISCMSD.INSTRUMENT_DETAILS_ID
															AND ISCMSD.PORTFOLIO_CODE = : portfolio_code
															AND ISCMSD.BUSINESS_DATE <= : from_date )
												AND P_CAP_MKT_PRICE.INSTRUMENT_DETAILS_ID =
													ISCMS.INSTRUMENT_DETAILS_ID
												AND P_CAP_MKT_PRICE.INSTRUMENT_DETAILS_ID =
													LSID.INSTRUMENT_DETAILS_ID
												AND ISCMS.I_BROKER_CHARGE_ID = IBRKCHG.I_BROKER_CHARGE_ID
												AND INDV.PORTFOLIO_CODE = ISCMS.PORTFOLIO_CODE
												AND ISCMS.PORTFOLIO_CODE = IBRKCHG.PORTFOLIO_CODE
												AND GS_SECTOR.SECTOR_ID = LSID.SECTOR_ID
												AND ISCMS.TOTAL_SHARE > 0
												AND P_CAP_MKT_PRICE.CAP_MKT_PRICE_HISTORY_ID =
													(SELECT MAX (
																P_CAP_MKT_PRICE_HISTORY.CAP_MKT_PRICE_HISTORY_ID)
														FROM P_CAP_MKT_PRICE_HISTORY
													WHERE     P_CAP_MKT_PRICE_HISTORY.INSTRUMENT_DETAILS_ID =
																LSID.INSTRUMENT_DETAILS_ID
															AND P_CAP_MKT_PRICE_HISTORY.BUSINESS_DATE =
																(SELECT MAX (
																			P_CAP_MKT_PRICE_HISTORY.BUSINESS_DATE)
																	FROM P_CAP_MKT_PRICE_HISTORY
																WHERE     P_CAP_MKT_PRICE_HISTORY.INSTRUMENT_DETAILS_ID =
																			LSID.INSTRUMENT_DETAILS_ID
																		AND P_CAP_MKT_PRICE_HISTORY.BUSINESS_DATE <= : from_date ))
										GROUP BY ISCMS.PORTFOLIO_CODE) CSOTVAL
										ON PSTM.PORTFOLIO_CODE = CSOTVAL.PORTFOLIO_CODE
								WHERE PSTM.PORTFOLIO_CODE = : portfolio_code
								AND PSTM.BUSINESS_DATE = : from_date_op) OPENINGVAL
							ON PSTM.PORTFOLIO_CODE = OPENINGVAL.PORTFOLIO_CODE
							
							 LEFT JOIN (SELECT INVDETS.PORTFOLIO_CODE,
										NVL((SUM(CDIV.GROSS_DIV_AMOUNT)), 0) AS RECEIVED_DIVIDEND,
										NVL((SUM(CDIV.TAX_DIV_AMOUNT)), 0) AS TAX_DIVIDEND
								   FROM IS_CASH_DIVIDEND    CDIV,
										IS_DIVIDEND_DETAILS DIVDETAILS,
										IS_INVESTOR_DETAILS INVDETS
								  WHERE DIVDETAILS.DIVIDEND_DETAILS_ID =
										CDIV.DIVIDEND_DETAILS_ID
									AND CDIV.PORTFOLIO_CODE = INVDETS.PORTFOLIO_CODE
									AND CDIV.ADJUSTMENT_DATE BETWEEN
										: from_date  AND : to_date
									AND CDIV.ADJUSTMENT_DATE IS NOT NULL
									AND INVDETS.ACCOUNT_CLOSE = 'n'
									AND INVDETS.PORTFOLIO_CODE = : portfolio_code
								  GROUP BY INVDETS.PORTFOLIO_CODE) DIV_DETAILS
						ON PSTM.PORTFOLIO_CODE = DIV_DETAILS.PORTFOLIO_CODE
						LEFT JOIN 
						(SELECT  INDV.PORTFOLIO_CODE,
									SUM(IS_CAP_MKT_STOCK.BROKER_COMMISSION) AS BROKER_COMMISSION,
									SUM(IS_CAP_MKT_STOCK.SHARES*(SELECT ISCMS.AVG_RATE
										FROM IS_CAP_MKT_STOCK ISCMS
									WHERE ISCMS.CAP_MKT_STOCK_ID =
											(SELECT MAX(CMS.CAP_MKT_STOCK_ID)
												FROM IS_CAP_MKT_STOCK CMS
											WHERE CMS.CAP_MKT_STOCK_ID <
													IS_CAP_MKT_STOCK.CAP_MKT_STOCK_ID
												AND CMS.INSTRUMENT_DETAILS_ID =
													IS_CAP_MKT_STOCK.INSTRUMENT_DETAILS_ID
										AND CMS.PORTFOLIO_CODE = IS_CAP_MKT_STOCK.PORTFOLIO_CODE))) AS BUY_AMOUNT,
									SUM(IS_CAP_MKT_STOCK.TOTAL_AMOUNT) AS SALE_AMOUNT
								FROM IS_CAP_MKT_STOCK, LS_INSTRUMENT_DETAILS LSID, IS_INVESTOR_DETAILS INDV, IS_I_BROKER_CHARGE IBRKCHG
								WHERE LSID.INSTRUMENT_DETAILS_ID = IS_CAP_MKT_STOCK.INSTRUMENT_DETAILS_ID
									AND IS_CAP_MKT_STOCK.PORTFOLIO_CODE = : portfolio_code
									AND IBRKCHG.PORTFOLIO_CODE = : portfolio_code
									AND INDV.PORTFOLIO_CODE = : portfolio_code
									AND IS_CAP_MKT_STOCK.I_BROKER_CHARGE_ID = IBRKCHG.I_BROKER_CHARGE_ID
									AND IS_CAP_MKT_STOCK.STATUS = 'enc'
									AND IS_CAP_MKT_STOCK.STOCK_MATURE_DATE IS NULL
									AND IS_CAP_MKT_STOCK.BUSINESS_DATE BETWEEN : from_date  AND : to_date
									GROUP BY INDV.PORTFOLIO_CODE
								) REAL_DATA
								ON PSTM.PORTFOLIO_CODE = REAL_DATA.PORTFOLIO_CODE
						
							WHERE PSTM.PORTFOLIO_CODE = : portfolio_code 
							AND PSTM.BUSINESS_DATE = : to_date
        ";
        $data = DB::select(
            $sql,
            [
                'from_date_op'   => $fromDateOp,
                'from_date'      => $fromDate->format('Y-m-d'),
                'to_date'        => $toDate->format('Y-m-d'),
                'portfolio_code' => $portfolioCode,
            ]
        );
        return $data;
    }

}
