<?php echo $__env->make('common.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<tr>
    <td colspan="2" style="border: none;">Report Name</td>
    <td colspan="9" style="border: none;">: Capital Gain/Loss (Summary)</td>
</tr>

<tr>
    <td colspan="2" style="border: none;">Period</td>
    <td colspan="9" style="border: none;">: <?php echo e($report_date); ?></td>
</tr>

<tr>
    <th colspan="2" style="text-align: left; width:2%; border: 1px solid #030303;">SL# </th>
    <th style="text-align: left; width: 8%; border: 1px solid #030303;">Sell Date</th>
    <th style="text-align: left; width: 20%; border: 1px solid #030303;">Instrument Name</th>
    <th style="text-align: right; width: 8%; border: 1px solid #030303;">No. of Shares </th>
    <th style="text-align: right; width: 10%; border: 1px solid #030303;">Sale Rate</th>
    <th style="text-align: right; width: 10%; border: 1px solid #030303;">Sale Amount</th>
    <th style="text-align: right; width: 10%; border: 1px solid #030303;">Pur. Rate</th>
    <th style="text-align: right; width: 10%; border: 1px solid #030303;">Purchase Amount</th>
    <th style="text-align: right; width: 10%; border: 1px solid #030303;">Realize Gain/Loss</th>
    <th style="text-align: right; width: 10%; border: 1px solid #030303;">Gain/Loss (With Commission)</th>
</tr>

<?php $__currentLoopData = $gainLossData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr>
        <td colspan="2" style="text-align: left;"><?php echo e(($index + 1)); ?></td>
        <td style="text-align: left;"><?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $value->business_date)->format('d-m-Y')); ?></td>
        <td style="text-align: left;"><?php echo e($value->instrument_name); ?></td>
        <td style="text-align: right;"><?php echo e(number_format($value->no_of_shares, 0)); ?></td>
        <td style="text-align: right;"><?php echo e(number_format($value->actual_rate, 2)); ?></td>
        <td style="text-align: right;"><?php echo e(number_format($value->sale_amount, 2)); ?></td>
        <td style="text-align: right;"><?php echo e(number_format($value->purchase_rate, 2)); ?></td>
        <td style="text-align: right;"><?php echo e(number_format($value->purchase_amount, 2)); ?></td>
        <td style="text-align: right;"><?php echo e(number_format($value->capital_gain_without_com, 2)); ?></td>
        <td style="text-align: right;"><?php echo e(number_format($value->capital_gain, 2)); ?></td>
    </tr> 
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<tr>
    <td colspan="2" style="text-align: left;"></td>
    <td style="text-align: left;"></td>
    <td style="text-align: left;"></td>
    <td style="text-align: right;"></td>
    <td style="text-align: right;">Total</td>
    <td style="text-align: right;"><?php echo e(number_format($totalSaleAmount, 2)); ?></td>
    <td style="text-align: right;"></td>
    <td style="text-align: right;"><?php echo e(number_format($totalPurchaseAmount, 2)); ?></td>
    <td style="text-align: right;"><?php echo e(number_format($totalGainLossWWithoutCommission, 2)); ?></td>
    <td style="text-align: right;"><?php echo e(number_format($totalGainLoss, 2)); ?></td>
</tr>

<tr>
    <td colspan="11" style="border-right: none; border-bottom: none; border-left: none;"></td>
</tr>
<?php echo $__env->make('common.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\uslwmcbil_api\resources\views/gainloss/index.blade.php ENDPATH**/ ?>