'use client'
import { useState, useRef, useEffect } from "react";
import { signOut, useSession } from "next-auth/react";
import Swal from "sweetalert2";
import Loading from "../loading";
import styles from "../../assets/style.module.css";

const ClientComponent = () => {
    const [isLoading, setIsLoading] = useState(false)
    const { data } = useSession()
    const prevToken = useRef(null)
    const [investor, setInvestor] = useState([])

    useEffect(() => {
        let token;
        if (data && data.user && data.user.token && data.user.token !== prevToken.current) {
            setIsLoading(true)
            token = data.user.token
            prevToken.current = token
            fetchPersonalInfo(token);
        }
    }, [data?.user?.token])

    const fetchPersonalInfo = async (token) => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/acknowledgement-slip';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer ' + String(token)
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                setInvestor(data.investor_information)
            } else if (res.status == 401) {
                Swal.fire({
                    position: "top-end",
                    icon: "warning",
                    title: data.message,
                    showConfirmButton: false,
                    timer: 1000,
                }).then((result) => {
                    if (result.dismiss === Swal.DismissReason.timer) {
                        signOut();
                    }
                });
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        } finally {
            setIsLoading(false)
        }
    };

    if (isLoading) {
        return (
            <Loading loading={isLoading} />
        )
    }

    return (
        <>
            <div style={{ width: '100%' }} className={`${styles.d_flex} ${styles.mx_20} ${styles.mt_sm_35}`}>
                {investor && Object.keys(investor).length > 0 && (
                    <table style={{ width: '100%' }}>
                        <tbody>
                            <tr>
                                <td>
                                    Investor's Name
                                </td>
                                <td>
                                    {investor.investor_name}
                                </td>
                                <td>
                                    Occupation
                                </td>
                                <td>
                                    {investor.occupation}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Father's Name
                                </td>
                                <td>
                                    {investor.father_name}
                                </td>
                                <td>
                                    Mother's Name
                                </td>
                                <td>
                                    {investor.mother_name}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Business Address
                                </td>
                                <td>
                                    {investor.business_address}
                                </td>
                                <td>
                                    Home Address
                                </td>
                                <td>
                                    {investor.home_address}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Date of Birth
                                </td>
                                <td>
                                    {investor.date_of_birth}
                                </td>
                                <td>
                                    Passport No.
                                </td>
                                <td>
                                    {investor.passport_no}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Nationality
                                </td>
                                <td>
                                    {investor.nationality}
                                </td>
                                <td>
                                    Issue Place
                                </td>
                                <td>
                                    {investor.issue_place}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Office Phone No.
                                </td>
                                <td>
                                    {investor.office_phone_no}
                                </td>
                                <td>
                                    Issue Date
                                </td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>
                                    Home Phone No.
                                </td>
                                <td>
                                    {investor.home_phone_no}
                                </td>
                                <td>
                                    Valid Till
                                </td>
                                <td>
                                    {investor.valid_till}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Mobile No.
                                </td>
                                <td>
                                    {investor.mobile_no}
                                </td>
                                <td>
                                    Fax No.
                                </td>
                                <td>
                                    {investor.fax_no}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    E-Mail.
                                </td>
                                <td>
                                    {investor.email}
                                </td>
                                <td>
                                    Telex
                                </td>
                                <td>
                                    {investor.telex}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    NID
                                </td>
                                <td>
                                    {investor.identity_no}
                                </td>
                                <td>
                                    Tin
                                </td>
                                <td>
                                    {investor.tin}
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    Investor's Account No.
                                </td>
                                <td>
                                    {investor.investor_account_no}
                                </td>
                                <td>
                                    Connecting Branch
                                </td>
                                <td>
                                    {investor.connecting_branch}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Account Type
                                </td>
                                <td>
                                    {investor.account_type}
                                </td>
                                <td>
                                    Operation Type
                                </td>
                                <td>
                                    {investor.operation_type}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Sub Account Type
                                </td>
                                <td>
                                    {investor.sub_account_type}
                                </td>
                                <td>
                                    Opening Date
                                </td>
                                <td>
                                    {investor.opening_date}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Bank Name
                                </td>
                                <td>
                                    {investor.bank_name}
                                </td>
                                <td>
                                    Special Instruction
                                </td>
                                <td>
                                    {investor.special_instruction}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Branch Name
                                </td>
                                <td>
                                    {investor.branch_name}
                                </td>
                                <td>
                                    Introducer Name
                                </td>
                                <td>
                                    {investor.introducer_name}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Bank Account No.
                                </td>
                                <td>
                                    {investor.bank_account_no}
                                </td>
                                <td>
                                    Introducer Account
                                </td>
                                <td>
                                    {investor.introducer_account}
                                </td>
                            </tr>

                        </tbody>
                    </table>
                )}
            </div>
        </>
    )
}

export default ClientComponent;