import ClientComponent from "./ClientComponent"
import JointClientComponent from "./JointClientComponent"
import NomineeClientComponent from "./NomineeClientComponent"
import styles from "../../assets/style.module.css";
import Logo from "../logo";

export const metadata={
    title:'Personal Information - '+process.env.APP_NAME,
    description:'process.env.APP_NAME'
}

const Profile = () => {
    return (
        <>
            <div className={`${styles.card} ${styles.card_slide_down} ${styles.vh_80} ${styles.mt_35} ${styles.mb_20} ${styles.pb_30} ${styles.mx_auto}`}>
                <Logo title="Personal Information"/>
                <div className={`${styles.d_flex} ${styles.flex_direction_col_md} ${styles.flex_space_around} ${styles.align_item_center}`} >
                    <ClientComponent />
                </div>
                <div className={`${styles.header_logo}`}>
                    <h1 className={`${styles.gradient_text_blue}`}>Joint Applicant Information</h1>
                </div>
                <div className={`${styles.d_flex} ${styles.flex_direction_col_md} ${styles.flex_space_around} ${styles.align_item_center}`} >
                    <JointClientComponent />
                </div>
                <div className={`${styles.header_logo}`}>
                    <h1 className={`${styles.gradient_text_blue}`}>Nominee Information</h1>
                </div>
                <div className={`${styles.d_flex} ${styles.flex_direction_col_md} ${styles.flex_space_around} ${styles.align_item_center}`} >
                    <NomineeClientComponent />
                </div>
            </div>
        </>
    )
}
export default Profile