'use client'
import React, { useState, useEffect } from 'react';
import styles from "../../assets/style.module.css";
import { useStep } from './context';
import Loading from '../loading';
import Swal from 'sweetalert2'
import { useRouter } from 'next/navigation';
import Link from 'next/link';

const ClientComponent = () => {

    const [isLoading, setIsLoading] = useState(false)
    const router                    = useRouter();
    const { step, setStep }         = useStep();

    const [productList, setProductList]             = useState([]);
    const [residentList, setResidentList]           = useState([]);
    const [genderList, setGenderList]               = useState([]);
    const [nationalityList, setNationalityList]     = useState([]);
    const [occupationList, setOccupationList]       = useState([]);
    const [relationshipList, setRelationshipList]   = useState([]);
    const [accountList, setAccountList]             = useState([]);
    const [bankList, setBankList]                   = useState([]);
    const [branchList, setBranchList]               = useState([]);
    const [jointBranchList, setJointBranchList]     = useState([]);
    const [paymentTypeList, setPaymentTypeList]     = useState([]);
    const [operationModeList, setOperationModeList] = useState([]);

    const [verifyOtp, setVerifyOtp]           = useState();
    const [applicantEmail, setApplicantEmail] = useState();
    const [applicantPhone, setApplicantPhone] = useState();
    const [termsCondition, setTermsCondition] = useState();

    const [operationMode, setOperationMode]                         = useState('');
    const [applicantName, setApplicantName]                         = useState();
    const [applicantDOB, setApplicantDOB]                           = useState();
    const [applicantFatherName, setApplicantFatherName]             = useState();
    const [applicantMotherName, setApplicantMotherName]             = useState();
    const [applicantSpouseName, setApplicantSpouseName]             = useState();
    const [applicantId, setApplicantId]                             = useState();
    const [applicantEtin, setApplicantEtin]                         = useState();
    const [applicantBo, setApplicantBo]                             = useState('');
    const [product, setProduct]                                     = useState('');
    const [applicantGender, setApplicantGender]                     = useState('');
    const [applicantResident, setApplicantResident]                 = useState('');
    const [applicantOccupation, setApplicantOccupation]             = useState('');
    const [applicantNationality, setApplicantNationality]           = useState('');
    const [applicantPresentAddress, setApplicantPresentAddress]     = useState();
    const [applicantPermanentAddress, setApplicantPermanentAddress] = useState();
    const [boLink, setBoLink]                                       = useState(false);
    const [applicantBank, setApplicantBank]                         = useState('');
    const [applicantBranch, setApplicantBranch]                     = useState('');
    const [applicantAccountNo, setApplicantAccountNo]               = useState('')


    const [jointApplicantEmail, setJointApplicantEmail]                       = useState();
    const [jointApplicantPhone, setJointApplicantPhone]                       = useState();
    const [jointApplicantName, setJointApplicantName]                         = useState();
    const [jointApplicantDOB, setJointApplicantDOB]                           = useState();
    const [jointApplicantFatherName, setJointApplicantFatherName]             = useState();
    const [jointApplicantMotherName, setJointApplicantMotherName]             = useState();
    const [jointApplicantSpouseName, setJointApplicantSpouseName]             = useState();
    const [jointApplicantId, setJointApplicantId]                             = useState();
    const [jointApplicantEtin, setJointApplicantEtin]                         = useState();
    const [jointApplicantResident, setJointApplicantResident]                 = useState('');
    const [jointApplicantOccupation, setJointApplicantOccupation]             = useState('');
    const [jointApplicantNationality, setJointApplicantNationality]           = useState('');
    const [jointRelation, setJointRelation]                                   = useState('');
    const [jointApplicantPresentAddress, setJointApplicantPresentAddress]     = useState();
    const [jointApplicantPermanentAddress, setJointApplicantPermanentAddress] = useState();
    const [jointBank, setJointBank]                                           = useState('');
    const [jointBranch, setJointBranch]                                       = useState('');
    const [jointAccountNo, setJointAccountNo]                                 = useState('')

    const [verifyOtpError, setVerifyOtpError] = useState();

    const [operationModeError, setOperationModeError]                         = useState();
    const [applicantNameError, setApplicantNameError]                         = useState();
    const [applicantDOBError, setApplicantDOBError]                           = useState();
    const [applicantFatherNameError, setApplicantFatherNameError]             = useState();
    const [applicantMotherNameError, setApplicantMotherNameError]             = useState();
    const [applicantSpouseNameError, setApplicantSpouseNameError]             = useState();
    const [applicantEmailError, setApplicantEmailError]                       = useState();
    const [applicantPhoneError, setApplicantPhoneError]                       = useState();
    const [termsConditionError, setTermsConditionError]                       = useState();
    const [applicantIdError, setApplicantIdError]                             = useState();
    const [applicantEtinError, setApplicantEtinError]                         = useState();
    const [applicantBoError, setApplicantBoError]                             = useState();
    const [productError, setProductError]                                     = useState();
    const [applicantGenderError, setApplicantGenderError]                     = useState();
    const [applicantResidentError, setApplicantResidentError]                 = useState();
    const [applicantOccupationError, setApplicantOccupationError]             = useState();
    const [applicantNationalityError, setApplicantNationalityError]           = useState();
    const [applicantPresentAddressError, setApplicantPresentAddressError]     = useState();
    const [applicantPermanentAddressError, setApplicantPermanentAddressError] = useState();
    const [boLinkError, setBoLinkError]                                       = useState();
    const [applicantBankError, setApplicantBankError]                         = useState('');
    const [applicantBranchError, setApplicantBranchError]                     = useState('');
    const [applicantAccountNoError, setApplicantAccountNoError]               = useState('')

    const [jointApplicantEmailError, setJointApplicantEmailError]                       = useState();
    const [jointApplicantPhoneError, setJointApplicantPhoneError]                       = useState();
    const [jointApplicantNameError, setJointApplicantNameError]                         = useState();
    const [jointApplicantDOBError, setJointApplicantDOBError]                           = useState();
    const [jointApplicantFatherNameError, setJointApplicantFatherNameError]             = useState();
    const [jointApplicantMotherNameError, setJointApplicantMotherNameError]             = useState();
    const [jointApplicantSpouseNameError, setJointApplicantSpouseNameError]             = useState();
    const [jointApplicantIdError, setJointApplicantIdError]                             = useState();
    const [jointApplicantEtinError, setJointApplicantEtinError]                         = useState();
    const [jointApplicantResidentError, setJointApplicantResidentError]                 = useState();
    const [jointApplicantOccupationError, setJointApplicantOccupationError]             = useState();
    const [jointApplicantNationalityError, setJointApplicantNationalityError]           = useState();
    const [jointRelationError, setJointRelationError]                                   = useState();
    const [jointApplicantPresentAddressError, setJointApplicantPresentAddressError]     = useState();
    const [jointApplicantPermanentAddressError, setJointApplicantPermanentAddressError] = useState();
    const [jointBankError, setJointBankError]                                           = useState();
    const [jointBranchError, setJointBranchError]                                       = useState();
    const [jointAccountNoError, setJointAccountNoError]                                 = useState()


    const [nomineeInputs, setNomineeInputs]                 = useState(['']);
    const [nomineeName, setNomineeName]                     = useState([]);
    const [sharePercentage, setSharePercentage]             = useState([]);
    const [nomineeDob, setNomineeDob]                       = useState([]);
    const [nomineeFatherName, setNomineeFatherName]         = useState([]);
    const [nomineeMotherName, setNomineeMotherName]         = useState([]);
    const [nomineeSpouseName, setNomineeSpouseName]         = useState([]);
    const [nomineeEmail, setNomineeEmail]                   = useState([]);
    const [nomineePhone, setNomineePhone]                   = useState([]);
    const [nomineeOccupation, setNomineeOccupation]         = useState([]);
    const [nomineeId, setNomineeId]                         = useState([]);
    const [nomineeRelation, setNomineeRelation]             = useState([]);
    const [nomineeMailingAddress, setNomineeMailingAddress] = useState([]);

    const [account, setAccount]               = useState('');
    const [bank, setBank]                     = useState('');
    const [instrumentDate, setInstrumentDate] = useState();
    const [instrumentNo, setInstrumentNo]     = useState();
    const [paymentType, setPaymentType]       = useState('');
    const [depositSlip, setDepositSlip]       = useState();
    const [depositAmount, setDepositAmount]   = useState();

    const [accountError, setAccountError]               = useState();
    const [bankError, setBankError]                     = useState();
    const [instrumentDateError, setInstrumentDateError] = useState();
    const [instrumentNoError, setInstrumentNoError]     = useState();
    const [paymentTypeError, setPaymentTypeError]       = useState();
    const [depositSlipError, setDepositSlipError]       = useState();
    const [depositAmountError, setDepositAmountError]   = useState();

    const [nomineeNameError, setNomineeNameError]                     = useState([]);
    const [sharePercentageError, setSharePercentageError]             = useState([]);
    const [nomineeDobError, setNomineeDobError]                       = useState([]);
    const [nomineeFatherNameError, setNomineeFatherNameError]         = useState([]);
    const [nomineeMotherNameError, setNomineeMotherNameError]         = useState([]);
    const [nomineeSpouseNameError, setNomineeSpouseNameError]         = useState([]);
    const [nomineeEmailError, setNomineeEmailError]                   = useState([]);
    const [nomineePhoneError, setNomineePhoneError]                   = useState([]);
    const [nomineeOccupationError, setNomineeOccupationError]         = useState([]);
    const [nomineeIdError, setNomineeIdError]                         = useState([]);
    const [nomineeRelationError, setNomineeRelationError]             = useState([]);
    const [nomineeMailingAddressError, setNomineeMailingAddressError] = useState([]);

    const [applicantPhoto, setApplicantPhoto]               = useState();
    const [applicantSignature, setApplicantSignature]       = useState();
    const [applicantNidPhoto, setApplicantNidPhoto]         = useState();
    const [applicantNidBackPhoto, setApplicantNidBackPhoto] = useState();
    const [applicantBankLeaf, setApplicantBankLeaf]         = useState();
    const [linkBoAttachment, setLinkBoAttachment]           = useState();

    const [applicantPhotoError, setApplicantPhotoError]               = useState();
    const [applicantSignatureError, setApplicantSignatureError]       = useState();
    const [applicantNidPhotoError, setApplicantNidPhotoError]         = useState();
    const [applicantNidBackPhotoError, setApplicantNidBackPhotoError] = useState();
    const [applicantBankLeafError, setApplicantBankLeafError]         = useState();
    const [linkBoAttachmentError, setLinkBoAttachmentError]           = useState();

    const [jointApplicantPhoto, setJointApplicantPhoto]               = useState();
    const [jointApplicantSignature, setJointApplicantSignature]       = useState();
    const [jointApplicantNidPhoto, setJointApplicantNidPhoto]         = useState();
    const [jointApplicantNidBackPhoto, setJointApplicantNidBackPhoto] = useState();

    const [jointApplicantPhotoError, setJointApplicantPhotoError]               = useState();
    const [jointApplicantSignatureError, setJointApplicantSignatureError]       = useState();
    const [jointApplicantNidPhotoError, setJointApplicantNidPhotoError]         = useState();
    const [jointApplicantNidBackPhotoError, setJointApplicantNidBackPhotoError] = useState();

    const [nomineePhoto, setNomineePhoto]               = useState([]);
    const [nomineeSignature, setNomineeSignature]       = useState([]);
    const [nomineeNidPhoto, setNomineeNidPhoto]         = useState([]);
    const [nomineeNidBackPhoto, setNomineeNidBackPhoto] = useState([]);

    const [nomineePhotoError, setNomineePhotoError]               = useState([]);
    const [nomineeSignatureError, setNomineeSignatureError]       = useState([]);
    const [nomineeNidPhotoError, setNomineeNidPhotoError]         = useState([]);
    const [nomineeNidBackPhotoError, setNomineeNidBackPhotoError] = useState([]);

    const [investorDetailsId, setInvestorDetailsId] = useState();
    const [jointInvestorId, setJointInvestorId]     = useState();
    const [nomineeInfoId, setNomineeInfoId]         = useState([]);

    const [invalidInputs, setInvalidInputs] = useState({});

    useEffect(() => {
        const inputs = document.querySelectorAll('input')
        inputs.forEach(input => {
            if (!input.hasAttribute('required') && input.value.trim() !== '') {
                input.classList.add(styles.invalid);
            }
        })
    }, [step])


    const handleInputChange = (e, setStateFunction, index = null) => {
        let element = e.target
        element.classList.add(styles.invalid)
        let children = element.parentElement.children;
        children[children.length - 1].textContent = element.validationMessage

        let isValid = true;
        setInvalidInputs(prevState => ({
            ...prevState,
            [element.name]: isValid
        }));

        if (element.name == 'bank' || element.name == 'applicantBank' || element.name == 'jointBank') {
            if(element.name == 'applicantBank'){
                fetchBranchList(element.value,'investor')
            }else if(element.name == 'jointBank'){
                fetchBranchList(element.value,'joint_investor')
            }
            setStateFunction(element.value)
        } else if (element.type == 'file') {
            if (index == null) {
                setStateFunction(element.files[0])
            } else {
                setStateFunction(prevState => {
                    const newState = [...prevState];
                    newState[index] = element.files[0];
                    return newState;
                });
            }
        } else if (element.type == 'checkbox') {
            const value = element.checked ? 'checked' : '';
            setStateFunction(value)
        } else if (step == 4) {
            if (index == 0 && element.name == 'sharePercentage-0' && parseInt(element.value) < 100) {
                if (nomineeInputs.length <= 1) {
                    setNomineeInputs(prevNomineeInputs => [...prevNomineeInputs, '']);
                }
            } else if (index != 1 && element.name == 'sharePercentage-0') {
                setNomineeInputs(prevInputs => {
                    if (prevInputs.length > 1) {
                        return prevInputs.slice(0, -1);
                    } else {
                        return prevInputs;
                    }
                });
            }
            setStateFunction(prevState => {
                const newState = [...prevState];
                newState[index] = element.value;
                return newState;
            });
        } else {
            setStateFunction(element.value)
        }

    };

    const handleSubmit = async (e) => {
        e.preventDefault()
        setIsLoading(true)

        const formData = new FormData();
        if (step == 1) {
            formData.append('email', applicantEmail)
            formData.append('contact_number', applicantPhone)
        } else if (step == 2) {
            formData.append('otp_code', verifyOtp)
            formData.append('email', applicantEmail)
            formData.append('contact_number', applicantPhone)
        } else if (step == 3) {
            formData.append('operation_mode', operationMode)
            formData.append('email', applicantEmail)
            formData.append('contact_number', applicantPhone)
            formData.append('investor_name', applicantName)
            formData.append('date_of_birth', applicantDOB)
            formData.append('product_id', product)
            formData.append('gender', applicantGender)
            formData.append('father_name', applicantFatherName)
            formData.append('mother_name', applicantMotherName)
            formData.append('spouse_name', applicantSpouseName)
            formData.append('residency', applicantResident)
            formData.append('nid_number', applicantId)
            formData.append('occupation_id', applicantOccupation)
            formData.append('nationality', applicantNationality)
            formData.append('e_tin', applicantEtin)
            formData.append('link_bo', boLink)
            formData.append('link_bo_account_number', applicantBo)
            formData.append('present_address', applicantPermanentAddress)
            formData.append('permanent_address', applicantPermanentAddress)
            formData.append('bank_id', applicantBank)
            formData.append('branch_id', applicantBranch)
            formData.append('bank_account_no', applicantAccountNo)
            if (operationMode == 2) {
                formData.append('ja_email', jointApplicantEmail)
                formData.append('ja_contact_number', jointApplicantPhone)
                formData.append('ja_investor_name', jointApplicantName)
                formData.append('ja_date_of_birth', jointApplicantDOB)
                formData.append('ja_father_name', jointApplicantFatherName)
                formData.append('ja_mother_name', jointApplicantMotherName)
                formData.append('ja_spouse_name', jointApplicantSpouseName)
                formData.append('ja_residency', jointApplicantResident)
                formData.append('ja_nid_number', jointApplicantId)
                formData.append('ja_occupation_id', jointApplicantOccupation)
                formData.append('ja_nationality', jointApplicantNationality)
                formData.append('ja_relationship_id', jointRelation)
                formData.append('ja_present_address', jointApplicantPresentAddress)
                formData.append('ja_permanent_address', jointApplicantPermanentAddress)
                formData.append('ja_bank_id', jointBank)
                formData.append('ja_branch_id', jointBranch)
                formData.append('ja_bank_account_no', jointAccountNo)
            }

        } else if (step == 4) {
            formData.append('investor_details_id', investorDetailsId)
            for (let i = 0; i < nomineeName.length; i++) {
                formData.append('nominee_full_name[]', (nomineeName[i] ? nomineeName[i] : ''))
                formData.append('nominee_share[]', (sharePercentage[i] ? sharePercentage[i] : ''))
                formData.append('nominee_date_of_birth[]', (nomineeDob[i] ? nomineeDob[i] : ''))
                formData.append('nominee_father_name[]', (nomineeFatherName[i] ? nomineeFatherName[i] : ''))
                formData.append('nominee_mother_name[]', (nomineeMotherName[i] ? nomineeMotherName[i] : ''))
                formData.append('nominee_spouse_name[]', (nomineeSpouseName[i] ? nomineeSpouseName[i] : ''))
                formData.append('nominee_email[]', (nomineeEmail[i] ? nomineeEmail[i] : ''))
                formData.append('nominee_contact_number[]', (nomineePhone[i] ? nomineePhone[i] : ''))
                formData.append('nominee_nid[]', (nomineeId[i] ? nomineeId[i] : ''))
                formData.append('nominee_occupation_id[]', (nomineeOccupation[i] ? nomineeOccupation[i] : ''))
                formData.append('nominee_relationship_id[]', (nomineeRelation[i] ? nomineeRelation[i] : ''))
                formData.append('nominee_mailing_address[]', (nomineeMailingAddress[i] ? nomineeMailingAddress[i] : ''))
            }
        } else if (step == 5) {
            formData.append('investor_details_id', investorDetailsId)
            formData.append('deposit_account_id', account)
            formData.append('bank_id', (bank != undefined ? bank : ''))
            formData.append('deposit_date', instrumentDate)
            formData.append('deposit_instrument_no', instrumentNo)
            formData.append('payment_type', paymentType)
            formData.append('deposit_slip', depositSlip)
            formData.append('deposit_amount', depositAmount)
        }
        else if (step == 6) {

            formData.append('investor_details_id', investorDetailsId)
            formData.append('investor_photo', applicantPhoto)
            formData.append('investor_nid_photo', applicantNidPhoto)
            formData.append('investor_nid_back_photo', applicantNidBackPhoto)
            formData.append('investor_signature', applicantSignature)
            formData.append('investor_cheque_photo', applicantBankLeaf)

            if (boLink) {
                formData.append('link_bo_photo', linkBoAttachment)
            }

            if (jointInvestorId) {
                formData.append('joint_applicant_photo', jointApplicantPhoto)
                formData.append('joint_applicant_sign', jointApplicantSignature)
                formData.append('joint_bo_photo', jointApplicantNidPhoto)
                formData.append('joint_applicant_nid', jointApplicantNidPhoto)
                formData.append('joint_applicant_nid_back', jointApplicantNidBackPhoto)
            }

            for (let i = 0; i < nomineeName.length; i++) {
                formData.append('nominee_info_id[]', (nomineeInfoId[i] ? nomineeInfoId[i] : ''))
                formData.append('nominee_photo[]', (nomineePhoto[i] ? nomineePhoto[i] : ''))
                formData.append('nominee_nid_photo[]', (nomineeNidPhoto[i] ? nomineeNidPhoto[i] : ''))
                formData.append('nominee_nid_back_photo[]', (nomineeNidBackPhoto[i] ? nomineeNidBackPhoto[i] : ''))
                formData.append('nominee_signature[]', (nomineeSignature[i] ? nomineeSignature[i] : ''))
            }
        }
        const url = process.env.NEXT_PUBLIC_API_URL + '/registation/' + step;

        try {
            const response = await fetch(url, {
                method: 'POST',
                headers: {
                    'Accept': 'application/json'
                },
                body: formData
            });

            const data = await response.json();

            if (data.status == 'success') {
                setStep((step < 6 ? step + 1 : step));
                if (step == 3) {
                    setInvestorDetailsId(data.investor_details_id)
                    setJointInvestorId(data.joint_applicant_id)
                } else if (step == 2) {
                    fetchBankList()
                    fetchProductList()
                    fetchOcupationList()
                    fetchGenderList()
                    fetchResidentList()
                    fetchNationalityList()
                    fetchOperationMode()
                    fetchRelationShipList()
                  
                    if(data.investor_detail){
                        const investor_detail=data.investor_detail
                        console.log(investor_detail)

                        setOperationMode(investor_detail.operation_mode)
                        setApplicantEmail(investor_detail.email)
                        setApplicantPhone(investor_detail.contact_number)
                        setApplicantName(investor_detail.investor_name)
                        setApplicantDOB(investor_detail.date_of_birth)
                        setProduct(investor_detail.product_id)
                        setApplicantGender(investor_detail.gender)
                        setApplicantFatherName(investor_detail.father_name)
                        setApplicantMotherName(investor_detail.mother_name)
                        setApplicantSpouseName(investor_detail.spouse_name)
                        setApplicantResident(investor_detail.residency)
                        setApplicantId(investor_detail.nid_number)
                        setApplicantOccupation(investor_detail.occupation_id)
                        setApplicantNationality(investor_detail.nationality)
                        setBoLink((investor_detail.linked_bo_account_no?true:false))
                        setApplicantBo(investor_detail.linked_bo_account_no)
                        setApplicantPresentAddress((investor_detail.present_address!="undefined"?investor_detail.present_address:""))
                        setApplicantPermanentAddress((investor_detail.permanent_address!="undefined"?investor_detail.permanent_address:""))
                        setApplicantBank(investor_detail.bank_id)
                        fetchBranchList(investor_detail.bank_id,'investor')
                        setApplicantBranch(investor_detail.branch_id)
                        setApplicantAccountNo(investor_detail.bank_account_no)
                       
                    }
                    if(data.nominee_detail.length>0){
                        const nominee_detail=data.nominee_detail

                        nominee_detail.forEach((nominee_detail,index) => {

                            setNomineeName(prevState => {
                                const newState = [...prevState];
                                newState[index] = nominee_detail.nominee_full_name;
                                return newState;
                            });

                            setSharePercentage(prevState => {
                                const newState = [...prevState];
                                newState[index] = nominee_detail.nominee_share;
                                return newState;
                            });

                            setNomineeDob(prevState => {
                                const newState = [...prevState];
                                newState[index] = nominee_detail.nominee_date_of_birth;
                                return newState;
                            });

                            setNomineeFatherName(prevState => {
                                const newState = [...prevState];
                                newState[index] = nominee_detail.nominee_father_name;
                                return newState;
                            });

                            setNomineeMotherName(prevState => {
                                const newState = [...prevState];
                                newState[index] = nominee_detail.nominee_mother_name;
                                return newState;
                            });

                            setNomineeSpouseName(prevState => {
                                const newState = [...prevState];
                                newState[index] = nominee_detail.nominee_spouse_name;
                                return newState;
                            });

                            setNomineeEmail(prevState => {
                                const newState = [...prevState];
                                newState[index] = nominee_detail.nominee_email;
                                return newState;
                            });

                            setNomineePhone(prevState => {
                                const newState = [...prevState];
                                newState[index] = nominee_detail.nominee_contact_number;
                                return newState;
                            });

                            setNomineeOccupation(prevState => {
                                const newState = [...prevState];
                                newState[index] = nominee_detail.nominee_occupation_id;
                                return newState;
                            });

                            setNomineeRelation(prevState => {
                                const newState = [...prevState];
                                newState[index] = nominee_detail.nominee_relationship_id;
                                return newState;
                            });

                            setNomineeMailingAddress(prevState => {
                                const newState = [...prevState];
                                newState[index] = nominee_detail.nominee_mailing_address;
                                return newState;
                            });

                            setNomineeId(prevState => {
                                const newState = [...prevState];
                                newState[index] = nominee_detail.nominee_nid;
                                return newState;
                            });

                        })
                    }
                    if(data.joint_detail){
                        const joint_detail=data.joint_detail

                        setJointApplicantEmail(joint_detail.ja_email)
                        setJointApplicantPhone(joint_detail.ja_contact_number)
                        setJointApplicantName(joint_detail.ja_investor_name)
                        setJointApplicantDOB(joint_detail.ja_date_of_birth)
                        setJointApplicantFatherName(joint_detail.ja_father_name)
                        setJointApplicantMotherName(joint_detail.ja_mother_name)
                        setJointApplicantSpouseName(joint_detail.ja_spouse_name)
                        setJointApplicantResident(joint_detail.ja_residency)
                        setJointApplicantId(joint_detail.ja_nid_number)
                        setJointApplicantOccupation(joint_detail.ja_occupation_id)
                        setJointApplicantNationality(joint_detail.ja_nationality)
                        setJointRelation(joint_detail.ja_relationship_id)
                        setJointApplicantPresentAddress(joint_detail.ja_present_address)
                        setJointApplicantPermanentAddress(joint_detail.ja_permanent_address)
                        setJointBank(joint_detail.ja_bank_id)
                        fetchBranchList(joint_detail.ja_bank_id,'joint_investor')
                        setJointBranch(joint_detail.ja_branch_id)
                        setJointAccountNo(joint_detail.ja_bank_account_no)
                    }

                    if(data.transaction_detail){
                        const transaction_detail=data.transaction_detail

                        setAccount(transaction_detail.deposit_account_id)
                        setBank(transaction_detail.bank_id)
                        setInstrumentDate(transaction_detail.deposit_date)
                        setInstrumentNo(transaction_detail.deposit_instrument_no)
                        setPaymentType(transaction_detail.payment_type)
                        setDepositAmount(transaction_detail.deposit_amount)

                    }
                } else if (step == 4) {
                    setNomineeInfoId(data.nominee_info_id)
                    fetchAccountList()
                    fetchBankList()
                    fetchPaymentType()
                }
                if (step == 6) {
                    Swal.fire({
                        position: "top-end",
                        icon: "success",
                        title: data.message,
                        showConfirmButton: false,
                        timer: 1500,
                    }).then((result) => {
                        if (result.dismiss === Swal.DismissReason.timer) {
                            router.push('/login');
                            router.refresh();
                        }
                    });
                } else {
                    Swal.fire({
                        position: "top-end",
                        icon: "success",
                        title: data.message,
                        showConfirmButton: false,
                        timer: 2000,
                    });
                }

            } else if (data.errors != undefined) {
                if (step == 1) {
                    var setters = {
                        email: setApplicantEmailError,
                        contact_number: setApplicantPhoneError,
                    };
                } else if (step == 2) {
                    var setters = {
                        otp_code: setVerifyOtpError
                    };
                } else if (step == 3) {
                    var setters = {
                        operation_mode        : setOperationModeError,
                        investor_name         : setApplicantNameError,
                        date_of_birth         : setApplicantDOBError,
                        father_name           : setApplicantFatherNameError,
                        mother_name           : setApplicantMotherNameError,
                        spouse_name           : setApplicantSpouseNameError,
                        nid_number            : setApplicantIdError,
                        e_tin                 : setApplicantEtinError,
                        link_bo_account_number: setApplicantBoError,
                        product_id            : setProductError,
                        gender                : setApplicantGenderError,
                        residency             : setApplicantResidentError,
                        occupation_id         : setApplicantOccupationError,
                        nationality           : setApplicantNationalityError,
                        present_address       : setApplicantPresentAddressError,
                        permanent_address     : setApplicantPermanentAddressError,
                        bank_id               : setApplicantBankError,
                        branch_id             : setApplicantBranchError,
                        bank_account_no       : setApplicantAccountNoError,

                        ja_email            : setJointApplicantEmailError,
                        ja_contact_number   : setJointApplicantPhoneError,
                        ja_investor_name    : setJointApplicantNameError,
                        ja_date_of_birth    : setJointApplicantDOBError,
                        ja_father_name      : setJointApplicantFatherNameError,
                        ja_mother_name      : setJointApplicantMotherNameError,
                        ja_nid_number       : setJointApplicantIdError,
                        ja_residency        : setJointApplicantResidentError,
                        ja_occupation_id    : setJointApplicantOccupationError,
                        ja_nationality      : setJointApplicantNationalityError,
                        ja_present_address  : setJointApplicantPresentAddressError,
                        ja_permanent_address: setJointApplicantPermanentAddressError,
                        ja_bank_id          : setJointBankError,
                        ja_ranch_id         : setJointBranchError,
                        ja_bank_account_no  : setJointAccountNoError,
                    };
                } else if (step == 4) {
                    var setters = {
                        nominee_full_name      : setNomineeNameError,
                        nominee_share          : setSharePercentageError,
                        nominee_date_of_birth  : setNomineeDobError,
                        nominee_father_name    : setNomineeFatherNameError,
                        nominee_mother_name    : setNomineeMotherNameError,
                        nominee_spouse_name    : setNomineeSpouseNameError,
                        nominee_email          : setNomineeEmailError,
                        nominee_contact_number : setNomineePhoneError,
                        nominee_nid            : setNomineeIdError,
                        nominee_occupation_id  : setNomineeOccupationError,
                        nominee_relationship_id: setNomineeRelationError,
                        nominee_mailing_address: setNomineeMailingAddressError
                    };
                } else if (step == 5) {
                    var setters = {
                        deposit_account_id   : setAccountError,
                        bank_id              : setBankError,
                        deposit_date         : setInstrumentDateError,
                        deposit_instrument_no: setInstrumentNoError,
                        payment_type         : setPaymentTypeError,
                        deposit_slip         : setDepositSlip,
                        deposit_amount       : setDepositAmountError
                    };
                } else if (step == 6) {
                    var setters = {
                        investor_photo       : setApplicantPhotoError,
                        investor_nid_photo   : setApplicantNidPhotoError,
                        investor_signature   : setApplicantSignatureError,
                        investor_cheque_photo: setApplicantBankLeafError,
                        nominee_photo        : setNomineePhotoError,
                        nominee_nid_photo    : setNomineeNidPhotoError,
                        nominee_signature    : setNomineeSignatureError,
                    };
                }

                Object.entries(data.errors).forEach(([key, value]) => {
                    const index = key;
                    const setterFunction = setters[index];
                    if (step == 4) {
                        Object.entries(value).forEach(([key, data]) => {
                            const setterName     = key;
                            const setterFunction = setters[setterName];
                            if (setterFunction) {
                                setterFunction(prevState => {
                                    const newState = [...prevState];
                                    newState[index] = data;
                                    return newState;
                                });
                            }
                        });
                    } else {
                        if (setterFunction) {
                            setterFunction(value[0]);
                        }
                    }
                });
            } else if (data.status == 'error') {
                throw new Error(data.message);
            } else {
                throw new Error(data.message);
            }

        } catch (error) {
            if (error instanceof TypeError) {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            } else {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: error.message,
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        } finally {
            setIsLoading(false)
        }

    };

    const fetchProductList = async () => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/product-list';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                setProductList(data.product_ist)
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        } finally {
            setIsLoading(false)
        }
    };

    const fetchOcupationList = async () => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/occupation-list';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                setOccupationList(data.occupation_ist)
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        } finally {
            setIsLoading(false)
        }
    };

    const fetchGenderList = async () => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/gender-list';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                setGenderList(data.gender_ist)
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        } finally {
            setIsLoading(false)
        }
    };

    const fetchResidentList = async () => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/resident-list';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                setResidentList(data.resident_ist)
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        } finally {
            setIsLoading(false)
        }
    };

    const fetchNationalityList = async () => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/nationality-list';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                setNationalityList(data.nationality_ist)
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        } finally {
            setIsLoading(false)
        }
    };

    const fetchRelationShipList = async () => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/relationship-list';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                setRelationshipList(data.relationshipList)
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        } finally {
            setIsLoading(false)
        }
    };

    const fetchAccountList = async () => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/deposit-account-list';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                setAccountList(data.account_list)
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        }
    };

    const fetchBankList = async () => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/bank-list';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json'
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                setBankList(data.bank_list)
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        }
    };

    const fetchBranchList = async (bank_id,type) => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/branch-list?bank_id=' + bank_id;
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json'
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                if(type=='investor'){
                    setBranchList(data.branch_list)
                }else{
                    setJointBranchList(data.branch_list)
                }
                
            } else if (res.status == 401) {
                Swal.fire({
                    position: "top-end",
                    icon: "warning",
                    title: data.message,
                    showConfirmButton: false,
                    timer: 1000,
                }).then((result) => {
                    if (result.dismiss === Swal.DismissReason.timer) {
                        signOut();
                    }
                });
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        }
    };

    const fetchPaymentType = async () => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/payment-type-list';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                setPaymentTypeList(data.payment_list)
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        }
    };

    const fetchOperationMode = async () => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/operation-mode';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                setOperationModeList(data.operation_mode)
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        }
    };


    const resendOTP = async (e) => {
        e.preventDefault()

        setIsLoading(true)
        try {
            const formData = new FormData()
            formData.append('email', applicantEmail)
            formData.append('contact_number', applicantPhone)
            const url = process.env.NEXT_PUBLIC_API_URL + '/registation/' + 1;

            const res = await fetch(url, {
                method: 'POST',
                headers: {
                    'Accept': 'application/json'
                },
                body: formData
            })

            const data = await res.json();

            if (data.status == 'success') {
                Swal.fire({
                    position: "top-end",
                    icon: "success",
                    title: data.message,
                    showConfirmButton: false,
                    timer: 2000,
                });
            }

        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        } finally {
            setIsLoading(false)
        }

    }

    const StepBackHandler = (e) => {
        e.preventDefault()
        setStep((step > 1 ? step - 1 : step));
    }

    const skipDeposit = (e) => {
        e.preventDefault()
        setStep((step < 6 ? step + 1 : step));
    }

    const addMoreNominee = (e) => {
        e.preventDefault()
        setNomineeInputs(prevNomineeInputs => [...prevNomineeInputs, '']);
    }

    const removeMoreNominee = (e) => {
        e.preventDefault()
        setNomineeInputs(prevInputs => {
            if (prevInputs.length > 1) {
                return prevInputs.slice(0, -1);
            } else {
                return prevInputs;
            }
        });
    };

    const ValidationHandle = (e) => {
        e.preventDefault()
        let element = e.target
        element.classList.add(styles.invalid)
        let children = element.parentElement.children;
        children[children.length - 1].textContent = element.validationMessage
    }

    if (isLoading) {
        return (
            <Loading loading={isLoading} />
        )
    }

    return (
        <>
            <form className={`${styles.d_flex} ${styles.flex_direction_col} ${styles.flex_100}`} onSubmit={handleSubmit}>
                {
                    step == 1 &&
                    <div className={`${styles.d_flex} ${styles.flex_100} ${styles.flex_direction_col_md} ${styles.flex_justify_center} ${styles.flex_wrap} ${styles.flex_no_wrap}`}>

                        <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                            <input
                                className={styles.input}
                                type="email"
                                defaultValue={applicantEmail}
                                required
                                onChange={(e) => handleInputChange(e, setApplicantEmail)}
                                name="applicantEmail"
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={styles.label}
                            > Email Address</label>
                            {
                                applicantEmailError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {applicantEmailError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                        <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                            <input
                                className={styles.input}
                                type="text"
                                defaultValue={applicantPhone}
                                required
                                onChange={(e) => handleInputChange(e, setApplicantPhone)}
                                name="applicantPhone"
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={styles.label}
                            > Phone Number</label>
                            {
                                applicantPhoneError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {applicantPhoneError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                        <div className={`${styles.formcontrol} ${styles.flex_100} ${styles.text_center}`}>
                            <input
                                className={styles.input}
                                type="checkbox"
                                defaultValue={termsCondition}
                                required
                                onChange={(e) => handleInputChange(e, setTermsCondition)}
                                name="termsCondition"
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={`${styles.w_100}`}
                            >
                                I accept the <Link href="/termscondition">Terms & Conditions</Link>
                            </label>

                            {
                                termsConditionError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid} `}
                                        >
                                            {termsConditionError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>

                        {/* <div className={`${styles.formcontrol} ${styles.flex_100}`}>
                            <b>Please keep the soft copy / picture of the following documents ready:</b>
                            <ul className={`${styles.list_disc} ${styles.ms_15}`}>
                                <li>Applicant's and nominee's national ID card.</li>
                                <li>Color photo and signature of the  applicant(s) and nominess(s).</li>
                                <li>Bank cheque leaf of the applicant.</li>
                                <li>Applicant's E-TIN certificate (To enjoy tax benifit).</li>
                                <li>Passport copy for Non-resident Bangladeshi (NRB).</li>
                            </ul>
                            <img className={`${styles.w_100}`} src={`${process.env.NEXT_PUBLIC_REG_REQUIRED}`} />
                        </div> */}

                    </div>
                }

                {
                    step == 2 &&
                    <div className={`${styles.d_flex} ${styles.flex_100} ${styles.flex_direction_col_md} ${styles.flex_justify_center} ${styles.flex_wrap} ${styles.flex_no_wrap}`}>
                        <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                            <input
                                className={styles.input}
                                type="text"
                                defaultValue={verifyOtp}
                                required
                                onChange={(e) => handleInputChange(e, setVerifyOtp)}
                                name="verifyOtp"
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={styles.label}
                            > Verify OTP</label>
                            {
                                verifyOtpError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {verifyOtpError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                    </div>
                }

                {
                    step == 3 &&
                    <>
                        <div className={`${styles.d_flex} ${styles.flex_100} ${styles.flex_direction_col_md} ${styles.flex_justify_center} ${styles.flex_wrap} ${styles.flex_no_wrap}`}>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <select
                                    className={styles.input}
                                    value={product}
                                    required
                                    onChange={(e) => handleInputChange(e, setProduct)}
                                    name="product"
                                    onInvalid={e => ValidationHandle(e)}
                                >
                                    <option disabled></option>
                                    {
                                        productList && Object.keys(productList).length > 0 ?
                                            (
                                                productList.map((data, key) => {
                                                    return <option
                                                        value={data.template_id}
                                                        key={key}
                                                    >
                                                        {data.product_name}
                                                    </option>
                                                })
                                            ) :
                                            (
                                                <option disabled>Data not available</option>
                                            )

                                    }
                                </select>
                                <label
                                    className={styles.label}
                                > Product </label>
                                {
                                    productError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {productError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <select
                                    className={styles.input}
                                    value={operationMode}
                                    required
                                    onChange={(e) => handleInputChange(e, setOperationMode)}
                                    name={`operationMode`}
                                    onInvalid={e => ValidationHandle(e)}
                                >
                                    <option disabled></option>
                                    {
                                        operationModeList ?
                                            (
                                                Object.entries(operationModeList).map(([key, value]) => {
                                                    return <option
                                                        value={key}
                                                        key={key}
                                                    >
                                                        {value}
                                                    </option>
                                                })
                                            ) :
                                            (
                                                <option disabled>Data not available</option>
                                            )

                                    }
                                </select>
                                <label
                                    className={`${styles.label}`}
                                >Operation Mode</label>
                                {
                                    operationModeError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {operationModeError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>

                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={styles.input}
                                    type="text"
                                    defaultValue={applicantName}
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantName)}
                                    name="applicantName"
                                    onInvalid={e => ValidationHandle(e)}
                                />
                                <label
                                    className={styles.label}
                                > Full Name</label>
                                {
                                    applicantNameError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantNameError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={styles.input}
                                    type="date"
                                    defaultValue={applicantDOB}
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantDOB)}
                                    name="applicantDOB"
                                    onInvalid={e => ValidationHandle(e)}
                                />
                                <label
                                    className={styles.label}
                                > Applicant DOB</label>
                                {
                                    applicantDOBError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantDOBError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={styles.input}
                                    type="email"
                                    value={applicantEmail}
                                    onChange={(e) => e.preventDefault()}
                                    name="applicantEmail"
                                    onInvalid={e => ValidationHandle(e)}
                                />
                                <label
                                    className={styles.label}
                                > Email Address</label>
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={styles.input}
                                    type="text"
                                    value={applicantPhone}
                                    onChange={(e) => e.preventDefault()}
                                    name="applicantPhone"
                                    onInvalid={e => ValidationHandle(e)}
                                />
                                <label
                                    className={styles.label}
                                > Phone Number</label>
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={styles.input}
                                    type="text"
                                    defaultValue={applicantId}
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantId)}
                                    name="applicantId"
                                    onInvalid={e => ValidationHandle(e)}
                                />
                                <label
                                    className={styles.label}
                                > NID / Passport</label>
                                {
                                    applicantIdError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantIdError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={styles.input}
                                    type="text"
                                    defaultValue={applicantFatherName}
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantFatherName)}
                                    name="applicantFatherName"
                                    onInvalid={e => ValidationHandle(e)}
                                />
                                <label
                                    className={styles.label}
                                > Father's Name</label>
                                {
                                    applicantFatherNameError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantFatherNameError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={styles.input}
                                    type="text"
                                    defaultValue={applicantMotherName}
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantMotherName)}
                                    name="applicantMotherName"
                                    onInvalid={e => ValidationHandle(e)}
                                />
                                <label
                                    className={styles.label}
                                > Mother's Name</label>
                                {
                                    applicantMotherNameError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantMotherNameError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={`${styles.input} ${styles.optional} ${invalidInputs.applicantSpouseName ? styles.invalid : ''}`}
                                    type="text"
                                    defaultValue={applicantSpouseName}
                                    onChange={(e) => handleInputChange(e, setApplicantSpouseName)}
                                    name="applicantSpouseName"
                                />
                                <label
                                    className={styles.label}
                                > Spouse Name</label>
                                {
                                    applicantSpouseNameError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantSpouseNameError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={`${styles.input} ${styles.optional} ${invalidInputs.applicantEtin ? styles.invalid : ''}`}
                                    type="text"
                                    defaultValue={applicantEtin}
                                    onChange={(e) => handleInputChange(e, setApplicantEtin)}
                                    name="applicantEtin"
                                />
                                <label
                                    className={styles.label}
                                > E-TIN</label>
                                {
                                    applicantEtinError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantEtinError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <select
                                    className={styles.input}
                                    value={applicantBank}
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantBank)}
                                    name={`applicantBank`}
                                    onInvalid={e => ValidationHandle(e)}
                                >
                                    <option disabled></option>
                                    {
                                        bankList && Object.keys(bankList).length > 0 ?
                                            (
                                                bankList.map((data, key) => {
                                                    return <option
                                                        value={data.org_id}
                                                        key={data.org_id}
                                                    >
                                                        {data.org_name}
                                                    </option>
                                                })
                                            ) :
                                            (
                                                <option disabled>Data not available</option>
                                            )

                                    }
                                </select>
                                <label
                                    className={`${styles.label}`}
                                >Bank Name</label>
                                {
                                    applicantBankError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantBankError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>


                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <select
                                    className={styles.input}
                                    value={applicantBranch}
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantBranch)}
                                    name={`applicantBranch`}
                                    onInvalid={e => ValidationHandle(e)}
                                >
                                    <option disabled></option>
                                    {
                                        branchList && Object.keys(branchList).length > 0 ?
                                            (
                                                branchList.map((data, key) => {
                                                    return <option
                                                        value={data.branch_id}
                                                        key={data.branch_id}
                                                    >
                                                        {data.branch_name}
                                                    </option>
                                                })
                                            ) :
                                            (
                                                <option disabled>Data not available</option>
                                            )

                                    }
                                </select>
                                <label
                                    className={`${styles.label}`}
                                >Branch Name</label>
                                {
                                    applicantBranchError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantBranchError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>

                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={styles.input}
                                    type="text"
                                    defaultValue={applicantAccountNo}
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantAccountNo)}
                                    name={`applicantAccountNo`}
                                    onInvalid={e => ValidationHandle(e)}
                                />
                                <label
                                    className={`${styles.label}`}
                                > Account No. </label>
                                {
                                    applicantAccountNoError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantAccountNoError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <select
                                    className={styles.input}
                                    value={applicantGender}
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantGender)}
                                    name="applicantGender "
                                    onInvalid={e => ValidationHandle(e)}
                                >
                                    <option disabled></option>
                                    {
                                        genderList && Object.keys(genderList).length > 0 ?
                                            (
                                                genderList.map((data, key) => {
                                                    return <option
                                                        value={data.gender_id}
                                                        key={key}
                                                    >
                                                        {data.gender}
                                                    </option>
                                                })
                                            ) :
                                            (
                                                <option disabled>Data not available</option>
                                            )

                                    }
                                </select>
                                <label
                                    className={styles.label}
                                > Gender  </label>
                                {
                                    applicantGenderError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantGenderError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <select
                                    className={styles.input}
                                    value={applicantResident}
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantResident)}
                                    name="applicantResident"
                                    onInvalid={e => ValidationHandle(e)}
                                >
                                    <option disabled></option>
                                    {
                                        residentList && Object.keys(residentList).length > 0 ?
                                            (
                                                residentList.map((data, key) => {
                                                    return <option
                                                        value={data.resident_id}
                                                        key={key}
                                                    >
                                                        {data.resident}
                                                    </option>
                                                })
                                            ) :
                                            (
                                                <option disabled>Data not available</option>
                                            )

                                    }
                                </select>
                                <label
                                    className={styles.label}
                                > Resident</label>
                                {
                                    applicantResidentError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantResidentError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <select
                                    className={styles.input}
                                    value={applicantOccupation}
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantOccupation)}
                                    name="applicantOccupation "
                                    onInvalid={e => ValidationHandle(e)}
                                >
                                    <option disabled></option>
                                    {
                                        occupationList && Object.keys(occupationList).length > 0 ?
                                            (
                                                occupationList.map((data, key) => {
                                                    return <option
                                                        value={data.occupation_id}
                                                        key={key}
                                                    >
                                                        {data.occupation}
                                                    </option>
                                                })
                                            ) :
                                            (
                                                <option disabled>Data not available</option>
                                            )

                                    }
                                </select>

                                <label
                                    className={styles.label}
                                > Occupation </label>
                                {
                                    applicantOccupationError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantOccupationError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <select
                                    className={styles.input}
                                    value={applicantNationality}
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantNationality)}
                                    name="applicantNationality"
                                    onInvalid={e => ValidationHandle(e)}
                                >
                                    <option disabled></option>
                                    {
                                        nationalityList && Object.keys(nationalityList).length > 0 ?
                                            (
                                                nationalityList.map((data, key) => {
                                                    return <option
                                                        value={data.nationality_id}
                                                        key={key}
                                                    >
                                                        {data.nationality}
                                                    </option>
                                                })
                                            ) :
                                            (
                                                <option disabled>Data not available</option>
                                            )

                                    }
                                </select>
                                <label
                                    className={styles.label}
                                > Nationality </label>
                                {
                                    applicantNationalityError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantNationalityError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <textarea
                                    className={styles.input}
                                    type="textarea"
                                    value={applicantPresentAddress}
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantPresentAddress)}
                                    name="applicantPresentAddress "
                                    onInvalid={e => ValidationHandle(e)}
                                >
                                </textarea>
                                <label
                                    className={styles.label}
                                > Present Address </label>
                                {
                                    applicantPresentAddressError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantPresentAddressError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <textarea
                                    className={styles.input}
                                    type="textarea"
                                    value={applicantPresentAddress}
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantPermanentAddress)}
                                    name="applicantPermanentAddress "
                                    onInvalid={e => ValidationHandle(e)}
                                >
                                   
                                </textarea>
                                <label
                                    className={styles.label}
                                > Permanent Address</label>
                                {
                                    applicantPermanentAddressError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantPermanentAddressError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>

                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={`${styles.input}  ${styles.mt_14}`}
                                    type="checkbox"
                                    defaultValue={boLink}
                                    onChange={(e) => handleInputChange(e, setBoLink)}
                                    checked={boLink}
                                    name="boLink"
                                />
                                <label
                                    className={styles.label}
                                >
                                    Link Bo
                                </label>

                                {
                                    boLinkError == 'checked' ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid} `}
                                            >
                                                {boLinkError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>

                            {
                                boLink &&
                                <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                    <input
                                        className={`${styles.input}`}
                                        type="text"
                                        defaultValue={applicantBo}
                                        required
                                        onChange={(e) => handleInputChange(e, setApplicantBo)}
                                        name="applicantBo"
                                        onInvalid={e => ValidationHandle(e)}
                                    />
                                    <label
                                        className={styles.label}
                                    > BO Account No</label>
                                    {
                                        applicantBoError ?
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.back_invalid}`}
                                                >
                                                    {applicantBoError}
                                                </span>
                                            ) :
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.invalid_message}`}
                                                >
                                                </span>
                                            )
                                    }
                                </div>
                            }



                            <div className={`${styles.formcontrol} ${styles.flex_100}`}>
                                <p className={`${styles.text_color_red} ${styles.text_size_13}`}>
                                    Note:Benefit from a 5% cash dividend exemption by adding your Taxpayer
                                    Identification Number (TIN) to your BO Account.
                                </p>
                            </div>
                        </div>
                        {
                            operationMode == 2 &&
                            <>
                                <div className={`${styles.formcontrol} ${styles.flex_100}`}>
                                    <h1 className={`${styles.gradient_text_blue}`}>
                                        Joint Applicant Information
                                    </h1>
                                </div>
                                <div className={`${styles.d_flex} ${styles.flex_100} ${styles.flex_direction_col_md} ${styles.flex_justify_center} ${styles.flex_wrap} ${styles.flex_no_wrap} ${styles.mt_35}`}>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <input
                                            className={styles.input}
                                            type="text"
                                            defaultValue={jointApplicantName}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantName)}
                                            name="jointApplicantName"
                                            onInvalid={e => ValidationHandle(e)}
                                        />
                                        <label
                                            className={styles.label}
                                        > Full Name</label>
                                        {
                                            jointApplicantNameError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantNameError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <input
                                            className={styles.input}
                                            type="date"
                                            defaultValue={jointApplicantDOB}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantDOB)}
                                            name="jointApplicantDOB"
                                            onInvalid={e => ValidationHandle(e)}
                                        />
                                        <label
                                            className={styles.label}
                                        > Applicant DOB</label>
                                        {
                                            jointApplicantDOBError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantDOBError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <input
                                            className={styles.input}
                                            type="email"
                                            defaultValue={jointApplicantEmail}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantEmail)}
                                            name="jointApplicantEmail"
                                            onInvalid={e => ValidationHandle(e)}
                                        />
                                        <label
                                            className={styles.label}
                                        > Email Address</label>
                                        {
                                            jointApplicantEmailError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantEmailError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <input
                                            className={styles.input}
                                            type="text"
                                            defaultValue={jointApplicantPhone}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantPhone)}
                                            name="jointApplicantPhone"
                                            onInvalid={e => ValidationHandle(e)}
                                        />
                                        <label
                                            className={styles.label}
                                        > Phone Number</label>
                                        {
                                            jointApplicantPhoneError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantPhoneError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <input
                                            className={styles.input}
                                            type="text"
                                            defaultValue={jointApplicantId}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantId)}
                                            name="jointApplicantId"
                                            onInvalid={e => ValidationHandle(e)}
                                        />
                                        <label
                                            className={styles.label}
                                        > NID / Passport</label>
                                        {
                                            jointApplicantIdError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantIdError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <input
                                            className={styles.input}
                                            type="text"
                                            defaultValue={jointApplicantFatherName}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantFatherName)}
                                            name="applicantFatherName"
                                            onInvalid={e => ValidationHandle(e)}
                                        />
                                        <label
                                            className={styles.label}
                                        > Father's Name</label>
                                        {
                                            jointApplicantFatherNameError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantFatherNameError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <input
                                            className={styles.input}
                                            type="text"
                                            defaultValue={jointApplicantMotherName}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantMotherName)}
                                            name="jointApplicantMotherName"
                                            onInvalid={e => ValidationHandle(e)}
                                        />
                                        <label
                                            className={styles.label}
                                        > Mother's Name</label>
                                        {
                                            jointApplicantMotherNameError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantMotherNameError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <input
                                            className={`${styles.input} ${styles.optional}`}
                                            type="text"
                                            defaultValue={jointApplicantSpouseName}
                                            onChange={(e) => handleInputChange(e, setJointApplicantSpouseName)}
                                            name="applicantSpouseName"
                                        />
                                        <label
                                            className={styles.label}
                                        > Spouse Name</label>
                                        {
                                            jointApplicantSpouseNameError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantSpouseNameError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <input
                                            className={`${styles.input} ${styles.optional}`}
                                            type="text"
                                            defaultValue={jointApplicantEtin}
                                            onChange={(e) => handleInputChange(e, setJointApplicantEtin)}
                                            name="applicantEtin"
                                            onInvalid={e => ValidationHandle(e)}
                                        />
                                        <label
                                            className={styles.label}
                                        > E-TIN</label>
                                        {
                                            jointApplicantEtinError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantEtinError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>

                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <select
                                            className={styles.input}
                                            value={jointBank}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointBank)}
                                            name={`jointBank`}
                                            onInvalid={e => ValidationHandle(e)}
                                        >
                                            <option disabled></option>
                                            {
                                                bankList && Object.keys(bankList).length > 0 ?
                                                    (
                                                        bankList.map((data, key) => {
                                                            return <option
                                                                value={data.org_id}
                                                                key={data.org_id}
                                                            >
                                                                {data.org_name}
                                                            </option>
                                                        })
                                                    ) :
                                                    (
                                                        <option disabled>Data not available</option>
                                                    )

                                            }
                                        </select>
                                        <label
                                            className={`${styles.label}`}
                                        >Bank Name</label>
                                        {
                                            jointBankError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointBankError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>


                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <select
                                            className={styles.input}
                                            value={jointBranch}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointBranch)}
                                            name={`jointBranch`}
                                            onInvalid={e => ValidationHandle(e)}
                                        >
                                            <option disabled></option>
                                            {
                                                jointBranchList && Object.keys(jointBranchList).length > 0 ?
                                                    (
                                                        jointBranchList.map((data, key) => {
                                                            return <option
                                                                value={data.branch_id}
                                                                key={data.branch_id}
                                                            >
                                                                {data.branch_name}
                                                            </option>
                                                        })
                                                    ) :
                                                    (
                                                        <option disabled>Data not available</option>
                                                    )

                                            }
                                        </select>
                                        <label
                                            className={`${styles.label}`}
                                        >Branch Name</label>
                                        {
                                            jointBranchError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointBranchError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>

                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <input
                                            className={styles.input}
                                            type="text"
                                            defaultValue={jointAccountNo}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointAccountNo)}
                                            name={`jointAccountNo`}
                                            onInvalid={e => ValidationHandle(e)}
                                        />
                                        <label
                                            className={`${styles.label}`}
                                        > Account No. </label>
                                        {
                                            jointAccountNoError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointAccountNoError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>

                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <select
                                            className={styles.input}
                                            value={jointRelation}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointRelation)}
                                            name={`jointRelation`}
                                            onInvalid={e => ValidationHandle(e)}
                                        >
                                            <option disabled></option>
                                            {
                                                relationshipList && Object.keys(relationshipList).length > 0 ?
                                                    (
                                                        relationshipList.map((data, key) => {
                                                            return <option
                                                                value={data.relation_id}
                                                                key={key}
                                                            >
                                                                {data.relation}
                                                            </option>
                                                        })
                                                    ) :
                                                    (
                                                        <option disabled>Data not available</option>
                                                    )

                                            }
                                        </select>
                                        <label
                                            className={styles.label}
                                        >Relationship With Applicant </label>
                                        {
                                            jointRelationError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointRelationError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>

                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <select
                                            className={styles.input}
                                            value={jointApplicantResident}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantResident)}
                                            name="jointApplicantResident"
                                            onInvalid={e => ValidationHandle(e)}
                                        >
                                            <option disabled></option>
                                            {
                                                residentList && Object.keys(residentList).length > 0 ?
                                                    (
                                                        residentList.map((data, key) => {
                                                            return <option
                                                                value={data.resident_id}
                                                                key={key}
                                                            >
                                                                {data.resident}
                                                            </option>
                                                        })
                                                    ) :
                                                    (
                                                        <option disabled>Data not available</option>
                                                    )

                                            }
                                        </select>
                                        <label
                                            className={styles.label}
                                        > Resident</label>
                                        {
                                            jointApplicantResidentError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantResidentError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <select
                                            className={styles.input}
                                            value={jointApplicantOccupation}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantOccupation)}
                                            name="jointApplicantOccupation "
                                            onInvalid={e => ValidationHandle(e)}
                                        >
                                            <option disabled></option>
                                            {
                                                occupationList && Object.keys(occupationList).length > 0 ?
                                                    (
                                                        occupationList.map((data, key) => {
                                                            return <option
                                                                value={data.occupation_id}
                                                                key={key}
                                                            >
                                                                {data.occupation}
                                                            </option>
                                                        })
                                                    ) :
                                                    (
                                                        <option disabled>Data not available</option>
                                                    )

                                            }
                                        </select>

                                        <label
                                            className={styles.label}
                                        > Occupation </label>
                                        {
                                            jointApplicantOccupationError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantOccupationError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <select
                                            className={styles.input}
                                            value={jointApplicantNationality}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantNationality)}
                                            name="jointApplicantNationality "
                                            onInvalid={e => ValidationHandle(e)}
                                        >
                                            <option disabled></option>
                                            {
                                                nationalityList && Object.keys(nationalityList).length > 0 ?
                                                    (
                                                        nationalityList.map((data, key) => {
                                                            return <option
                                                                value={data.nationality_id}
                                                                key={key}
                                                            >
                                                                {data.nationality}
                                                            </option>
                                                        })
                                                    ) :
                                                    (
                                                        <option disabled>Data not available</option>
                                                    )

                                            }
                                        </select>
                                        <label
                                            className={styles.label}
                                        > Nationality </label>
                                        {
                                            jointApplicantNationalityError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantNationalityError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <textarea
                                            className={styles.input}
                                            type="textarea"
                                            defaultValue={jointApplicantPresentAddress}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantPresentAddress)}
                                            name="jointApplicantPresentAddress "
                                            onInvalid={e => ValidationHandle(e)}
                                        >

                                        </textarea>
                                        <label
                                            className={styles.label}
                                        > Present Address </label>
                                        {
                                            jointApplicantPresentAddressError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantPresentAddressError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <textarea
                                            className={styles.input}
                                            type="textarea"
                                            defaultValue={jointApplicantPermanentAddress}
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantPermanentAddress)}
                                            name="applicantPermanentAddress "
                                            onInvalid={e => ValidationHandle(e)}
                                        >

                                        </textarea>
                                        <label
                                            className={styles.label}
                                        > Permanent Address</label>
                                        {
                                            jointApplicantPermanentAddressError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantPermanentAddressError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                </div>
                            </>
                        }
                    </>

                }

                {
                    step == 4 &&
                    nomineeInputs.map((input, index) => (
                        <div key={index}>
                            <div className={`${styles.formcontrol} ${styles.flex_100}`}>
                                {index == 1 &&
                                    <h1 className={`${styles.gradient_text_blue}`}>
                                        Second Nominee Information
                                    </h1>
                                }
                            </div>
                            <div key={index} className={`${styles.d_flex} ${styles.flex_100} ${styles.flex_direction_col_md} ${styles.flex_justify_center} ${styles.flex_wrap} ${styles.flex_no_wrap}`}>
                                <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                    <input
                                        className={styles.input}
                                        type="number"
                                        max={index == 0 ? 100 : (100 - sharePercentage[0])}
                                        min={index == 1 ? (100 - sharePercentage[0]):1}
                                        defaultValue={sharePercentage[index]}
                                        required
                                        onChange={(e) => handleInputChange(e, setSharePercentage, index)}
                                        name={`sharePercentage-${index}`}
                                        onInvalid={e => ValidationHandle(e)}
                                    />
                                    <label
                                        className={styles.label}
                                    >Share Percentage (%)</label>
                                    {
                                        sharePercentageError[index] ?
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.back_invalid}`}
                                                >
                                                    {sharePercentageError[index]}
                                                </span>
                                            ) :
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.invalid_message}`}
                                                >
                                                </span>
                                            )
                                    }
                                </div>
                                <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                    <input
                                        className={styles.input}
                                        type="text"
                                        defaultValue={nomineeName[index]}
                                        required
                                        onChange={(e) => handleInputChange(e, setNomineeName, index)}
                                        name={`nomineeName-${index}`}
                                        onInvalid={e => ValidationHandle(e)}
                                    />
                                    <label
                                        className={styles.label}
                                    >Nominee's Full Name</label>
                                    {
                                        nomineeNameError[index] ?
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.back_invalid}`}
                                                >
                                                    {nomineeNameError[index]}
                                                </span>
                                            ) :
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.invalid_message}`}
                                                >
                                                </span>
                                            )
                                    }
                                </div>
                                <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                    <input
                                        className={styles.input}
                                        type="email"
                                        defaultValue={nomineeEmail[index]}
                                        required
                                        onChange={(e) => handleInputChange(e, setNomineeEmail, index)}
                                        name={`nomineeEmail-${index}`}
                                        onInvalid={e => ValidationHandle(e)}
                                    />
                                    <label
                                        className={styles.label}
                                    > Email Address</label>
                                    {
                                        nomineeEmailError[index] ?
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.back_invalid}`}
                                                >
                                                    {nomineeEmailError[index]}
                                                </span>
                                            ) :
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.invalid_message}`}
                                                >
                                                </span>
                                            )
                                    }
                                </div>
                                <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                    <input
                                        className={styles.input}
                                        type="text"
                                        defaultValue={nomineePhone[index]}
                                        required
                                        onChange={(e) => handleInputChange(e, setNomineePhone, index)}
                                        name={`nomineePhone-${index}`}
                                        onInvalid={e => ValidationHandle(e)}
                                    />
                                    <label
                                        className={styles.label}
                                    > Phone Number</label>
                                    {
                                        nomineePhoneError[index] ?
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.back_invalid}`}
                                                >
                                                    {nomineePhoneError[index]}
                                                </span>
                                            ) :
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.invalid_message}`}
                                                >
                                                </span>
                                            )
                                    }
                                </div>
                                <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                    <input
                                        className={styles.input}
                                        type="text"
                                        defaultValue={nomineeId[index]}
                                        required
                                        onChange={(e) => handleInputChange(e, setNomineeId, index)}
                                        name={`omineeId-${index}`}
                                        onInvalid={e => ValidationHandle(e)}
                                    />
                                    <label
                                        className={styles.label}
                                    >NID / Passport / Birth Certificate No </label>
                                    {
                                        nomineeIdError[index] ?
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.back_invalid}`}
                                                >
                                                    {nomineeIdError[index]}
                                                </span>
                                            ) :
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.invalid_message}`}
                                                >
                                                </span>
                                            )
                                    }
                                </div>
                                <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                    <input
                                        className={styles.input}
                                        type="date"
                                        defaultValue={nomineeDob[index]}
                                        required
                                        onChange={(e) => handleInputChange(e, setNomineeDob, index)}
                                        name={`nomineeDob-${index}`}
                                        onInvalid={e => ValidationHandle(e)}
                                    />
                                    <label
                                        className={styles.label}
                                    >Nominee's Date of Birth </label>
                                    {
                                        nomineeDobError[index] ?
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.back_invalid}`}
                                                >
                                                    {nomineeDobError[index]}
                                                </span>
                                            ) :
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.invalid_message}`}
                                                >
                                                </span>
                                            )
                                    }
                                </div>
                                {/* <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                    <input
                                        className={styles.input}
                                        type="text"
                                        defaultValue={nomineeFatherName[index]}
                                        required
                                        onChange={(e) => handleInputChange(e, setNomineeFatherName,index)}
                                        name={`nomineeFatherName-${index}`}
                                        onInvalid={e => ValidationHandle(e)}
                                    />
                                    <label
                                        className={styles.label}
                                    >Father Name </label>
                                    {
                                        nomineeFatherNameError[index]?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {nomineeFatherNameError[index]}
                                            </span>
                                        ):
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                    }
                                </div> */}
                                {/* <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                    <input
                                        className={styles.input}
                                        type="text"
                                        defaultValue={nomineeMotherName[index]}
                                        required
                                        onChange={(e) => handleInputChange(e, setNomineeMotherName,index)}
                                        name={`nomineeMotherName-${index}`}
                                        onInvalid={e => ValidationHandle(e)}
                                    />
                                    <label
                                        className={styles.label}
                                    >Mother Name </label>
                                    {
                                        nomineeMotherNameError[index]?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {nomineeMotherNameError[index]}
                                            </span>
                                        ):
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                    }
                                </div> */}
                                <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                    <input
                                        className={`${styles.input} ${styles.optional}`}
                                        type="text"
                                        defaultValue={nomineeSpouseName[index]}
                                        onChange={(e) => handleInputChange(e, setNomineeSpouseName, index)}
                                        name={`nomineeSpouseName-${index}`}
                                        onInvalid={e => ValidationHandle(e)}
                                    />
                                    <label
                                        className={styles.label}
                                    >Spouse Name </label>
                                    {
                                        nomineeSpouseNameError[index] ?
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.back_invalid}`}
                                                >
                                                    {nomineeSpouseNameError[index]}
                                                </span>
                                            ) :
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.invalid_message}`}
                                                >
                                                </span>
                                            )
                                    }
                                </div>
                                {/* <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                    <select
                                        className={styles.input}
                                        defaultValue=""
                                        required
                                        onChange={(e) => handleInputChange(e, setNomineeOccupation,index)}
                                        name={`nomineeOccupation-${index}`}
                                        onInvalid={e => ValidationHandle(e)}
                                    >
                                        <option disabled></option>
                                        {
                                            occupationList && Object.keys(occupationList).length > 0?
                                            (
                                                occupationList.map((data,key)=>{
                                                    return <option 
                                                                value={data.occupation_id} 
                                                                key={key}
                                                            >
                                                                {data.occupation}
                                                            </option>
                                                })
                                            ):
                                            (
                                                <option disabled>Data not available</option>
                                            )
                                            
                                        }
                                    </select>
                                    <label
                                        className={styles.label}
                                    >Nominee's Occupation </label>
                                    {
                                        nomineeOccupationError[index]?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {nomineeOccupationError[index]}
                                            </span>
                                        ):
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                    }
                                </div> */}
                                <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                    <textarea
                                        className={styles.input}
                                        type="textarea"
                                        defaultValue={nomineeMailingAddress[index]}
                                        required
                                        onChange={(e) => handleInputChange(e, setNomineeMailingAddress, index)}
                                        name={`nomineeMailingAddress-${index}`}
                                        onInvalid={e => ValidationHandle(e)}
                                    >

                                    </textarea>
                                    <label
                                        className={styles.label}
                                    >  Mailing Address</label>
                                    {
                                        nomineeMailingAddressError[index] ?
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.back_invalid}`}
                                                >
                                                    {nomineeMailingAddressError[index]}
                                                </span>
                                            ) :
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.invalid_message}`}
                                                >
                                                </span>
                                            )
                                    }
                                </div>
                                <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                    <select
                                        className={styles.input}
                                        defaultValue={nomineeRelation[index]}
                                        required
                                        onChange={(e) => handleInputChange(e, setNomineeRelation, index)}
                                        name={`nomineeRelation-${index}`}
                                        onInvalid={e => ValidationHandle(e)}
                                    >
                                        <option disabled></option>
                                        {
                                            relationshipList && Object.keys(relationshipList).length > 0 ?
                                                (
                                                    relationshipList.map((data, key) => {
                                                        return <option
                                                            value={data.relation_id}
                                                            key={key}
                                                        >
                                                            {data.relation}
                                                        </option>
                                                    })
                                                ) :
                                                (
                                                    <option disabled>Data not available</option>
                                                )

                                        }
                                    </select>
                                    <label
                                        className={styles.label}
                                    >Relationship With Applicant </label>
                                    {
                                        nomineeRelationError[index] ?
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.back_invalid}`}
                                                >
                                                    {nomineeRelationError[index]}
                                                </span>
                                            ) :
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.invalid_message}`}
                                                >
                                                </span>
                                            )
                                    }
                                </div>
                            </div>
                        </div>
                    ))
                }

                {
                    step == 5 &&
                    <div className={`${styles.d_flex} ${styles.flex_100} ${styles.flex_direction_col_md} ${styles.flex_justify_center} ${styles.flex_wrap} ${styles.flex_no_wrap}`}>
                        <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                            <select
                                className={styles.input}
                                value={account}
                                required
                                onChange={(e) => handleInputChange(e, setAccount)}
                                name={`account`}
                                onInvalid={e => ValidationHandle(e)}
                            >
                                <option disabled></option>
                                {
                                    accountList && Object.keys(accountList).length > 0 ?
                                        (
                                            accountList.map((data, key) => {
                                                return <option
                                                    value={data.account_details_id}
                                                    key={key}
                                                >
                                                    {data.account_name}
                                                </option>
                                            })
                                        ) :
                                        (
                                            <option disabled>Data not available</option>
                                        )

                                }
                            </select>
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            >Deposit Account Name</label>
                            {
                                accountError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {accountError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                        <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                            <select
                                className={styles.input}
                                value={paymentType}
                                required
                                onChange={(e) => handleInputChange(e, setPaymentType)}
                                name={`paymentType`}
                                onInvalid={e => ValidationHandle(e)}
                            >
                                <option disabled></option>
                                {
                                    paymentTypeList ?
                                        (
                                            Object.entries(paymentTypeList).map(([key, value]) => {
                                                return <option
                                                    value={key}
                                                    key={key}
                                                >
                                                    {value}
                                                </option>
                                            })
                                        ) :
                                        (
                                            <option disabled>Data not available</option>
                                        )

                                }
                            </select>
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            >Payment Type</label>
                            {
                                paymentTypeError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {paymentTypeError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                        {
                            (paymentType != 'bkash' && paymentType != 'cd') &&
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <select
                                    className={styles.input}
                                    value={bank}
                                    required
                                    onChange={(e) => handleInputChange(e, setBank)}
                                    name={`bank`}
                                    onInvalid={e => ValidationHandle(e)}
                                >
                                    <option disabled></option>
                                    {
                                        bankList && Object.keys(bankList).length > 0 ?
                                            (
                                                bankList.map((data, key) => {
                                                    return <option
                                                        value={data.org_id}
                                                        key={data.org_id}
                                                    >
                                                        {data.org_name}
                                                    </option>
                                                })
                                            ) :
                                            (
                                                <option disabled>Data not available</option>
                                            )

                                    }
                                </select>
                                <label
                                    className={`${styles.label} ${styles.text_size_13}`}
                                >Bank Name</label>
                                {
                                    bankError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {bankError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                        }
                        <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                            <input
                                className={styles.input}
                                type="date"
                                defaultValue={instrumentDate}
                                required
                                onChange={(e) => handleInputChange(e, setInstrumentDate)}
                                name={`instrumentDate`}
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            >Instrument Date</label>
                            {
                                instrumentDateError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {instrumentDateError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                        <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                            <input
                                className={styles.input}
                                type="text"
                                defaultValue={instrumentNo}
                                required
                                onChange={(e) => handleInputChange(e, setInstrumentNo)}
                                name={`instrumentNo`}
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            > Instrument No.</label>
                            {
                                instrumentNoError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {instrumentNoError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                        <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                            <input
                                className={styles.input}
                                type="file"
                                required
                                onChange={(e) => handleInputChange(e, setDepositSlip)}
                                name="depositSlip"
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            > Deposit Slip</label>
                            {
                                depositSlipError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {depositSlipError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                        <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                            <input
                                className={styles.input}
                                type="text"
                                defaultValue={depositAmount}
                                required
                                onChange={(e) => handleInputChange(e, setDepositAmount)}
                                name={`depositAmount`}
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            > Deposit Amount </label>
                            {
                                depositAmountError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {depositAmountError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                    </div>
                }

                {
                    step == 5 &&
                    <>
                        <div className={`${styles.d_flex} ${styles.flex_100} ${styles.flex_direction_col_md} ${styles.flex_justify_center} ${styles.flex_wrap} ${styles.flex_no_wrap}`}>
                            <p className={`${styles.text_color_red}`}>Dear Esteemed Investor,You may conveniently deposit funds into the following bank accounts. </p>
                        </div>
                        {/* <div className={`${styles.d_flex} ${styles.flex_100} ${styles.flex_direction_col_md} ${styles.flex_justify_center} ${styles.flex_wrap} ${styles.flex_no_wrap}`}>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <table className={`${styles.w_100} ${styles.mb_20}`}>
                                    <thead>
                                        <tr>
                                            <th className={`${styles.text_center}`}>Bank Name</th>
                                            <th className={`${styles.text_center}`}>Account Name</th>
                                            <th className={`${styles.text_center}`}>Merchant Account Name</th>
                                            <th className={`${styles.text_center}`}>A/C No</th>
                                            <th className={`${styles.text_center}`}>Merchant Account No</th>
                                            <th className={`${styles.text_center}`}>Branch</th>
                                            <th className={`${styles.text_center}`}>Branch</th>
                                            <th className={`${styles.text_center}`}>Account Type</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td className={`${styles.text_right}`}>SCB</td>
                                            <td className={`${styles.text_right}`}>BRAC EPL INVESTMENTS LIMITED</td>
                                            <td className={`${styles.text_right}`}> </td>
                                            <td className={`${styles.text_right}`}>01619820102</td>
                                            <td className={`${styles.text_right}`}> </td>
                                            <td className={`${styles.text_right}`}>Motijheel</td>
                                            <td className={`${styles.text_right}`}>215274247</td>
                                            <td className={`${styles.text_right}`}> </td>
                                        </tr>
                                        <tr>
                                            <td className={`${styles.text_right}`}>BRAC BANK PLC</td>
                                            <td className={`${styles.text_right}`}>BRAC EPL INVESTMENTS LIMITED</td>
                                            <td className={`${styles.text_right}`}> </td>
                                            <td className={`${styles.text_right}`}>1501201657209002</td>
                                            <td className={`${styles.text_right}`}> </td>
                                            <td className={`${styles.text_right}`}>Gulshan</td>
                                            <td className={`${styles.text_right}`}>060261726</td>
                                            <td className={`${styles.text_right}`}> </td>
                                        </tr>
                                        <tr>
                                            <td className={`${styles.text_right}`}>City Bank PLC</td>
                                            <td className={`${styles.text_right}`}>BRAC EPL INVESTMENTS LIMITED</td>
                                            <td className={`${styles.text_right}`}> </td>
                                            <td className={`${styles.text_right}`}>1383998323001</td>
                                            <td className={`${styles.text_right}`}> </td>
                                            <td className={`${styles.text_right}`}>DSE NUKUNJA/Nikunja Sub Branch</td>
                                            <td className={`${styles.text_right}`}>225261279</td>
                                            <td className={`${styles.text_right}`}>Current</td>
                                        </tr>
                                        <tr>
                                            <td className={`${styles.text_right}`}>bKash Wallet</td>
                                            <td className={`${styles.text_right}`}> </td>
                                            <td className={`${styles.text_right}`}>BRAC EPL INVESTMENTS LIMITED</td>
                                            <td className={`${styles.text_right}`}></td>
                                            <td className={`${styles.text_right}`}>01730703949</td>
                                            <td className={`${styles.text_right}`}> </td>
                                            <td className={`${styles.text_right}`}> </td>
                                            <td className={`${styles.text_right}`}> </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <img className={`${styles.w_100}`} src={`${process.env.NEXT_PUBLIC_BANK_INFO}`} />
                        </div> */}
                    </>
                }

                {
                    step == 6 &&
                    <>
                        <div className={`${styles.d_flex} ${styles.flex_100} ${styles.flex_direction_col_md} ${styles.flex_justify_center} ${styles.flex_wrap} ${styles.flex_no_wrap}`}>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={styles.input}
                                    type="file"
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantPhoto)}
                                    name="applicantPhoto"
                                    onInvalid={e => ValidationHandle(e)}
                                />
                                <label
                                    className={styles.label}
                                >Applicant Photo</label>
                                {
                                    applicantPhotoError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantPhotoError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={styles.input}
                                    type="file"
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantSignature)}
                                    name="applicantSignature"
                                    onInvalid={e => ValidationHandle(e)}
                                />
                                <label
                                    className={styles.label}
                                >Applicant Signature</label>
                                {
                                    applicantSignatureError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantSignatureError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={styles.input}
                                    type="file"
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantNidPhoto)}
                                    name="applicantNidPhoto"
                                    onInvalid={e => ValidationHandle(e)}
                                />
                                <label
                                    className={styles.label}
                                >Applicant Nid Front Side</label>
                                {
                                    applicantNidPhotoError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantNidPhotoError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={styles.input}
                                    type="file"
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantNidBackPhoto)}
                                    name="applicantNidBackPhoto"
                                    onInvalid={e => ValidationHandle(e)}
                                />
                                <label
                                    className={styles.label}
                                >Applicant Nid Back Side</label>
                                {
                                    applicantNidBackPhotoError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantNidBackPhotoError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                <input
                                    className={styles.input}
                                    type="file"
                                    required
                                    onChange={(e) => handleInputChange(e, setApplicantBankLeaf)}
                                    name="applicantBankLeaf"
                                    onInvalid={e => ValidationHandle(e)}
                                />
                                <label
                                    className={styles.label}
                                >Cheque Leaf</label>
                                {
                                    applicantBankLeafError ?
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.back_invalid}`}
                                            >
                                                {applicantBankLeafError}
                                            </span>
                                        ) :
                                        (
                                            <span
                                                className={`${styles.text_left} ${styles.invalid_message}`}
                                            >
                                            </span>
                                        )
                                }
                            </div>
                            {
                                boLink &&
                                <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                    <input
                                        className={styles.input}
                                        type="file"
                                        required
                                        onChange={(e) => handleInputChange(e, setLinkBoAttachment)}
                                        name="linkBoAttachment"
                                        onInvalid={e => ValidationHandle(e)}
                                    />
                                    <label
                                        className={styles.label}
                                    >Link BO Attachment</label>
                                    {
                                        linkBoAttachmentError ?
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.back_invalid}`}
                                                >
                                                    {linkBoAttachmentError}
                                                </span>
                                            ) :
                                            (
                                                <span
                                                    className={`${styles.text_left} ${styles.invalid_message}`}
                                                >
                                                </span>
                                            )
                                    }
                                </div>
                            }
                        </div>
                        {
                            jointInvestorId &&
                            <>
                                <div className={`${styles.formcontrol} ${styles.flex_100}`}>
                                    <h1 className={`${styles.gradient_text_blue}`}>
                                        Joint Applicant Information
                                    </h1>
                                </div>
                                <div className={`${styles.d_flex} ${styles.flex_100} ${styles.flex_direction_col_md} ${styles.flex_justify_center} ${styles.flex_wrap} ${styles.flex_no_wrap}`}>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <input
                                            className={styles.input}
                                            type="file"
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantPhoto)}
                                            name="jointApplicantPhoto"
                                            onInvalid={e => ValidationHandle(e)}
                                        />
                                        <label
                                            className={styles.label}
                                        >Joint Applicant Photo</label>
                                        {
                                            jointApplicantPhotoError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantPhotoError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <input
                                            className={styles.input}
                                            type="file"
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantSignature)}
                                            name="jointApplicantSignature"
                                            onInvalid={e => ValidationHandle(e)}
                                        />
                                        <label
                                            className={styles.label}
                                        >Joint Applicant Signature</label>
                                        {
                                            jointApplicantSignatureError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantSignatureError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <input
                                            className={styles.input}
                                            type="file"
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantNidPhoto)}
                                            name="jointApplicantNidPhoto"
                                            onInvalid={e => ValidationHandle(e)}
                                        />
                                        <label
                                            className={styles.label}
                                        >Joint Applicant Nid Front Side</label>
                                        {
                                            jointApplicantNidPhotoError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantNidPhotoError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                    <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                        <input
                                            className={styles.input}
                                            type="file"
                                            required
                                            onChange={(e) => handleInputChange(e, setJointApplicantNidBackPhoto)}
                                            name="jointApplicantNidBackPhoto"
                                            onInvalid={e => ValidationHandle(e)}
                                        />
                                        <label
                                            className={styles.label}
                                        >Joint Applicant Nid Back Side</label>
                                        {
                                            jointApplicantNidBackPhotoError ?
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                                    >
                                                        {jointApplicantNidBackPhotoError}
                                                    </span>
                                                ) :
                                                (
                                                    <span
                                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                                    >
                                                    </span>
                                                )
                                        }
                                    </div>
                                </div>
                            </>
                        }


                        {
                            nomineeInputs.map((input, index) => (
                                <div key={index}>
                                    <div className={`${styles.formcontrol} ${styles.flex_100}`}>
                                        {
                                            index == 1 ?
                                                <h1 className={`${styles.gradient_text_blue}`}>
                                                    Second Nominee Information
                                                </h1>
                                                :
                                                <h1 className={`${styles.gradient_text_blue}`}>
                                                    First Nominee Information
                                                </h1>
                                        }
                                    </div>
                                    <div key={index} className={`${styles.d_flex} ${styles.flex_100} ${styles.flex_direction_col_md} ${styles.flex_justify_center} ${styles.flex_wrap} ${styles.flex_no_wrap}`}>
                                        <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                            <input
                                                className={styles.input}
                                                type="file"
                                                required
                                                onChange={(e) => handleInputChange(e, setNomineePhoto, index)}
                                                name={`nomineePhoto-${index}`}
                                                onInvalid={e => ValidationHandle(e)}
                                            />
                                            <label
                                                className={styles.label}
                                            >Nominee Photo</label>
                                            {
                                                nomineePhotoError[index] ?
                                                    (
                                                        <span
                                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                                        >
                                                            {nomineePhotoError[index]}
                                                        </span>
                                                    ) :
                                                    (
                                                        <span
                                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                                        >
                                                        </span>
                                                    )
                                            }
                                        </div>
                                        <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                            <input
                                                className={styles.input}
                                                type="file"
                                                required
                                                onChange={(e) => handleInputChange(e, setNomineeSignature, index)}
                                                name={`nomineeSignature-${index}`}
                                                onInvalid={e => ValidationHandle(e)}
                                            />
                                            <label
                                                className={styles.label}
                                            >Nominee Signature</label>
                                            {
                                                nomineeSignatureError[index] ?
                                                    (
                                                        <span
                                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                                        >
                                                            {nomineeSignatureError[index]}
                                                        </span>
                                                    ) :
                                                    (
                                                        <span
                                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                                        >
                                                        </span>
                                                    )
                                            }
                                        </div>
                                        <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                            <input
                                                className={styles.input}
                                                type="file"
                                                required
                                                onChange={(e) => handleInputChange(e, setNomineeNidPhoto, index)}
                                                name={`nomineeNidPhoto-${index}`}
                                                onInvalid={e => ValidationHandle(e)}
                                            />
                                            <label
                                                className={styles.label}
                                            >Nominee Nid Front Side</label>
                                            {
                                                nomineeNidPhotoError[index] ?
                                                    (
                                                        <span
                                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                                        >
                                                            {nomineeNidPhotoError[index]}
                                                        </span>
                                                    ) :
                                                    (
                                                        <span
                                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                                        >
                                                        </span>
                                                    )
                                            }
                                        </div>
                                        <div className={`${styles.formcontrol} ${styles.flex_21}`}>
                                            <input
                                                className={styles.input}
                                                type="file"
                                                required
                                                onChange={(e) => handleInputChange(e, setNomineeNidBackPhoto, index)}
                                                name={`nomineeNidBackPhoto-${index}`}
                                                onInvalid={e => ValidationHandle(e)}
                                            />
                                            <label
                                                className={styles.label}
                                            >Nominee Nid Back Side</label>
                                            {
                                                nomineeNidBackPhotoError[index] ?
                                                    (
                                                        <span
                                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                                        >
                                                            {nomineeNidBackPhotoError[index]}
                                                        </span>
                                                    ) :
                                                    (
                                                        <span
                                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                                        >
                                                        </span>
                                                    )
                                            }
                                        </div>
                                    </div>
                                </div>
                            ))
                        }
                    </>
                }


                <div className={`${styles.formcontrol} ${styles.my_30} ${styles.d_flex} ${styles.flex_space_around} ${styles.flex_wrap} `}>
                    <button
                        onClick={StepBackHandler} className={styles.input_btn}
                    >Back</button>
                    {
                        step == 2 &&
                        <button onClick={resendOTP}
                            className={styles.input_btn}>
                            Resend OTP
                        </button>
                    }

                    {
                        step == 5 &&
                        <button
                            className={styles.input_btn}
                            onClick={skipDeposit}
                        >
                            Skip
                        </button>
                    }

                    {/* {
                        step==4&&
                        <button
                            className={styles.input_btn}
                            onClick={nomineeInputs.length==1?addMoreNominee:removeMoreNominee}
                        >
                            {nomineeInputs.length==1?'Add Another':'Remove Another'}
                        </button>
                    } */}

                    <button
                        className={styles.input_btn}
                    >Next</button>
                </div>
                
                {   step==1?
                    <div className={`${styles.d_flex} ${styles.formcontrol} ${styles.flex_100}`}>
                        <img className={`${styles.w_100}`} src={`${process.env.NEXT_PUBLIC_REG_REQUIRED}`} />
                    </div>
                    :
                    step==5?
                    <div className={`${styles.d_flex} ${styles.formcontrol} ${styles.flex_100}`}>
                        <img className={`${styles.w_100}`} src={`${process.env.NEXT_PUBLIC_BANK_INFO}`} />
                    </div>
                    :''
                }
            </form>
        </>
    );
};

export default ClientComponent;
