<?php

namespace App\Http\Controllers\Investor;

use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\InvestorDetail;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class AcknowledgementSlipController extends Controller
{
    public function acknowledgementSlip()
    {
        $user                = Auth::user();
        $investorInformation = [];
        $nomineeInformation  = [];
        $jointInformation    = [];
        $investorDetail      = InvestorDetail::where('portfolio_code', $user->investor_code)->with(['templateDetails', 'branchDetails', 'occupationDetails'],)->first();
        
        foreach ($investorDetail->nomineeInfo as $index => $nomineeInfo) {
            $nomineeInformation[$index]['nominee_name']     = $nomineeInfo->nominee_name;
            $nomineeInformation[$index]['mailing_address']  = $nomineeInfo->mailing_address;
            $nomineeInformation[$index]['relation']         = $nomineeInfo->relationDetails->relation;
            $nomineeInformation[$index]['share_percentage'] = $nomineeInfo->share_percentage;
        }

        $investorInformation = [
            'investor_account_no' => $investorDetail->portfolio_code,
            'account_type'        => $investorDetail->templateDetails->product_name,
            'sub_account_type'    => null,
            'bank_name'           => $investorDetail->branchDetails->bankDetails->org_name,
            'branch_name'         => $investorDetail->branchDetails->branch_name,
            'bank_account_no'     => $investorDetail->bank_account_no,
            'connecting_branch'   => null,
            'operation_type'      => ($investorDetail->operation_mode_id == 1) ? 'Single' : 'Joint',
            'opening_date'        => Carbon::createFromFormat('Y-m-d H:i:s', $investorDetail->business_date)->format('d-M-Y'),
            'special_instruction' => null,
            'introducer_name'     => $investorDetail->introducer_name,
            'introducer_account'  => $investorDetail->ipa_no,
            'investor_name'       => $investorDetail->investor_name,
            'father_name'         => $investorDetail->father_name,
            'spouse_name'         => $investorDetail->spouse_name,
            'occupation'          => $investorDetail->occupationDetails->occupation,
            'mother_name'         => $investorDetail->mother_name,
            'business_address'    => $investorDetail->mailing_address,
            'date_of_birth'       => Carbon::createFromFormat('Y-m-d H:i:s', $investorDetail->dob)->format('d-M-Y'),
            'nationality'         => $investorDetail->nationalityDetails->nationality,
            'office_phone_no'     => $investorDetail->telephone_office,
            'home_phone_no'       => $investorDetail->telephone_residential,
            'mobile_no'           => $investorDetail->mobile,
            'email'               => $investorDetail->email,
            'identity_no'         => $investorDetail->nid,
            'home_address'        => $investorDetail->permanent_address,
            'passport_no'         => $investorDetail->passport_no,
            'issue_place'         => null,
            'valid_till'          => is_null($investorDetail->pp_validity) ? null : Carbon::createFromFormat('Y-m-d H:i:s', $investorDetail->pp_validity)->format('d-M-Y'),
            'fax_no'              => $investorDetail->fax,
            'telex'               => null,
            'tin'                 => $investorDetail->tin,
        ];

        // dd($investorDetail->jointInvestorDetails);

        if (!is_null($investorDetail->jointInvestorDetails)) {
            $jointInformation =[
                'name'                              => $investorDetail?->jointInvestorDetails?->applicant_name,
                'father_name'                       => $investorDetail?->jointInvestorDetails?->father_name,
                'spouse_name'                       => $investorDetail?->jointInvestorDetails?->spouse_name,
                'residency'                         => $investorDetail?->jointInvestorDetails?->residency,
                'bo_account_no'                     => $investorDetail?->jointInvestorDetails?->bo_account_no,
                'monthly_income'                    => $investorDetail?->jointInvestorDetails?->monthly_income,
                'occupation'                        => $investorDetail?->jointInvestorDetails?->occupationDetails?->occupation,
                'mailing_address'                   => $investorDetail?->jointInvestorDetails?->mailing_address,
                'telephone_office'                  => $investorDetail?->jointInvestorDetails?->telephone_office,
                'mobile'                            => $investorDetail?->jointInvestorDetails?->mobile,
                'email'                             => $investorDetail?->jointInvestorDetails?->email,
                'date_of_birth'                     => !empty($investorDetail?->jointInvestorDetails?->dob) ? Carbon::createFromFormat('Y-m-d H:i:s', $investorDetail?->jointInvestorDetails?->dob)->format('d-M-Y') : null,
                'mother_name'                       => $investorDetail?->jointInvestorDetails?->mother_name,
                'nid'                               => $investorDetail?->jointInvestorDetails?->nid,
                'passport_no'                       => $investorDetail?->jointInvestorDetails?->passport_no,
                'bank_account_no'                   => $investorDetail?->jointInvestorDetails?->bank_account_no,
                'nationality'                       => $investorDetail?->jointInvestorDetails?->nationalityDetails?->nationality,
                'permanent_address'                 => $investorDetail?->jointInvestorDetails?->permanent_address,
                'telephone_resident'                => $investorDetail?->jointInvestorDetails?->telephone_residential,
                'fax'                               => $investorDetail?->jointInvestorDetails?->fax,
                'relation_with_principal_applicant' => $investorDetail?->jointInvestorDetails?->relationDetails?->relation,
                'city'                              => $investorDetail?->jointInvestorDetails?->cityDetails?->city,
            ];
        }
        

        return response()->json([
            'status'               => 'success',
            'investor_information' => $investorInformation,
            'nominee_information'  => $nomineeInformation,
            'joint_information'    => $jointInformation,
        ]);
    }
}
