<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\IpoList;
use App\Models\BusinessDate;
use Illuminate\Http\Request;
use App\Models\CapMarketOrder;
use App\Models\InvestorDetail;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\CapMarketOrderDetails;

class TestController extends Controller
{
	public function importUsers(Request $request) {
        set_time_limit(0);
        $users                = [];
        $limit                = 100;
        $dateTime             = now()->format("Y-m-d H:i:s");
        $password             = Hash::make('123123');
        $next_limit           = ($request->get("offset")) ? $request->get("offset") : 0;
        // $investorDetailsLists = InvestorDetail::limit($limit)->offset($next_limit)->get();
        $investorDetailsLists = InvestorDetail::where('account_close', 'n')->get();
        // $investorDetailsLists = collect([]);
        
        foreach ($investorDetailsLists as $key => $investorDetail) {
            try {
                $user                = new User();
                $user->name          = $investorDetail->investor_name;
                $user->first_name    = $investorDetail->investor_name;
                $user->email         = strtolower($investorDetail->email);
                $user->mobile_no     = $investorDetail->mobile;
                $user->investor_code = $investorDetail->portfolio_code;
                $user->password      = $password;
                $user->type          = 'Investor';
                $user->created_at    = $dateTime;
                $user->updated_at    = $dateTime;
                $user->save();
            } catch (\Throwable $th) {
                $data                  = [];
                $data["name"]          = $investorDetail->investor_name;
                $data["first_name"]    = $investorDetail->investor_name;
                $data["email"]         = strtolower($investorDetail->email);
                $data["mobile_no"]     = $investorDetail->mobile;
                $data["investor_code"] = $investorDetail->portfolio_code;
                $data["password"]      = $password;
                $data["type"]          = 'Investor';
                $data["created_at"]    = $dateTime;
                $data["updated_at"]    = $dateTime;

                $users[] = $data;
                // dump($th->getMessage(), $th->getCode(), $investorDetail);
            }
        }
        
        return response()->json($users);

    }
	
    public function reportHtml()
    {
        $data = [
            'title' => 'Portfolio Statement (Date Wise)',
        ];

        // $compareDate = Carbon::createFromFormat('Y-m-d', '2022-12-31');
        // $requestDate = Carbon::createFromFormat('Y-m-d', '2024-05-06');

        $user                    = User::find(8);
		$investorDetail          = $user->investorDetail;		
        $fromDate = Carbon::createFromFormat('Y-m-d', '2000-06-19');
		$toDate   = Carbon::createFromFormat('Y-m-d', '2025-06-19');
		$data['account_type']    = $investorDetail->templateDetails->product_short_name;
		$data['account_no']      = $investorDetail->portfolio_code;
		$data['bo_no']           = $investorDetail->bo_account_no;
		$data['account_date']    = Carbon::createFromFormat('Y-m-d', $investorDetail->business_date)->format(env('OUTPUT_DATE_FORMAT'));
		$data['account_name']    = $investorDetail->investor_name;
		$data['account_address'] = $investorDetail->mailing_address;
        $data['report_date']     = $fromDate->format('d-m-Y') . ' To ' . $toDate->format('d-m-Y');

        if ($investorDetail->account_enable_disable == 'e') {
			$data['account_status'] = 'Active';
		}

		if ($investorDetail->account_close == 'y') {
			$data['account_status'] = 'Close';
		}

		if ($investorDetail->account_suspend == 'y') {
			$data['account_status'] = 'Suspend';
		}



        $fundDepositSql = "
            SELECT 
                DISTINCT TD.TRANSACTION_DETAILS_ID, 
                TD.PORTFOLIO_CODE AS PORTFOLIO_CODE, 
                COALESCE(
                    INVD.INSTITUTION_NAME, INVD.INVESTOR_NAME
                ) AS INVESTOR_NAME, 
                TD.PAYMENT_TYPE, 
                TD.CHQ_NO, 
                TD.CHQ_DATE, 
                TD.AMOUNT, 
                TD.REMARKS, 
                TD.BUSINESS_DATE AS BUSINESS_DATE1, 
                TD.HONOR_DISHONOR_CANCEL_DATE AS BUSINESS_DATE 
            FROM 
                IS_TRANSACTION_DETAILS TD, 
                IS_INVESTOR_DETAILS INVD 
            WHERE 
                TD.PORTFOLIO_CODE = INVD.PORTFOLIO_CODE 
                AND LOWER(TD.TRANSACTION_TYPE) = 'deposit' 
                AND LOWER(TD.SEND_TO_BANK) = 'y' 
                AND LOWER(TD.HONOR_DISHONOR_CANCEL) = 'h' 
                AND INVD.IS_TEMPLATE = 'n' 
                AND TD.AMOUNT > 0 
                AND INVD.PORTFOLIO_CODE = :portfolio_code
                AND TD.HONOR_DISHONOR_CANCEL_DATE BETWEEN :from_date AND :to_date
                ORDER BY 
                TD.BUSINESS_DATE ASC

        ";

        $fundDepositResult = DB::select(
            $fundDepositSql,
            [
                'from_date' => $fromDate->format('Y-m-d'),
                'to_date' => $toDate->format('Y-m-d'),
                'portfolio_code' => $user->investor_code,
            ]
        );

        // dd($fundDepositResult);

        $data['fundDeposit'] = $fundDepositResult;

        return view('deposit.index', $data);

    }

    public function lastDate()
    {
        $businessDate = BusinessDate::latest('business_date')->first();
        
        $user = Auth::user();

        // dd($user->investor_code);
        
        $ipoList = IpoList::whereDoesntHave('orderedIpoList', function($query) use ($user) {
            $query->where('portfolio_code', $user->investor_code);
        })
        ->where('actual_la_date', '>=', $businessDate->business_date)
        ->get();

        dd($ipoList);
    }

    public function submitOrder(Request $request)
    {
        try {
            $this->validate($request, [
                'instrument_id' => 'required|array',
                'price_from'    => 'required|array',
                'price_to'      => 'required|array',
                'quantity'      => 'required|array',
                'days'          => 'required|array',
            ]);
    
            $processedData = [];
            $user          = Auth::user();
            $requestedData = $request->all();
            $businessDate  = BusinessDate::latest('business_date')->first();
            $purchasepower = 99999999999;
    
            return response()->json($requestedData);
            // dd($requestedData['instrument_id']);
            
            foreach ($requestedData['instrument_id'] as $key => $value) {
                $processedData[$key]['instrument_id'] = (int)$requestedData['instrument_id'][$key];
                $processedData[$key]['price_from']    = (float)$requestedData['price_from'][$key];
                $processedData[$key]['price_to']      = (float)$requestedData['price_to'][$key];
                $processedData[$key]['quantity']      = (int)$requestedData['quantity'][$key];
                $processedData[$key]['days']          = (int)$requestedData['days'][$key];
            }
    
            return response()->json($processedData);
            $totalAmount = 0;
    
            foreach ($processedData as $key => $listData) {
                $totalAmount += ($listData['price_to'] * $listData['quantity']);
            }
    
            if ($purchasepower >= $totalAmount) {
                foreach ($processedData as $key => $listData) {                
                    $capMarketOrderSql  = "SELECT nvl(max(web_id),0)+1 as web_id FROM is_cap_mkt_order";
                    $capMarketOrderData = collect(DB::select($capMarketOrderSql))->first();
                    
                    if (!is_null($capMarketOrderData)) {
                        $web_id                        = $capMarketOrderData->web_id;
                        $capMarketOrder                = new CapMarketOrder();
                        $capMarketOrder->web_id        = $web_id;
                        $capMarketOrder->payment_flag  = 'y';
                        $capMarketOrder->business_date = $businessDate->business_date;
                        $capMarketOrder->record_date   = now();
    
                        if ($capMarketOrder->save()) {
                            $capMarketOrderId                        = $capMarketOrder->cap_mkt_order_id;
                            $capMarketOrderDetails                   = new CapMarketOrderDetails();
                            $capMarketOrderDetails->cap_mkt_order_id = $capMarketOrderId;
                            $capMarketOrderDetails->trade_code       = $user->investor_code;
                            $capMarketOrderDetails->bd_id            = 681;
                            $capMarketOrderDetails->buy_sell_flag    = 'B';
                            $capMarketOrderDetails->business_date    = $businessDate->business_date;
                            $capMarketOrderDetails->trade_time       = now();
                            $capMarketOrderDetails->inst_id          = $listData['instrument_id'];
                            $capMarketOrderDetails->total_shares     = $listData['quantity'];
                            $capMarketOrderDetails->max_min_price    = $listData['price_from'];
                            $capMarketOrderDetails->max_min_price_to = $listData['price_to'];
                            $capMarketOrderDetails->total_amount     = ($listData['price_from'] * $listData['quantity']);
                            $capMarketOrderDetails->total_amount_to  = ($listData['price_to'] * $listData['quantity']);
                            $capMarketOrderDetails->days             = $listData['days'];
            
                            $capMarketOrderDetails->save();
                            
                        }
                    }
                }
                
                return response()->json([
                    'status'  => 'success',
                    'message' => 'Buy order submitted successfully',
                ]);
            } else {
                return response()->json([
                    'status'  => 'error',
                    'message' => 'Not available purchase power',
                ], 400);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status'  => 'error',
                'message' => $th->getMessage(),
            ], 400);
        }
    }
}
