<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JointApplicant extends Model
{
    use HasFactory;

    public    $timestamps = false;
    protected $table      = 'is_joint_applicant';
    protected $primaryKey = 'joint_applicant_id';

    public function occupationDetails()
    {
        return $this->hasOne(Occupation::class, 'occupation_id', 'occupation_id');
    }

    public function nationalityDetails()
    {
        return $this->hasOne(Nationality::class, 'nationality_id', 'nationality_id');
    }

    public function relationDetails()
    {
        return $this->hasOne(Relationship::class, 'relation_id', 'relation_id');
    }

    public function cityDetails()
    {
        return $this->hasOne(City::class, 'city_id', 'city_id');
    }

    public function branchDetails()
    {
        return $this->hasOne(BranchDetails::class, 'org_branch_id', 'org_branch_id');
    }
}
