<?php
use GuzzleHttp\Utils;
use GuzzleHttp\Client;
use Illuminate\Support\Str;

class SmsHelper {
	private $domain;
	private $api_key;
	private $sid;
	private $client;
	private $maxTryToSend = 3;
	private $tryToSendCounter = 1;

	public function __construct() {
		$this->domain = config('sms.domain');
		$this->api_key = config('sms.api_key');
		$this->sid = config('sms.sid');

		$this->client = new Client(
			[
				'base_uri' => $this->domain,
				'headers'  => [
					'Accept'       => 'application/json',
					'Content-Type' => 'application/json',
				]
			]
		);
	}

	public function sendSingleSms($mobile, $message = '')
	{
		$formData = [
			'api_token' => $this->api_key,
			'sid' => $this->sid,
			'msisdn' => $mobile,
			'sms' => $message,
			'csms_id' => $random = Str::random(20),
		];

		try {
			$request = $this->client->post(				
				'/api/v3/send-sms',
				[
					'form_params' => $formData
				]
			);
			
			$response = Utils::jsonDecode($request->getBody());

			if ($response->status_code == 200) {
				$smsinfo = collect($response->smsinfo)->first();
				return response(
					[
						'status' => 'success',
						'message' => 'SMS sent successfully',
						'message_info' => $smsinfo,
					]
				);
			}

			return response(
				[
					'status' => 'error',
					'message' => 'Error sending SMS',
					'errors' => $response->error_message,
				],
				400
			);
		} catch (\Throwable $th) {
			dd($th->getMessage());
			return response(
				[
					'status' => 'error',
					'message' => 'Error sending SMS',
					'errors' => $th->getMessage(),
					'file' => $th->getFile(),
					'line' => $th->getLine(),
				],
				400
			);
		}
	}
	
}
