<?php

namespace App\Http\Controllers\Common;

use SmsHelper;
use App\Models\Otp;
use App\Models\Template;
use App\Models\WebNotice;
use App\Models\Occupation;
use App\Models\BankDetails;
use App\Models\Nationality;
use App\Models\BusinessDate;
use App\Models\Relationship;
use Illuminate\Http\Request;
use App\Models\BranchDetails;
use App\Models\AccountDetails;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class GeneralController extends Controller
{
    public function occupationList()
    {
        $occupationList = Occupation::orderBy('occupation')->get(['occupation_id', 'occupation']);

        return response()->json([
            'status'         => 'success',
            'occupation_ist' => $occupationList,
        ]);
    }

    public function productList()
    {
        $productList = Template::where('trade_code_prefix', '!=', 'O')->orderBy('product_name')->get(['template_id', 'product_name']);

        return response()->json([
            'status'      => 'success',
            'product_ist' => $productList,
        ]);
    }

    public function genderList()
    {
        $genderList = [
            [
                'gender_id' => 'Male',
                'gender'    => 'Male',
            ],
            [
                'gender_id' => 'Female',
                'gender'    => 'Female',
            ],
        ];

        return response()->json([
            'status'     => 'success',
            'gender_ist' => $genderList,
        ]);
    }

    public function residentList()
    {
        $residentList = [
            [
                'resident_id' => 'resident',
                'resident' => 'Resident',
            ],
            [
                'resident_id' => 'nonresident',
                'resident' => 'Non-Resident',
            ],
        ];

        return response()->json([
            'status'       => 'success',
            'resident_ist' => $residentList,
        ]);
    }

    public function nationalityList()
    {
        $nationalityList = Nationality::all(['nationality_id', 'nationality']);

        return response()->json([
            'status'          => 'success',
            'nationality_ist' => $nationalityList,
        ]);
    }

    public function relationshipList()
    {
        $relationshipList = Relationship::orderBy('relation')->get(['relation_id', 'relation']);

        return response()->json([
            'status'           => 'success',
            'relationshipList' => $relationshipList,
        ]);
    }

    public function otpCheck(Request $request)
    {
        $validator = Validator::make(
            $request->all(),
            [
                'otp_code' => 'required|numeric|digits:6',
            ],
            [
                'investor_name.required' => 'The otp field is required',
                'product_id.numeric'     => 'The otp field must be a number',
                'product_id.digits'      => 'The otp field must be 6 digits',
            ]
        );

        if ($validator->fails()) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Form validation error',
                'errors'  => $validator->errors()->messages(),
            ], 400);
        }

        if (true) {
            return response()->json([
                'status'     => 'success',
                'otp_verify' => true,
            ]);
        }

        return response()->json([
            'status'     => 'error',
            'otp_verify' => false,
        ]);
    }

    public function bankList()
    {
        $bankList = BankDetails::orderBy('org_name')
        ->where('active_deactive', 'y')
        ->get(['org_id', 'org_name']);

        return response()->json([
            'status'      => 'success',
            'bank_list' => $bankList,
        ]);
    }

    public function branchList(Request $request)
    {
        $this->validate(
            $request,
            [
                'bank_id' => 'required|numeric'
            ],
            [
                'bank_id.required' => 'Bank id is required',
                'bank_id.numeric' => 'Bank id must be a number',
            ]
        );


        $branchList = BranchDetails::orderBy('branch_name')
        ->where('org_id', $request->bank_id)
        ->get(['org_branch_id as branch_id', 'branch_name', 'routing_no']);

        return response()->json([
            'status'      => 'success',
            'branch_list' => $branchList,
        ]);
    }

    public function paymentTypeList()
    {
        $paymentTypeList = [
            'bkash'  => 'bKash',
            'cheque' => 'Cheque',
            'po'     => 'Pay Order',
            'dd'     => 'Demand Draft',
            'cd'     => 'Cash Deposit',
            'ft'     => 'Fund Transfer',
            'BFTN'     => 'BFTN',
            'NPSB'     => 'NPSB',
            'EFT'     => 'EFT',
        ];

        return response()->json([
            'status'       => 'success',
            'payment_list' => $paymentTypeList,
        ]);
    }
    
    public function depositAccountList()
    {
        $accountDetails = AccountDetails::where('account_details_id', 482)->get(['account_details_id', 'account_name']);

        return response()->json([
            'status'       => 'success',
            'account_list' => $accountDetails,
        ]);
    }

    public function tradingTime()
    {
        // $accountDetails = AccountDetails::where('account_details_id', 482)->get(['account_details_id', 'account_name']);

        return response()->json([
            'status'       => 'success',
            'trading_time' => '',
        ]);
    }

    public function notices()
    {        
        $businessDate  = BusinessDate::latest('business_date')->first();
        $business_date = $businessDate->business_date;
        // $business_date = now()->format('Y-m-d H:i:s');

        $webNotices = WebNotice::where('start_date', '<=', $business_date)
        ->where('end_date', '>=', $business_date)
        ->get(['notice_details as notice']);

        return response()->json([
            'status'          => 'success',
            'notices' => $webNotices,
        ]);
    }

    public function otpResend(Request $request)
    {
        $businessDate = BusinessDate::latest('business_date')->first();
        
        $validator = Validator::make(
            $request->all(),
            [
                'contact_number' => 'required|digits:11',
            ],
            [
                'contact_number.required' => 'The contact number field is required',
                'contact_number.digits'   => 'The contact number must be 11 digits',
            ]
        );

        $otp = Otp::where('mobile', $request->contact_number)
                ->where('otp_verify', null)
                ->first();

        $otp->otp_verify = 'invalid';
        $otp->save();

        $otpCode    = rand(123456, 999999);
        $recordDate = now();
        $message    = "Your OTP for invesment registration is $otpCode. OTP will be valid for next 3 minutes";

        $otp                      = new Otp();
        $otp->message             = $message;
        $otp->otp_code            = $otpCode;
        $otp->mobile              = $request->contact_number;
        $otp->otp_valid_date_time = now()->addMinutes(4);
        $otp->business_date       = $businessDate->business_date;
        $otp->record_date         = $recordDate;

        if ($otp->save()) {
            $smsHelper = new SmsHelper();
            $smsResponse = json_decode($smsHelper->sendSingleSms($request->contact_number, $message)->content());
            // $smsResponse = json_decode($smsHelper->sendSingleSms('01774911240', $message)->content());

            if ($smsResponse->status == 'error') {
                $otp->delete();

                return response()->json([
                    'status'  => 'error',
                    'message' => 'We are unable to resend OTP for veryfying your request',
                ], 400);
            }

            $otp->msg_id = $smsResponse->message_info->csms_id;
            $otp->save();

            return response()->json([
                'status'     => 'success',
                'message' => 'OTP resend successfully',
            ]);
            
        }

        return response()->json([
            'status'  => 'error',
            'message' => 'We are unable to resend OTP for veryfying your request',
        ], 400);
    }
}
