<?php

namespace App\Mail;

use Symfony\Component\Mailer\Transport\AbstractTransport;
use Symfony\Component\Mailer\Transport\Smtp\EsmtpTransport;
use Symfony\Component\Mailer\SentMessage;
use Symfony\Component\Mailer\Envelope;
use Symfony\Component\Mime\RawMessage;
use Symfony\Component\Mailer\Transport\Smtp\Stream\SocketStream;

class CustomSmtpTransport extends AbstractTransport
{
    protected EsmtpTransport $transport;

    public function __construct(string $host, int $port, ?string $encryption, ?string $username, ?string $password)
    {
        $isSsl = $encryption === 'ssl';

        $this->transport = new EsmtpTransport($host, $port, $isSsl);

        $stream = $this->transport->getStream();

        $stream->setStreamOptions([
            'ssl' => [
                'allow_self_signed' => true,
                'verify_peer' => false,
                'verify_peer_name' => false,
            ],
        ]);


        // Enforce STARTTLS mode
        $this->transport->setUsername($username);
        $this->transport->setPassword($password);

        parent::__construct();
    }

    protected function doSend(SentMessage $message): void
    {
        $rawMessage = $message->getOriginalMessage();
        $envelope = $message->getEnvelope();
        $this->transport->send($rawMessage, $envelope);
    }

    public function __toString(): string
    {
        return 'custom_smtp';
    }
}
