<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Attachment;

class InvAcknowledgementMailSender extends Mailable
{
    use Queueable, SerializesModels;

    private $data = [];

    /**
     * Create a new message instance.
     */
    public function __construct(Array $data)
    {
        $this->data = $data;
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        if (!empty($this->data['attachment_path'])) {
            $extension = pathinfo($this->data['attachment_path'], PATHINFO_EXTENSION);
            
            return [
                Attachment::fromPath($this->data['attachment_path'])
                    ->as($this->data['attachment_name'] ?? 'BO_Acknowledgement_Slip.' . $extension)
                    ->withMime($this->data['attachment_mime'] ?? ''),
            ];
        }
        
        return [];
    }

    public function build() {
        return $this->subject($this->data['subject'] ?? 'Brack EPL Investment OTP')
            ->view('emails.bo-acknowledgement', $this->data);
    }
}
