<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TestController;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\IpoInfo\IpoController;
use App\Http\Controllers\Common\GeneralController;
use App\Http\Controllers\Deposit\DepositController;
use App\Http\Controllers\Utility\UtilityController;
use App\Http\Controllers\BuyInfo\BuyOrderController;
use App\Http\Controllers\Utility\ComplainController;
use App\Http\Controllers\Withdraw\WithdrawController;
use App\Http\Controllers\SellInfo\SellOrderController;
use App\Http\Controllers\Report\TaxCertificateController;
use App\Http\Controllers\Report\GainLossSummuryController;
use App\Http\Controllers\Report\DepositStatementController;
use App\Http\Controllers\Report\TransactionLedgerController;
use App\Http\Controllers\Report\WithdrawStatementController;
use App\Http\Controllers\Report\PortfolioStatementController;
use App\Http\Controllers\Investor\AcknowledgementSlipController;
use App\Http\Controllers\Investor\InvestorInformationController;
use App\Http\Controllers\Dashboard\DashboardPortfolioStatementController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//      return $request->user();
//      B0286
// });


Route::controller(TestController::class)->group(function () {
    Route::get('/last-date', 'reportHtml');
    Route::post('/buy', 'submitOrder');
});


Route::group(['middleware' => 'cors'], function () {

    Route::controller(GeneralController::class)->group(function () {
        Route::get('bank-list', 'bankList');
        Route::get('branch-list', 'branchList');
        Route::get('occupation-list', 'occupationList');
        Route::get('gender-list', 'genderList');
        Route::get('product-list', 'productList');
        Route::get('resident-list', 'residentList');
        Route::get('nationality-list', 'nationalityList');
        Route::get('relationship-list', 'relationshipList');
        Route::post('otp-check', 'otpCheck');
        Route::get('payment-type-list', 'paymentTypeList');
        Route::get('deposit-account-list', 'depositAccountList');
        Route::get('trading-time', 'tradingTime');
        Route::get('notices', 'notices');
    });

    Route::controller(AuthController::class)->group(function () {
        Route::get('operation-mode', 'operationMode');
        Route::post('login', 'login')->name('login');
        Route::post('logout', 'logout');
        Route::post('change-password', 'changePassword');
        Route::post('forgot-password/{pageId}', 'forgotPassword')->where('pageId', '[1-3]');
        Route::post('registation/{pageId}', 'registation')->where('pageId', '[1-6]');
        Route::post('refresh', 'refresh');
        Route::post('sign-up/{pageId}', 'signUp');
        
    });

    Route::group(['middleware' => 'auth:api'], function () {
        // Investor Related Information
        Route::controller(InvestorInformationController::class)->group(function () {
            Route::get('personal-information', 'personalInformation');
            Route::post('update-personal-information', 'submitChangeRequest');
        });

        // Dashboard Information
        Route::controller(DashboardPortfolioStatementController::class)->group(function () {
            Route::get('portfolio-statement-dashboard', 'portfolioStatement');
            Route::get('dashboard-summary-info', 'dashboardSummaryInfo');
            Route::get('dashboard-stock-info', 'dashboardStockInfo');
            Route::get('dashboard-sector-info', 'dashboardSectorInfo');
        });

        // Utility Related Information
        Route::controller(UtilityController::class)->group(function () {
            Route::get('business-date', 'businessDate');
            Route::get('purchasepower', 'purchasePower');
        });

        // IPO Related Information
        Route::controller(IpoController::class)->group(function () {
            Route::get('available-ipo-list', 'availableIpoList');
            Route::get('ordered-ipo-list', 'orderedIpoList');
            Route::post('submit-ipo', 'submitIpoOrder');
        });

        // Buy Related Information
        Route::controller(BuyOrderController::class)->group(function () {
            Route::get('buy-instrument-list', 'instrumentList');
            Route::get('buy-ordered-list', 'orderedList');
            Route::get('buy-price-percentage', 'pricePercentage');
            Route::post('buy-submit-order', 'submitOrder');
        });

        // Sell Related Information
        Route::controller(SellOrderController::class)->group(function () {
            Route::get('sell-instrument-list', 'instrumentList');
            Route::get('sell-ordered-list', 'orderedList');
            Route::get('sell-price-percentage', 'pricePercentage');
            Route::post('sell-submit-order', 'submitOrder');
        });

        // Deposit Related Information
        Route::controller(DepositController::class)->group(function () {
            Route::get('depost-list', 'depositList');
            Route::post('deposit-submit', 'submitDeposit');
        });

        // Withdraw Related Information
        Route::controller(WithdrawController::class)->group(function () {
            Route::get('available-balance', 'availableBalance');
            Route::get('withdraw-list', 'withdrawList');
            Route::post('withdraw-submit', 'submitWithdraw');
            // Route::get('payment-type-list', 'paymentTypeList');
        });

        // Complain Feedback
        Route::controller(ComplainController::class)->group(function () {
            Route::get('complain-list', 'complainList');
            Route::post('complain-submit', 'submitComplain');
            // Route::get('payment-type-list', 'paymentTypeList');
        });

        // Acknowledgement Slip
        Route::controller(AcknowledgementSlipController::class)->group(function () {
            Route::get('acknowledgement-slip', 'acknowledgementSlip');
            // Route::get('payment-type-list', 'paymentTypeList');
        });

        // Report Pdf Generation
        Route::group([ 'prefix' => 'report' ], function() {
            Route::controller(PortfolioStatementController::class)->group(function() {
               Route::post('portfolio-statement-download', 'portfolioStatementDownload'); 
            });
            
            Route::controller(DepositStatementController::class)->group(function() {
               Route::post('deposit-statement-download', 'depositStatementDownload'); 
            });
            
            Route::controller(WithdrawStatementController::class)->group(function() {
               Route::post('withdraw-statement-download', 'withdrawStatementDownload'); 
            });
            
            Route::controller(TransactionLedgerController::class)->group(function() {
               Route::post('transaction-ledger-download', 'transactionLedgerDownload'); 
            });
            
            Route::controller(TaxCertificateController::class)->group(function() {
               Route::get('fiscal-year', 'fiscalYear'); 
               Route::post('tax-certificate-download', 'taxCertificateDownload'); 
            });
            
            Route::controller(GainLossSummuryController::class)->group(function() {
               Route::post('gain-loss-download', 'gainLossDownload'); 
            });
        });
    });
});
