<?php echo $__env->make('common.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<tr>
    <td colspan="2" style="border: none;">Report Name</td>
    <td colspan="9" style="border: none;">: Transaction Ledger</td>
</tr>

<tr>
    <td colspan="2" style="border: none;">Period</td>
    <td colspan="9" style="border: none;">: <?php echo e($report_date); ?></td>
</tr>

<tr>
    <td colspan="11" style="border: none;">*All amount in BDT</td>
</tr>

<tr>
    <th style="text-align: left; width: 5%; border: 1px solid #030303;">Sl.</th>
    <th style="text-align: left; width: 10%; border: 1px solid #030303;">Date</th>
    <th style="text-align: left; width: 10%; border: 1px solid #030303;">Event</th>
    <th style="text-align: left; width: 20%; border: 1px solid #030303;">Particulars</th>
    <th style="text-align: right; width: 5%; border: 1px solid #030303;">Quantity</th>
    <th style="text-align: right; width: 5%; border: 1px solid #030303;">Rate</th>
    <th style="text-align: right; width: 10%; border: 1px solid #030303;">Amount</th>
    <th style="text-align: right; width: 5%; border: 1px solid #030303;">Commission</th>
    <th style="text-align: right; width: 10%; border: 1px solid #030303;">Debit</th>
    <th style="text-align: right; width: 10%; border: 1px solid #030303;">Credit</th>
    <th style="text-align: right; width: 10%; border: 1px solid #030303;">Balance</th>
</tr>

<tr>
    <th colspan="10" style="text-align: left;">Opening Balance</th>
    <th style="text-align: right;"><?php echo e(number_format($ledgerBalance, 2)); ?></th>
</tr>

<?php
    $StatusBS = '';
    $totalShares = 0;
    $totalTransLots = 0;
    $grandTotalAmount = 0.00;
    $grandTotalBrokComm = 0.00;
    $grandTotalNetAmount = 0.00;
    $debit = 0.00;
    $credit = 0.00;
    $ledger = $ledgerBalance;
    $grandDebitAmount = 0.00;
    $grandCreditAmount = 0.00;

    $slNo = 0;

    $voucherNo 				= '';
    $taxAmount 				= 0.00;
    $narration 				= '';
    $class					= '';
?>

<?php $__currentLoopData = $transactionLedger; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $balanceData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $TRADE_DATE			= $balanceData->trade_date;
        $PARTICULARS 		= $balanceData->particulars;					
        $TRADING_CODE 		= $balanceData->trading_code;
        $EVENT				= trim($balanceData->event);
        $P_COA_CODE			= $balanceData->trading_code;
        $QUANTITY			= $balanceData->quantity;
        $RATE				= $balanceData->rate;
        $AMOUNT				= $balanceData->amount;
        $NET_AMOUNT			= $balanceData->net_amount;
        $COMMISSION			= $balanceData->commission;
        $DEBIT_CREDIT 		= $balanceData->debit_credit;					
        $NTR 				= $balanceData->ntr;
        $RUNNING_SERIAL		= $balanceData->running_serial;

        $avgRate	= 0;
        if($EVENT == 'inv'){
            $avgRate	= ($NET_AMOUNT+$COMMISSION)/$QUANTITY;
        }else if($EVENT == 'enc'){
            $avgRate	= ($NET_AMOUNT-$COMMISSION)/$QUANTITY;
        }
        //echo $RUNNING_SERIAL; exit;
        if($RUNNING_SERIAL == 7) {
            if($EVENT == 'inv') {
                $StatusBS 	= "Buy";
                $debit 		= $NET_AMOUNT;
                $credit 	= 0.00;
                $ledger 	= $ledger - $debit;
            } else if($EVENT == 'li') {
                $StatusBS 	= "Link In";
                $debit 		= $NET_AMOUNT;
                $credit 	= 0.00;
                $ledger 	= $ledger - $debit;
            } else if ($EVENT == 'lo') {
                $StatusBS 	= "Link Out";
                $debit 		= 0.00;
                $credit 	= $NET_AMOUNT;
                $ledger 	= $ledger + $credit;													
            }
            else if ($EVENT == 'enc') {
                $StatusBS 	= "Sale";
                $debit 		= 0.00;
                $credit 	= $NET_AMOUNT;
                $ledger 	= $ledger + $credit;													
            } else if ($EVENT == 'ipo') {
                $StatusBS 	= "Ipo";
                //$debit 	= $netAmount; // this line closed on 03/03/2016 for IPO application amount off by mamun
                $debit 		= 0.00; // this line added for the reason of IPO application amount stop repeating by mamun on 03/03/2016
                $credit 	= 0.00;
                $ledger 	= $ledger - $debit;												
            } else if ($EVENT == 'preipo') {
                $StatusBS 	= "Pre Ipo";
                $debit 		= $NET_AMOUNT;
                $credit 	= 0.00;
                $ledger 	= $ledger - $debit;													
            } else if ($EVENT == 'rs') {
                $StatusBS 	= "Right Share";
                $debit 		= $NET_AMOUNT;
                $credit 	= 0.00;
                $ledger 	= $ledger - $debit;												
            } else if ($EVENT == 'sd') {
                $StatusBS 	= "Stock Dividend";
                $debit 		= 0.00;
                $credit 	= 0.00;
                $ledger 	= $ledger;													
            } else {
                $StatusBS 	= '-';
                $debit 		= 0.00;
                $credit 	= 0.00;
                //$ledger 	= 0.0000;
            }
            
            if($ledger >= 0) {
                $ledgerPlace = number_format($ledger,2);
            } else {
                $ledgerPlace = '('.number_format(abs($ledger),2).')';
            }

            if($QUANTITY != 0) {
                
    ?>
                <tr>
                    <td style="text-align: left;"><?php echo e(($slNo +1)); ?></td>																
                    <td style="text-align: left;"><?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $TRADE_DATE)->format('d-m-Y')); ?></td>																
                    <td style="text-align: left;"><?php echo e($StatusBS); ?></td>
                    <td style="text-align: left;"><?php echo e($PARTICULARS); ?></td>
                    <td style="text-align: right;"><?php echo e(number_format($QUANTITY,0)); ?></td>
                    <td style="text-align: right;"><?php echo e(number_format($RATE,4)); ?></td>
                    <td style="text-align: right;"><?php echo e(number_format($AMOUNT,2)); ?></td>
                    <td style="text-align: right;"><?php echo e(number_format($COMMISSION,2)); ?></td>
                    <td style="text-align: right;"><?php echo e(number_format($debit,2)); ?></td>
                    <td style="text-align: right;"><?php echo e(number_format($credit,2)); ?></td>
                    <td style="text-align: right;"><?php echo e($ledgerPlace); ?></td>
                </tr>
    <?php
            }
        } else {
            if(substr($P_COA_CODE,0,6) == '302001') {
                if(strtolower($ntr) == 'c'){
                    $narration = 'IPO Return';
                } else {
                    $narration = 'IPO Application';
                }
            } else {
                $narration = $narration;
            }

            $ammount = $AMOUNT;
					
            if($NTR == 'C') {
                $debit = 0.00;
                $credit = $ammount;							
                $ledger = $ledger + $ammount;
            } else if ($NTR == 'D') {
                $debit = $ammount;
                $credit = 0.00;
                $ledger = $ledger - $ammount;													
            } else {
                $debit = 0.00;
                $credit = 0.00;
                //$ledger = 0.0000;
            }
            
            if($ledger >= 0) {
                $ledgerPlace = number_format($ledger,2);
            } else {
                $ledgerPlace = '('.number_format(abs($ledger),2).')';
            }

    ?>
            <tr>
                <td style="text-align: left;"><?php echo e(($slNo +1)); ?></td>																
                <td style="text-align: left;"><?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $TRADE_DATE)->format('d-m-Y')); ?></td>																
                <td style="text-align: left;"><?php echo e($EVENT); ?></td>
                <td style="text-align: left;"><?php echo e($PARTICULARS); ?></td>
                <td style="text-align: right;">-</td>
                <td style="text-align: right;">-</td>
                <td style="text-align: right;">-</td>
                <td style="text-align: right;">-</td>
                <td style="text-align: right;"><?php echo e(number_format($debit,2)); ?></td>
                <td style="text-align: right;"><?php echo e(number_format($credit,2)); ?></td>
                <td style="text-align: right;"><?php echo e($ledgerPlace); ?></td>
            </tr>
    <?php
        }

        $slNo++;
    ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<tr>
    <td colspan="11" style="border-right: none; border-bottom: none; border-left: none;"></td>
</tr>
<?php echo $__env->make('common.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\uslwmcbil_api\resources\views/transaction/index.blade.php ENDPATH**/ ?>