<!DOCTYPE html>
<html lang="en">
<head>
    <title><?php echo e($title); ?></title>
    <style>
        @page {
            margin: 0;
            size: a4;
        }
        body {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
            margin: 0;
            padding: 0;
            width: 100%;
        }

        #header {
            position: fixed;
            left: 0;
            top: 0;
            right: 0;
            height: 105px;
            /* background-color: orange; */
            text-align: center;
            /* border: 1px solid red; */
        }

        #footer {
            position: fixed;
            left: 0;
            bottom: 0;
            right: 0;
            height: 60px;
            /* background-color: yellowgreen; */
            text-align: center;
            /* border: 1px solid red; */
        }

        #footer .page {
            text-align: right;
        }

        #footer .page:after {
            content: "  " counter(page, decimal);
        }

        table {
            width: 100%;
            border-collapse: collapse;
            /* border-spacing: -1px; */
            /* border:collapse; */
        }

        .table-data {
            width: 100%;
            padding-bottom: 25px;
            /* page-break-inside: avoid; */
        }

        .table-data tbody td,
        .table-data tbody th {
            /* border: 1px solid #0072bc; */
            border: 1px solid #030303;
        }

        .table-data.no-border tbody td,
        .table-data.no-border tbody th,
        .table-data tbody td.no-border,
        .table-data tbody th.no-border {
            border: 1px solid transparent;
        }

        .header-table {
            height: 105px;
            margin-bottom: 5px;
        }

        .footer-table {
            height: 60px;
        }

        /* .header,
        .footer {
            width: 99.5%;
            right: 1px;
            left: 1px;
            position: fixed;
        } */

        .content-wrapper {
            padding: 0 15px;
        }

        p.page-break {
            page-break-before: always;
        }

        p.page-break:last-child {
            page-break-before: avoid;
        }

        /* p:last-child {
            page-break-after: avoid;
        } */
    </style>
</head>
<body>
    <?php 
        $locationDate	= 'Dhaka, '.date('F d, Y', strtotime($print_date));
        if($margin_status == 'y'){
            $marginStatus = 'Margin';
        }else{
            $marginStatus = 'Non-Margin';
        }
        $companyName    = 'Community Bank Investment Limited';
    ?>
    <div id="header">
        <div class="content-wrapper">
            <table style="/* background-color: violet; */ margin-top: 15px;">
                <tr>
                    <td style="width: 20%; /* border: 1px solid red; */">
                        <img style="width: 200px;" src="<?php echo e(public_path('images/brack_epl_logo.png')); ?>" alt="" srcset="">
                    </td>
                    <td style="width: 50%; /* border: 1px solid red; */">
                        <table class="header-table-data" style="text-align: center;">
                            <tr>
                                <td style="/* color: #0072bc;  */font-weight: 600; font-size: 18px;">Community Bank Investment Limited</td>
                            </tr>
                            <tr>
                                <td style="/* color: #0072bc;  */font-weight: 600; font-size: 14px;">Portfolio Management</td>
                            </tr>
                            <tr>
                                <td style="/* color: #0072bc;  */font-weight: 600; font-size: 13px;">Head Office</td>
                            </tr>
                            <tr>
                                <td style="/* color: #0072bc;  */font-weight: 600; font-size: 12px;">Police Plaza Concord (Level-12, Tower-2) Gulshan 1, Dhaka-1212.</td>
                            </tr>
                        </table>
                    </td>
                    <td style="width: 30%;"></td>
                </tr>
            </table>
        </div>
    </div>
    <div id="footer">
        <div class="content-wrapper">
            <table>
                <tr>
                    <td style="width: 30%;">
                        <div class="page">Page </div>
                    </td>
                </tr>
            </table>
        </div>
    </div>

    <div id="content" class="content-wrapper">
        <!-- Your main content here -->

        <table class="table-data" style="font-size: 10px;">
        <thead>
            <tr>
                <td>
                    <div class="header-table"></div>
                </td>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td style="border: none;">
                    <table class="table-data no-border" style="font-size: 11px; margin-top: 10px;">
                        <tr>
                            <td style="font-size: 11px; text-align: left;">Ref: CBIL/HO/</td>
                        </tr>
                        <tr>
                            <td style="font-size: 11px; text-align: left;"><?php echo e($locationDate); ?></td>
                        </tr>
                        <tr>
                            <th style="font-size: 17px; font-weight: 700; text-align: center; text-transform:uppercase"><b><u>To Whom It May Concern</u></b></th>
                        </tr>
                        <tr>
                            <td style="text-align: justify; padding-top: 15px;">
                                This is to certify that Mr./ Ms. <strong><?php echo e($account_name); ?></strong>, 
                                <?php if($operation_mode != 3): ?>
                                    Son / Daughter of <strong><?php echo e($father_name); ?></strong> and <strong><?php echo e($mother_name); ?></strong> 
                                <?php endif; ?>
                                has been maintaining a portfolio Account (<?php echo e($marginStatus); ?>) with <?php echo e($companyName); ?>. His/Her details information is given below:
                            </td>
                        </tr>
                    </table>

                    <table class="table-data no-border" style="font-size: 10px;">
                        <tr>
                            <th style="width: 13%; text-align: left;" colspan="6">Account Number : <?php echo e($account_no); ?></th>
                        </tr>
                        
                        <tr>
                            <th style="text-align: left;" colspan="6" >BO ID : <?php echo e($bo_no); ?></th>
                        </tr>
                        <tr>
                            <th style="text-align: left;" colspan="6" >TIN : <?php echo e($inst_tin_no); ?></th>
                        </tr>

                        <tr>                            
                            <th style="text-align: left;" colspan="6">Investment Period : <?php echo e($report_date); ?></th>
                        </tr>
                    </table>
                    <table width="90%" align="center">
                        <tr>
                            <td colspan="4" style="text-align: right;" >*(All figures are in BDT)</td>
                        </tr>
                        <?php $__currentLoopData = $tax_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th colspan="2" style="text-align: left; width: 70%;">Particulars</th>
                                <th colspan="2" style="text-align: right; width: 30%;">Amount</th>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: left; width: 70%;">Opening Equity As on <?php echo e($from_date); ?></td>
                                <td colspan="2" style="text-align: right; width: 30%;"><?php echo e(number_format($data->equity,2)); ?></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: left; width: 70%;">Deposit during this period</td>
                                <td colspan="2" style="text-align: right; width: 30%;"><?php echo e(number_format($data->total_deposit,2)); ?></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: left; width: 70%;">Realized Gain/Loss</td>
                                <td colspan="2" style="text-align: right; width: 30%;"><?php echo e(number_format($data->realize_gain_loss,2)); ?></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: left; width: 70%;">Dividend Income</td>
                                <td colspan="2" style="text-align: right; width: 30%;"><?php echo e(number_format($data->dividend_income,2)); ?></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: left; width: 70%;">Fund Transfer In</td>
                                <td colspan="2" style="text-align: right; width: 30%;"><?php echo e(number_format($data->fund_transfer_in,2)); ?></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: left; width: 70%;">Securities Transfer In</td>
                                <td colspan="2" style="text-align: right; width: 30%;"><?php echo e(number_format($data->sec_transfer_in,2)); ?></td>
                            </tr>
                            <?php 
                                $total_opening=$data->equity+$data->total_deposit+$data->realize_gain_loss+$data->dividend_income+$data->fund_transfer_in+$data->sec_transfer_in;
                            ?>
                            <tr>
                                <th colspan="2" style="text-align: left; width: 70%;">Total</th>
                                <td colspan="2" style="text-align: right; width: 30%;"><b><?php echo e(number_format($total_opening,2)); ?></b></td>
                            </tr>
                            <tr>
                                <th colspan="4"  style="text-align: left; width: 100%;">Less</th>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: left; width: 70%;"> Fund Withdraw</td>
                                <td colspan="2" style="text-align: right; width: 30%;"><?php echo e(number_format($data->total_withdraw0,2)); ?></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: left; width: 70%;">Applied fees & Charge</td>
                                <td colspan="2" style="text-align: right; width: 30%;"><?php echo e(number_format($data->applied_intr_amt,2)); ?></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: left; width: 70%;">Accrued fees & Charge</td>
                                <td colspan="2" style="text-align: right; width: 30%;"><?php echo e(number_format($data->accrued_fees_charge,2)); ?></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: left; width: 70%;">Fund Transfer Out</td>
                                <td colspan="2" style="text-align: right; width: 30%;"><?php echo e(number_format($data->fund_transfer_out,2)); ?></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: left; width: 70%;">Securities Transfer Out</td>
                                <td colspan="2" style="text-align: right; width: 30%;"><?php echo e(number_format($data->sect_tranfer_out,2)); ?></td>
                            </tr>
                            <?php 
                                $total_closing=$data->total_withdraw0+$data->applied_intr_amt+$data->accrued_fees_charge+$data->fund_transfer_out+$data->sect_tranfer_out;
                            ?>
                            <tr>
                                <th colspan="2" style="text-align: left; width: 70%;">Total</th>
                                <td colspan="2" style="text-align: right; width: 30%;"><b><?php echo e(number_format($total_closing,2)); ?></b></td>
                            </tr>
                            <tr>
                                <th colspan="2" style="text-align: left; width: 70%;">Closing Equity: (Cost Basis) (As on <?php echo e($to_date); ?>)</th>
                                <td colspan="2" style="text-align: right; width: 30%;"><b><?php echo e(number_format($total_opening-$total_closing,2)); ?></b></td>
                            </tr>
                            <tr>
                                <th colspan="4" style="text-align: left; width: 100%;">Other Information <?php echo e($to_date); ?></th>
                            </tr>
                            <tr>
                                <td style="text-align: left; width: 30%;">Current Balance / (Loan)</td>
                                <td style="text-align: right; width: 20%;"><?php echo e(number_format($data->current_balance,2)); ?></td>
                                <td style="text-align: left; width: 30%;">Cost Value of Securities</td>
                                <td style="text-align: right; width: 20%;"><?php echo e(number_format($data->close_cost_val,2)); ?></td>
                            </tr>
                            <tr>
                                <td style="text-align: left; width: 30%;">Tax Deducted at Source</td>
                                <td style="text-align: right; width: 20%;"><?php echo e(number_format($data->tax_dividend,2)); ?></td>
                                <td style="text-align: left; width: 30%;">Market Value of Securities</td>
                                <td style="text-align: right; width: 20%;"><?php echo e(number_format($data->close_mkt_val,2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if(!$tax_data): ?>
                            <tr>
                                <th colspan="4" style="text-align: center; width: 100%;">Data Not Found!</th>
                            </tr>     
                        <?php endif; ?>
                        <tr>
                            <td colspan="4" class="no-border" style="padding: 15px 10px; text-align: right; font-size: 12px;">Dividend income is shown after deduction of applicable tax.</td>
                        </tr>
                        <!-- <tr>
                            <th colspan="4" class="no-border" style="padding-top: 15px; text-align: center;  font-size: 12px;">(**This is a system generated report and does not require any signature)</th>
                        </tr> -->
                    </table>
                </td>
            </tr>

<?php echo $__env->make('common.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\uslwmcbil_api\resources\views/taxcertificate/index.blade.php ENDPATH**/ ?>