'use client'
import React, { useState, useEffect, useRef } from 'react';
import styles from "../../assets/style.module.css";
import { useSession } from "next-auth/react";
import Loading from '../loading';
import Swal from 'sweetalert2'
import { signOut } from 'next-auth/react';

const Transaction = () => {
    const [investorPoftfolio, setInvestorPortfolio] = useState([])
    const [isLoading, setIsLoading] = useState(false)
    const { data } = useSession();
    const prevToken = useRef(null);
    const [transactionList, setTransactionList] = useState([]);

    useEffect(() => {
        let token;
        if (data && data.user && data.user.token && data.user.token !== prevToken.current) {
            token = data.user.token;
            prevToken.current = token
            setIsLoading(true);
            fetchTransactionList(token);
        }

    }, [data?.user?.token]);

    const fetchTransactionList = async (token) => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/dashboard-transaction-info';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer ' + String(token)
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                console.log(data.dashboard_summary);
                setTransactionList(data.dashboard_transaction)
            } else if (res.status == 401) {
                Swal.fire({
                    position: "top-end",
                    icon: "warning",
                    title: data.message,
                    showConfirmButton: false,
                    timer: 1000,
                }).then((result) => {
                    if (result.dismiss === Swal.DismissReason.timer) {
                        signOut();
                    }
                });
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        } finally {
            setIsLoading(false)
        }
    };

    if (isLoading) {
        return (
            <Loading loading={isLoading} />
        )
    }

    return (
        <>
            {/* <!-- Recent Transactions --> */}
            <div className={`${styles['transactions-container']}`}>
                <h5>Recent Transactions</h5>
                <table className={`${styles['transactions-table']}`}>
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Perticular's</th>
                            <th>Amount</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        {transactionList && Object.keys(transactionList).length > 0 ?
                            (
                                transactionList.map((data, key) => {
                                    return <tr key={key}>
                                        <td>{data.business_date}</td>
                                        <td>{data.transaction_type}</td>
                                        <td>৳ {data.amount}</td>
                                        <td>{data.transaction_status}</td>
                                    </tr>
                                })
                            ) :
                            (
                                <tr>
                                    <td colSpan={4}>Data not found</td>
                                </tr>
                            )
                        }
                    </tbody>
                </table>
            </div>
            {/* <!-- Recent Transactions --> */}
        </>
    );
};

export default Transaction;
