'use client'
import { useState, useRef, useEffect } from "react";
import { signOut, useSession } from "next-auth/react";
import Swal from "sweetalert2";
import Loading from "../loading";
import styles from "../../assets/style.module.css";

const ClientComponent = () => {
    const [isLoading, setIsLoading] = useState(false)
    const { data } = useSession()
    const prevToken = useRef(null)
    const [investor, setInvestor] = useState([])

    useEffect(() => {
        let token;
        if (data && data.user && data.user.token && data.user.token !== prevToken.current) {
            setIsLoading(true)
            token = data.user.token
            prevToken.current = token
            fetchPersonalInfo(token);
        }
    }, [data?.user?.token])

    const fetchPersonalInfo = async (token) => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/acknowledgement-slip';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer ' + String(token)
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                setInvestor(data.joint_information)
            } else if (res.status == 401) {
                Swal.fire({
                    position: "top-end",
                    icon: "warning",
                    title: data.message,
                    showConfirmButton: false,
                    timer: 1000,
                }).then((result) => {
                    if (result.dismiss === Swal.DismissReason.timer) {
                        signOut();
                    }
                });
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        } finally {
            setIsLoading(false)
        }
    };

    if (isLoading) {
        return (
            <Loading loading={isLoading} />
        )
    }

    return (
        <>
            <div style={{ width: '100%' }} className={`${styles.d_flex} ${styles.mx_20} ${styles.mt_sm_35}`}>
                
                {
                    investor && Object.keys(investor).length > 0 ?
                    (
                        <table style={{ width: '100%' }}>
                            <tbody>
                                <tr>
                                    <td>
                                        Name
                                    </td>
                                    <td>
                                        {investor.name}
                                    </td>
                                    <td>
                                        Spouse Name
                                    </td>
                                    <td>
                                        {investor.spouse_name}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Father Name
                                    </td>
                                    <td>
                                        {investor.father_name}
                                    </td>
                                    <td>
                                        Mother Name
                                    </td>
                                    <td>
                                        {investor.mother_name}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Residency
                                    </td>
                                    <td>
                                        {investor.residency}
                                    </td>
                                    <td>
                                        NID
                                    </td>
                                    <td>
                                        {investor.nid}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        BO A/C No.
                                    </td>
                                    <td>
                                        {investor.bo_account_no}
                                    </td>
                                    <td>
                                        Passport No.
                                    </td>
                                    <td>
                                        {investor.passport_no}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Monthly Income
                                    </td>
                                    <td>
                                        {investor.monthly_income}
                                    </td>
                                    <td>
                                        Bank Account No.
                                    </td>
                                    <td>
                                        {investor.bank_account_no}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Occupation
                                    </td>
                                    <td>
                                        {investor.occupation}
                                    </td>
                                    <td>
                                        Nationality
                                    </td>
                                    <td>{investor.nationality}</td>
                                </tr>
                                <tr>
                                    <td>
                                        Mailing Address
                                    </td>
                                    <td>
                                        {investor.mailing_address}
                                    </td>
                                    <td>
                                        Permanent Address
                                    </td>
                                    <td>
                                        {investor.permanent_address}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Telephone Office
                                    </td>
                                    <td>
                                        {investor.telephone_office}
                                    </td>
                                    <td>
                                        Telephone Resident
                                    </td>
                                    <td>
                                        {investor.telephone_resident}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Mobile
                                    </td>
                                    <td>
                                        {investor.mobile}
                                    </td>
                                    <td>
                                        Fax
                                    </td>
                                    <td>
                                        {investor.fax}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Email
                                    </td>
                                    <td>
                                        {investor.email}
                                    </td>
                                    <td>
                                        Relation With Principal Applicant
                                    </td>
                                    <td>
                                        {investor.relation_with_principal_applicant}
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        Date of Birth
                                    </td>
                                    <td>
                                        {investor.date_of_birth}
                                    </td>
                                    <td>
                                        City
                                    </td>
                                    <td>
                                        {investor.city}
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    ) : (
                        <div style={{ 'text-align': 'center', width: '100%' }}>Joint Applicant Not Found</div>
                    )
                }                
            </div>
        </>
    )
}

export default ClientComponent;