'use client'
import React, { useState, useEffect } from 'react';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faBars } from '@fortawesome/free-solid-svg-icons';
import styles from '../assets/style.module.css';
const ClientComponent = () => {

    const [sideBar, setsideBar] = useState(true);

    const [ctime, setTime] = useState('')

    useEffect(() => {
        let time = new Date().toLocaleTimeString()
        setTime(time)
        const interval = setInterval(() => {
            setTime(new Date().toLocaleTimeString());
        }, 1000);
        return () => clearInterval(interval);
    }, []);


    useEffect(() => {
        const handleResize = () => {
            if (window.innerWidth < 800) {
                sideBarHandler();
            }
        }
        handleResize();
        window.addEventListener('resize', handleResize);
        return () => {
            window.removeEventListener('resize', handleResize);
        }

    }, []);

    const sideBarHandler = () => {
        setsideBar(prevState =>
            !prevState
        );
        const container = document.querySelector('.container')
        sideBar ? container.classList.add('nav-closed') : container.classList.remove('nav-closed');
    };

    return (
        <>
            <button onClick={sideBarHandler} className={styles.button_menu}>
                <FontAwesomeIcon viewBox="0 70 448 300" icon={faBars} />
            </button>
            <p className={`${styles.text_color_white}`}>{ctime}</p>
        </>
    );
};

export default ClientComponent;
