import '@fortawesome/fontawesome-svg-core/styles.css';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faHouseChimney } from '@fortawesome/free-solid-svg-icons';
import { faBuildingColumns } from '@fortawesome/free-solid-svg-icons';
import { faMoneyBill1 } from '@fortawesome/free-solid-svg-icons';
import { faCreditCard } from '@fortawesome/free-solid-svg-icons';
import { faCircleDollarToSlot } from '@fortawesome/free-solid-svg-icons';
import { faMagnifyingGlassChart } from '@fortawesome/free-solid-svg-icons';
import { faComment } from '@fortawesome/free-solid-svg-icons';
import { faIdCard } from '@fortawesome/free-solid-svg-icons';
import { faLock } from '@fortawesome/free-solid-svg-icons';
import { faRightFromBracket } from '@fortawesome/free-solid-svg-icons';
import { faFileInvoice } from '@fortawesome/free-solid-svg-icons';
import { faUser } from '@fortawesome/free-solid-svg-icons';
import styles from '../assets/style.module.css';
import Link from 'next/link';
import { signOut } from 'next-auth/react';

const Sidebar = () => {
    return (
        <div className={'sidebar ' + styles.sidebar}>
            <h4><span className={styles.text_color}>c</span>ommun<span style={{fontSize:'30px'}}>i</span><span className={styles.text_color}>vest</span></h4>

            <ul className={'nav flex-column'}>
                <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="home" ><FontAwesomeIcon icon={faHouseChimney} /><span>Dashboard</span></Link></li>
                <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="deposit"><FontAwesomeIcon icon={faBuildingColumns} /><span>Deposit</span></Link></li>
                <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="withdraw"><FontAwesomeIcon icon={faMoneyBill1} /><span>Withdraw</span></Link></li>
                {/* <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="buyorder"><FontAwesomeIcon icon={faCreditCard} /><span>Buy Order</span></Link></li> */}
                {/* <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="sellorder"><FontAwesomeIcon icon={faCircleDollarToSlot} /><span>Sell Order</span></Link></li> */}
                <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="ipo"><FontAwesomeIcon icon={faMagnifyingGlassChart} /><span>IPO Application</span></Link></li>

                <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="portfoliostatement"><FontAwesomeIcon icon={faFileInvoice} /><span>Portfolio Statement</span></Link></li>

                <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="transactionledger"><FontAwesomeIcon icon={faFileInvoice} /><span>Transaction Ledger</span></Link></li>
                <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="gainlossstatement"><FontAwesomeIcon icon={faFileInvoice} /><span>Gain/ Loss Statement</span></Link></li>
                <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="taxcertificate"><FontAwesomeIcon icon={faFileInvoice} /><span>Tax Certificate</span></Link></li>
                <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="depositstatement"><FontAwesomeIcon icon={faFileInvoice} /><span>Deposit Statement</span></Link></li>
                <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="withdrawstatement"><FontAwesomeIcon icon={faFileInvoice} /><span>Withdraw Statement</span></Link></li>
                {/* <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="#"><FontAwesomeIcon icon={faFileInvoice} /><span>IPO Statement</span></a></li> */}
                {/* <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="complain"><FontAwesomeIcon icon={faFileInvoice} /><span>Complain/Feedback Statement</span></Link></li> */}
                <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="profile"><FontAwesomeIcon icon={faUser} /><span>Personal Information</span></Link></li>
                <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="changeprofile"><FontAwesomeIcon icon={faIdCard} /><span>Update Profile</span></Link></li>
                <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="changepassword"><FontAwesomeIcon icon={faLock} /><span>Change Password</span></Link></li>
                <li className={'nav-item'}><Link className={'nav-link ' + `${styles['nav-link']}`} href="complain"><FontAwesomeIcon icon={faComment} /><span>Complain/Feedback</span></Link></li>
                <li onClick={() => { signOut(); }}><Link className={'nav-link ' + `${styles['nav-link']}`} href={''}><FontAwesomeIcon icon={faRightFromBracket} /> <span>Logout</span></Link></li>
            </ul>
        </div>
    );
}



export default Sidebar