<?php

namespace App\Http\Controllers\IpoInfo;

use Carbon\Carbon;
use App\Models\IpoList;
use App\Models\BusinessDate;
use Illuminate\Http\Request;
use App\Models\OrderedIpoList;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\InvestorDetail;
use Illuminate\Support\Facades\Auth;

class IpoController extends Controller
{
    public function availableIpoList()
    {
        $availableIpoList = [];
        $user = Auth::user();
        $businessDate = BusinessDate::latest('business_date')->first();
        
        $ipoList = IpoList::whereDoesntHave('orderedIpoList', function($query) use ($user) {
            $query->where('portfolio_code', $user->investor_code);
        })
        // ->where('actual_la_date', '>=', $businessDate->business_date)
        ->get();

        foreach ($ipoList as $index => $list) {
            $availableIpoList[$index]['ipo_details_id']      = $list->ipo_details_id;
            $availableIpoList[$index]['instrument_name']     = $list->instrument_name;
            $availableIpoList[$index]['instrument_lot_size'] = number_format($list->instrument_lot_size, 0);
            $availableIpoList[$index]['rate']                = number_format($list->rate, 2);
            $availableIpoList[$index]['facevalue']           = number_format($list->facevalue, 2);
            $availableIpoList[$index]['total_amount']        = number_format($list->total_amount, 2);
        }
        
        return response()->json([
            'status'      => 'success',
            'available_ipo' => $availableIpoList
        ]);
    }

    public function orderedIpoList()
    {
        $orderedIpoList = [];
        $businessDate   = BusinessDate::latest('business_date')->first();
        $user           = Auth::user();
        $ipoList        = OrderedIpoList::where('portfolio_code', $user->investor_code)
        // $ipoList        = OrderedIpoList::where('portfolio_code', 'B1506')
        ->where('business_date', $businessDate->business_date)
        ->with(['ipoDetails'])->get();


        foreach ($ipoList as $index => $list) {
            $orderedIpoList[$index]['instrument_name']      = $list->ipoDetails->instrument_name;
            $orderedIpoList[$index]['instrument_lot_size']  = number_format($list->ipoDetails->instrument_lot_size, 0);
            $orderedIpoList[$index]['facevalue']            = number_format($list->ipoDetails->facevalue, 0);
            $orderedIpoList[$index]['rate']                 = number_format($list->ipoDetails->rate, 2);
            $orderedIpoList[$index]['total_share_per_unit'] = number_format($list->total_share_per_unit, 2);
            $orderedIpoList[$index]['total_amount']         = number_format($list->total_amount, 2);
            $orderedIpoList[$index]['business_date']        = Carbon::createFromFormat('Y-m-d H:i:s', $list->business_date)->format('d-M-Y');
            $orderedIpoList[$index]['record_date']          = Carbon::createFromFormat('Y-m-d H:i:s', $list->record_date)->format('d-M-Y h:i:s a');
        }
        
        return response()->json([
            'status'      => 'success',
            'ordered_ipo' => $orderedIpoList
        ]);
    }

    public function submitIpoOrder(Request $request)
    {
        $requestedData = $request->all();

        // return response($requestedData);

        $this->validate($request, [
            'ipo_details_id' => 'required',
            'quantity' => 'required',
        ]);

        $investorDetails = InvestorDetail::where('portfolio_code', Auth::user()->investor_code)->first();
        $businessDate = BusinessDate::latest('business_date')->first();
        $purchasepower = $this->purchasePower()->getData()->purchase_power;
        $availableIpoListCollection = collect($this->availableIpoList()->getData()->available_ipo)->where('ipo_details_id', $requestedData['ipo_details_id'])->first();
        $quantity = $requestedData['quantity'];
        $rate = is_null($availableIpoListCollection) ? 0 : $availableIpoListCollection->rate;
        
        // dd($availableIpoListCollection, $requestedData, $investorDetails);

        $purchasepower = 1000000;

        if (($purchasepower > ($quantity * $rate)) && (($quantity * $rate) > 1)) {
                   
            $newIpoOrder = new OrderedIpoList();
            $newIpoOrder->template_id = $investorDetails->template_id;
            $newIpoOrder->ipo_details_id = $requestedData['ipo_details_id'];
            $newIpoOrder->portfolio_code = Auth::user()->investor_code;
            $newIpoOrder->rate = $rate;
            $newIpoOrder->total_share_per_unit = $quantity;
            $newIpoOrder->current_balance = $purchasepower;
            $newIpoOrder->purchase_power = $purchasepower;
            $newIpoOrder->total_amount = $quantity * $rate;
            $newIpoOrder->book_building_percent = $quantity * $rate;
            $newIpoOrder->status = 'n';
            $newIpoOrder->business_date = $businessDate->business_date;
            $newIpoOrder->record_date = Carbon::now();
            // $newIpoOrder->operate_by = Auth::user()->investor_details_id;
            
            if ($newIpoOrder->save()) {
                return response()->json([
                    'status'      => 'success',
                    'message'   => 'IPO application submitted successfully',
                    'last_ordered_ipo' => $newIpoOrder,
                ]);
            } else {
                return response()->json([
                    'status'      => 'error',
                    'message'   => 'IPO application not submitted',
                    ], 202);
            }
        } else {
            return response()->json([
                'status'      => 'error',
                'message'   => 'Purchase power is insufficient',
            ], 400);
        }
    }

    private function purchasePower()
    {
        $user = Auth::user();
        $businessDate = BusinessDate::latest('business_date')->first();

        $purchasepower = DB::table('p_investor_portfolio_statement')
            ->selectRaw('distinct nvl(purchase_power, 0) as purchase_power')
            ->where('business_date', '=', $businessDate->business_date)
            ->where('portfolio_code', '=', $user->investor_code)
            ->first();

        // dd($purchasepower);

            
        return response()->json([
            'status'      => 'success',
            'purchase_power' => is_null($purchasepower) ? 999999999 : $purchasepower->purchase_power,
        ]);
    }
}
