<?php

namespace App\Http\Controllers\Report;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class TransactionLedgerController extends Controller
{
    public function transactionLedgerDownload(Request $request)
    {
        $validator = Validator::make(
            $request->all(),
            [
                'from_date'  => 'required|date_format:Y-m-d',
                'to_date'  => 'required|date_format:Y-m-d',
            ],
            [
                'from_date.required'          => 'The as on date filed is required',
                'from_date.date_format'       => 'The as on date field must be in Y-m-d format',
                'to_date.required'          => 'The as on date filed is required',
                'to_date.date_format'       => 'The as on date field must be in Y-m-d format',
            ]
        );

        if ($validator->fails()) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Form validation error',
                'errors' => $validator->errors()->messages(),
            ], 400);
        }

        $data = [
            'title' => 'Transaction Ledger',
        ];

        $user                    = Auth::user();
		$investorDetail          = $user->investorDetail;		
		$toDate                  = Carbon::createFromFormat('Y-m-d', $request->to_date);
        $fromDate                = Carbon::createFromFormat('Y-m-d', $request->from_date);
		$data['account_type']    = $investorDetail->templateDetails->product_short_name;
		$data['account_no']      = $investorDetail->portfolio_code;
		$data['bo_no']           = $investorDetail->bo_account_no;
		$data['account_date']    = Carbon::createFromFormat('Y-m-d H:i:s', $investorDetail->business_date)->format(env('OUTPUT_DATE_FORMAT'));
		$data['account_name']    = $investorDetail->investor_name;
		$data['account_address'] = $investorDetail->mailing_address;
        $data['report_date']     = $fromDate->format('d-m-Y') . ' To ' . $toDate->format('d-m-Y');

        if ($investorDetail->account_enable_disable == 'e') {
			$data['account_status'] = 'Active';
		}

		if ($investorDetail->account_close == 'y') {
			$data['account_status'] = 'Close';
		}

		if ($investorDetail->account_suspend == 'y') {
			$data['account_status'] = 'Suspend';
		}


        $transactionLedgerSql = "
            SELECT PMST.TRAN_DATE       AS TRADE_DATE,
									   PCHD.NARRATION       AS PARTICULARS,
									   ''                   AS TRADING_CODE,
									   PCOA.P_COA_NAME      AS EVENT,
									   PCHD.AC_CODE			AS P_COA_CODE,
									   0                    AS QUANTITY,
									   0                    AS QUANTITY_1,
									   0                    AS RATE,
									   0           	 		AS AVG_RATE,
									   PCHD.AMOUNT          AS AMOUNT,
									   0					AS NET_AMOUNT,
									   0                    AS COMMISSION,
									   PCHD.AMOUNT          AS DEBIT_CREDIT,
									   PCHD.NTR             AS NTR,
									   PMST.RECORD_DATE     AS TRADE_RECORD_DATE,
									   1                    AS RUNNING_SERIAL
								  FROM IS_PORTFOLIO_MASTER  PMST,
									   IS_PORTFOLIO_CHILD   PCHD,
									   IS_INVESTOR_DETAILS  INVESTOR,
									   GS_PORTFOLIO_COA     PCOA
								 WHERE     INVESTOR.PORTFOLIO_CODE = :portfolio_code
									   AND INVESTOR.Portfolio_Code = PCHD.PORTFOLIO_CODE
									   AND PCHD.TRAN_NO = PMST.TRAN_NO
									   AND PCOA.P_COA_CODE = PCHD.AC_CODE
									   AND PMST.TRAN_DATE BETWEEN :from_date AND :to_date
									   AND SUBSTR (PCHD.AC_CODE, 1, 6) IN ('101001', '102001', '103001')
									   AND SUBSTR (PCHD.AC_CODE, 1, 9) NOT IN ('101001002')
								UNION ALL
								SELECT PMST.TRAN_DATE       AS TRADE_DATE,
									   PCHD.NARRATION       AS PARTICULARS,
									   ''                   AS TRADING_CODE,
									   PCOA.P_COA_NAME      AS EVENT,
									   PCHD.AC_CODE			AS P_COA_CODE,
									   0                    AS QUANTITY,
									   0                    AS QUANTITY_1,
									   0                    AS RATE,
									   0           	 		AS AVG_RATE,
									   PCHD.AMOUNT          AS AMOUNT,
									   0					AS NET_AMOUNT,
									   0                    AS COMMISSION,
									   PCHD.AMOUNT          AS DEBIT_CREDIT,
									   PCHD.NTR             AS NTR,
									   PMST.RECORD_DATE     AS TRADE_RECORD_DATE,
									   2                    AS RUNNING_SERIAL
								  FROM IS_PORTFOLIO_MASTER  PMST,
									   IS_PORTFOLIO_CHILD   PCHD,
									   IS_INVESTOR_DETAILS  INVESTOR,
									   GS_PORTFOLIO_COA     PCOA
								 WHERE     INVESTOR.PORTFOLIO_CODE = :portfolio_code
									   AND INVESTOR.Portfolio_Code = PCHD.PORTFOLIO_CODE
									   AND PCHD.TRAN_NO = PMST.TRAN_NO
									   AND PCOA.P_COA_CODE = PCHD.AC_CODE
									   AND PMST.TRAN_DATE BETWEEN :from_date AND :to_date
									   AND SUBSTR (PCHD.AC_CODE, 1, 6) IN ('601001', '201001','501001','501002','501003')
									   AND SUBSTR (PCHD.AC_CODE, 1, 9) NOT IN ('601001004','501001002','501001003')
									   AND LOWER (PCHD.CBJT) != 'j'
								UNION ALL
								SELECT PMST.TRAN_DATE       AS TRADE_DATE,
									   PCHD.NARRATION       AS PARTICULARS,
									   ''                   AS TRADING_CODE,
									   PCOA.P_COA_NAME      AS EVENT,
									   PCHD.AC_CODE			AS P_COA_CODE,
									   0                    AS QUANTITY,
									   0                    AS QUANTITY_1,
									   0                    AS RATE,
									   0           	 		AS AVG_RATE,
									   PCHD.AMOUNT          AS AMOUNT,
									   0					AS NET_AMOUNT,
									   0                    AS COMMISSION,
									   PCHD.AMOUNT          AS DEBIT_CREDIT,
									   PCHD.NTR             AS NTR,
									   PMST.RECORD_DATE     AS TRADE_RECORD_DATE,
									   3                    AS RUNNING_SERIAL
								  FROM IS_PORTFOLIO_MASTER  PMST,
									   IS_PORTFOLIO_CHILD   PCHD,
									   IS_INVESTOR_DETAILS  INVESTOR,
									   GS_PORTFOLIO_COA     PCOA
								 WHERE     INVESTOR.PORTFOLIO_CODE = :portfolio_code
									   AND INVESTOR.Portfolio_Code = PCHD.PORTFOLIO_CODE
									   AND PCHD.TRAN_NO = PMST.TRAN_NO
									   AND PCOA.P_COA_CODE = PCHD.AC_CODE
									   AND PMST.TRAN_DATE BETWEEN :from_date AND :to_date
									   AND SUBSTR (PCHD.AC_CODE, 1, 6) IN ('305001', '305005','305009')
									   AND LOWER (PCHD.NTR) = 'c'
									   AND LOWER (PCHD.CBJT) = 'b'
								UNION ALL
								SELECT PMST.TRAN_DATE       AS TRADE_DATE,
									   PCHD.NARRATION       AS PARTICULARS,
									   ''                   AS TRADING_CODE,
									   PCOA.P_COA_NAME      AS EVENT,
									   PCHD.AC_CODE			AS P_COA_CODE,
									   0                    AS QUANTITY,
									   0                    AS QUANTITY_1,
									   0                    AS RATE,
									   0           	 		AS AVG_RATE,
									   PCHD.AMOUNT          AS AMOUNT,
									   0					AS NET_AMOUNT,
									   0                    AS COMMISSION,
									   PCHD.AMOUNT          AS DEBIT_CREDIT,
									   PCHD.NTR             AS NTR,
									   PMST.RECORD_DATE     AS TRADE_RECORD_DATE,
									   4                    AS RUNNING_SERIAL
								  FROM IS_PORTFOLIO_MASTER  PMST,
									   IS_PORTFOLIO_CHILD   PCHD,
									   IS_INVESTOR_DETAILS  INVESTOR,
									   GS_PORTFOLIO_COA     PCOA
								 WHERE     INVESTOR.PORTFOLIO_CODE = :portfolio_code
									   AND INVESTOR.Portfolio_Code = PCHD.PORTFOLIO_CODE
									   AND PCHD.TRAN_NO = PMST.TRAN_NO
									   AND PCOA.P_COA_CODE = PCHD.AC_CODE
									   AND PMST.TRAN_DATE BETWEEN :from_date AND :to_date
									   AND SUBSTR (PCHD.AC_CODE, 1, 9) IN ('305011003')
									   AND LOWER (PCHD.NTR) = 'd'
									   AND LOWER (PCHD.CBJT) = 'b'
								UNION ALL
								SELECT PMST.TRAN_DATE       AS TRADE_DATE,
									   PCHD.NARRATION       AS PARTICULARS,
									   ''                   AS TRADING_CODE,
									   PCOA.P_COA_NAME      AS EVENT,
									   PCHD.AC_CODE			AS P_COA_CODE,
									   0                    AS QUANTITY,
									   0                    AS QUANTITY_1,
									   0                    AS RATE,
									   0           	 		AS AVG_RATE,
									   PCHD.AMOUNT          AS AMOUNT,
									   0					AS NET_AMOUNT,
									   0                    AS COMMISSION,
									   PCHD.AMOUNT          AS DEBIT_CREDIT,
									   PCHD.NTR             AS NTR,
									   PMST.RECORD_DATE     AS TRADE_RECORD_DATE,
									   5                    AS RUNNING_SERIAL
								  FROM IS_PORTFOLIO_MASTER  PMST,
									   IS_PORTFOLIO_CHILD   PCHD,
									   IS_INVESTOR_DETAILS  INVESTOR,
									   GS_PORTFOLIO_COA     PCOA
								 WHERE     INVESTOR.PORTFOLIO_CODE = :portfolio_code
									   AND INVESTOR.Portfolio_Code = PCHD.PORTFOLIO_CODE
									   AND PCHD.TRAN_NO = PMST.TRAN_NO
									   AND PCOA.P_COA_CODE = PCHD.AC_CODE
									   AND PMST.TRAN_DATE BETWEEN :from_date AND :to_date
									   AND SUBSTR (PCHD.AC_CODE, 1, 6) IN ('302001', '307003')
									   AND LOWER (PCHD.NTR) = 'd'
									   AND LOWER (PCHD.CBJT) = 'b'
								UNION ALL
								SELECT PMST.TRAN_DATE       AS TRADE_DATE,
									   PCHD.NARRATION       AS PARTICULARS,
									   ''                   AS TRADING_CODE,
									   PCOA.P_COA_NAME      AS EVENT,
									   PCHD.AC_CODE			AS P_COA_CODE,
									   0                    AS QUANTITY,
									   0                    AS QUANTITY_1,
									   0                    AS RATE,
									   0           	 		AS AVG_RATE,
									   PCHD.AMOUNT          AS AMOUNT,
									   0					AS NET_AMOUNT,
									   0                    AS COMMISSION,
									   PCHD.AMOUNT          AS DEBIT_CREDIT,
									   PCHD.NTR             AS NTR,
									   PMST.RECORD_DATE     AS TRADE_RECORD_DATE,
									   6                    AS RUNNING_SERIAL
								  FROM IS_PORTFOLIO_MASTER  PMST,
									   IS_PORTFOLIO_CHILD   PCHD,
									   IS_INVESTOR_DETAILS  INVESTOR,
									   GS_PORTFOLIO_COA     PCOA
								 WHERE     INVESTOR.PORTFOLIO_CODE = :portfolio_code
									   AND INVESTOR.Portfolio_Code = PCHD.PORTFOLIO_CODE
									   AND PCHD.TRAN_NO = PMST.TRAN_NO
									   AND PCOA.P_COA_CODE = PCHD.AC_CODE
									   AND PMST.TRAN_DATE BETWEEN :from_date AND :to_date
									   AND SUBSTR (PCHD.AC_CODE, 1, 6) IN ('302001', '307003')
									   AND LOWER (PCHD.NTR) = 'c'
									   AND LOWER (PCHD.CBJT) = 'b'
								UNION ALL
								SELECT CMS.BUSINESS_DATE         AS TRADE_DATE,
									   INSTD.INSTRUMENT_NAME     AS PARTICULARS,
									   MWI.SYMBOL                AS TRADING_CODE,
									   CMS.STATUS                AS EVENT,
									   ''				 		 AS P_COA_CODE,
									   CMS.SHARES                AS QUANTITY,
									   CMOD.TOTAL_SHARES         AS QUANTITY_1,
									   CMS.ACTUAL_RATE           AS RATE,
									   CMS.AVG_RATE           	 AS AVG_RATE,
									   CMS.TOTAL_AMOUNT          AS AMOUNT,
									   CMS.NET_AMOUNT 			 AS NET_AMOUNT,
									   CMS.BROKER_COMMISSION     AS COMMISSION,
									   CMS.NET_AMOUNT            AS DEBIT_CREDIT,
									   ''                        AS NTR,
									   CMS.RECORD_DATE           AS TRADE_RECORD_DATE,
									   7                         AS RUNNING_SERIAL
								  FROM IS_CAP_MKT_ORDER           CMO,
									   IS_CAP_MKT_STOCK           CMS,
									   IS_CAP_MKT_ORDER_DETAILS   CMOD,
									   LS_MARKET_WISE_INSTRUMENT  MWI,
									   LS_INSTRUMENT_DETAILS      INSTD,
									   IS_INVESTOR_DETAILS        INVESTOR
								 WHERE     CMO.CAP_MKT_ORDER_ID = CMOD.CAP_MKT_ORDER_ID
									   AND CMOD.CAP_MKT_ORDER_DETAILS_ID = CMS.CAP_MKT_ORDER_DETAILS_ID
									   AND CMS.PORTFOLIO_CODE = INVESTOR.PORTFOLIO_CODE
									   AND CMOD.MARKET_WISE_INSTRUMENT_ID = MWI.MARKET_WISE_INSTRUMENT_ID
									   AND CMS.INSTRUMENT_DETAILS_ID = INSTD.INSTRUMENT_DETAILS_ID
									   AND CMS.STOCK_MATURE_DATE IS NULL
									   AND UPPER (CMS.STATUS) IN ('INV',
																  'ENC',
																  'SD',
																  'IPO',
																  'PREIPO',
																  'RS',
																  'LI',
																  'LO')
									   AND INVESTOR.PORTFOLIO_CODE = :portfolio_code
									   AND CMS.BUSINESS_DATE BETWEEN :from_date AND :to_date
								ORDER BY TRADE_RECORD_DATE, RUNNING_SERIAL ASC
        ";


        $transactionLedgerResult = DB::select(
            $transactionLedgerSql,
            [
                'from_date' => $fromDate->format('Y-m-d'),
                'to_date' => $toDate->format('Y-m-d'),
                'portfolio_code' => $user->investor_code,
            ]
        );

        // dd($transactionLedgerResult);








        $ledgerBalance = $this->getLedgerBlance($user->investor_code, $fromDate);

        // dd($ledgerBalance);

        $data['transactionLedger'] = $transactionLedgerResult;
        $data['ledgerBalance'] = $ledgerBalance;

        $reportName = 'TransactionLedger_' . $fromDate->format('d_m_Y') . '_' . $toDate->format('d_m_Y') . '.pdf';
        $pdf = Pdf::loadView('transaction.index', $data);
        $pdf->setPaper('a4');
        return $pdf->save($reportName)->stream($reportName);


    }

    private function getLedgerBlance($portfolioCode, $fromDate)
    {
        $ledgerBalanceSql = "
        
            SELECT NVL (
					   SUM (
						   DECODE (SUBSTR (PCHD.NTR, 1, 1),
								   'C', PCHD.AMOUNT,
								   -PCHD.AMOUNT)),
					   0)
					   AS AMOUNT
			  FROM IS_PORTFOLIO_MASTER  PMST,
				   IS_PORTFOLIO_CHILD   PCHD,
				   IS_INVESTOR_DETAILS  INVESTOR,
				   GS_PORTFOLIO_COA     PCOA
			 WHERE     INVESTOR.PORTFOLIO_CODE = :portfolio_code
				   AND PMST.TRAN_DATE < :from_date
				   AND INVESTOR.Portfolio_Code = PCHD.PORTFOLIO_CODE
				   AND PCHD.TRAN_NO = PMST.TRAN_NO
				   AND PCOA.P_COA_CODE = PCHD.AC_CODE
				   AND SUBSTR (PCHD.AC_CODE, 1, 6) IN ('101001', '102001', '103001')
				   AND SUBSTR (PCHD.AC_CODE, 1, 9) NOT IN ('101001002')
			UNION ALL
			SELECT NVL (
					   SUM (
						   DECODE (SUBSTR (PCHD.NTR, 1, 1),
								   'C', PCHD.AMOUNT,
								   -PCHD.AMOUNT)),
					   0)
					   AS AMOUNT
			  FROM IS_PORTFOLIO_MASTER  PMST,
				   IS_PORTFOLIO_CHILD   PCHD,
				   IS_INVESTOR_DETAILS  INVESTOR,
				   GS_PORTFOLIO_COA     PCOA
			 WHERE     INVESTOR.PORTFOLIO_CODE = :portfolio_code
				   AND PMST.TRAN_DATE < :from_date
				   AND INVESTOR.Portfolio_Code = PCHD.PORTFOLIO_CODE
				   AND PCHD.TRAN_NO = PMST.TRAN_NO
				   AND PCOA.P_COA_CODE = PCHD.AC_CODE
				   AND SUBSTR (PCHD.AC_CODE, 1, 6) IN ('601001',
													   '201001',
													   '501001',
													   '501002',
													   '501003')
				   AND SUBSTR (PCHD.AC_CODE, 1, 9) NOT IN
						   ('601001004', '501001002', '501001003')
				   AND LOWER (PCHD.CBJT) != 'j'
			UNION ALL
			SELECT NVL (
					   SUM (
						   DECODE (SUBSTR (PCHD.NTR, 1, 1),
								   'C', PCHD.AMOUNT,
								   -PCHD.AMOUNT)),
					   0)
					   AS AMOUNT
			  FROM IS_PORTFOLIO_MASTER  PMST,
				   IS_PORTFOLIO_CHILD   PCHD,
				   IS_INVESTOR_DETAILS  INVESTOR,
				   GS_PORTFOLIO_COA     PCOA
			 WHERE     INVESTOR.PORTFOLIO_CODE = :portfolio_code
				   AND PMST.TRAN_DATE < :from_date
				   AND INVESTOR.Portfolio_Code = PCHD.PORTFOLIO_CODE
				   AND PCHD.TRAN_NO = PMST.TRAN_NO
				   AND PCOA.P_COA_CODE = PCHD.AC_CODE
				   AND SUBSTR (PCHD.AC_CODE, 1, 6) IN ('305001', '305005')
				   AND LOWER (PCHD.NTR) = 'c'
				   AND LOWER (PCHD.CBJT) = 'b'
			UNION ALL
			SELECT NVL (
					   SUM (
						   DECODE (SUBSTR (PCHD.NTR, 1, 1),
								   'C', PCHD.AMOUNT,
								   -PCHD.AMOUNT)),
					   0)
					   AS AMOUNT
			  FROM IS_PORTFOLIO_MASTER  PMST,
				   IS_PORTFOLIO_CHILD   PCHD,
				   IS_INVESTOR_DETAILS  INVESTOR,
				   GS_PORTFOLIO_COA     PCOA
			 WHERE     INVESTOR.PORTFOLIO_CODE = :portfolio_code
				   AND PMST.TRAN_DATE < :from_date
				   AND INVESTOR.Portfolio_Code = PCHD.PORTFOLIO_CODE
				   AND PCHD.TRAN_NO = PMST.TRAN_NO
				   AND PCOA.P_COA_CODE = PCHD.AC_CODE
				   AND SUBSTR (PCHD.AC_CODE, 1, 9) IN ('305011003')
				   AND LOWER (PCHD.NTR) = 'd'
				   AND LOWER (PCHD.CBJT) = 'b'
			UNION ALL
			SELECT NVL (
					   SUM (
						   DECODE (SUBSTR (PCHD.NTR, 1, 1),
								   'C', PCHD.AMOUNT,
								   -PCHD.AMOUNT)),
					   0)
					   AS AMOUNT
			  FROM IS_PORTFOLIO_MASTER  PMST,
				   IS_PORTFOLIO_CHILD   PCHD,
				   IS_INVESTOR_DETAILS  INVESTOR,
				   GS_PORTFOLIO_COA     PCOA
			 WHERE     INVESTOR.PORTFOLIO_CODE = :portfolio_code
				   AND PMST.TRAN_DATE < :from_date
				   AND INVESTOR.Portfolio_Code = PCHD.PORTFOLIO_CODE
				   AND PCHD.TRAN_NO = PMST.TRAN_NO
				   AND PCOA.P_COA_CODE = PCHD.AC_CODE
				   AND SUBSTR (PCHD.AC_CODE, 1, 6) IN ('302001', '307003')
				   AND LOWER (PCHD.NTR) = 'd'
				   AND LOWER (PCHD.CBJT) = 'b'
			UNION ALL
			SELECT NVL (
					   SUM (
						   DECODE (SUBSTR (PCHD.NTR, 1, 1),
								   'C', PCHD.AMOUNT,
								   -PCHD.AMOUNT)),
					   0)
					   AS AMOUNT
			  FROM IS_PORTFOLIO_MASTER  PMST,
				   IS_PORTFOLIO_CHILD   PCHD,
				   IS_INVESTOR_DETAILS  INVESTOR,
				   GS_PORTFOLIO_COA     PCOA
			 WHERE     INVESTOR.PORTFOLIO_CODE = :portfolio_code
				   AND PMST.TRAN_DATE < :from_date
				   AND INVESTOR.Portfolio_Code = PCHD.PORTFOLIO_CODE
				   AND PCHD.TRAN_NO = PMST.TRAN_NO
				   AND PCOA.P_COA_CODE = PCHD.AC_CODE
				   AND SUBSTR (PCHD.AC_CODE, 1, 6) IN ('302001', '307003')
				   AND LOWER (PCHD.NTR) = 'c'
				   AND LOWER (PCHD.CBJT) = 'b'
			UNION ALL
			SELECT NVL (
					   SUM (
						   DECODE (SUBSTR (CMS.STATUS, 1, 1),
								   'e', CMS.NET_AMOUNT,
								   -CMS.NET_AMOUNT)),
					   0)
					   AS AMOUNT
			  FROM IS_CAP_MKT_ORDER           CMO,
				   IS_CAP_MKT_STOCK           CMS,
				   IS_CAP_MKT_ORDER_DETAILS   CMOD,
				   LS_MARKET_WISE_INSTRUMENT  MWI,
				   LS_INSTRUMENT_DETAILS      INSTD,
				   IS_INVESTOR_DETAILS        INVESTOR
			 WHERE     CMO.CAP_MKT_ORDER_ID = CMOD.CAP_MKT_ORDER_ID
				   AND CMOD.CAP_MKT_ORDER_DETAILS_ID = CMS.CAP_MKT_ORDER_DETAILS_ID
				   AND CMS.PORTFOLIO_CODE = INVESTOR.PORTFOLIO_CODE
				   AND CMOD.MARKET_WISE_INSTRUMENT_ID = MWI.MARKET_WISE_INSTRUMENT_ID
				   AND CMS.INSTRUMENT_DETAILS_ID = INSTD.INSTRUMENT_DETAILS_ID
				   AND CMS.STOCK_MATURE_DATE IS NULL
				   AND UPPER (CMS.STATUS) IN ('INV', 'ENC')
				   AND INVESTOR.PORTFOLIO_CODE = :portfolio_code
				   AND CMO.BUSINESS_DATE < :from_date
        
        ";


        $ledgerBalanceResult = DB::select(
            $ledgerBalanceSql,
            [
                'from_date' => $fromDate->format('Y-m-d'),
                'portfolio_code' => $portfolioCode,
            ]
        );

        return collect($ledgerBalanceResult)->sum('amount');
    }
}
