'use client'
import React, { useState, useEffect, useRef } from 'react';
import styles from "../../assets/style.module.css";
import { useSession } from "next-auth/react";
import Loading from '../loading';
import Swal from 'sweetalert2'
import { signOut } from 'next-auth/react';

const ClientComponent = () => {

    const [investor, setInvestor] = useState([])
    const [bankList, setBankList] = useState([])
    const [branchList, setBranchList] = useState([])
    const [isLoading, setIsLoading] = useState(false)
    const { data } = useSession()
    const prevToken = useRef(null)

    const [changeData, setChangeData] = useState('')
    const [investorName, setInvestorName] = useState()
    const [mailingAddress, setMailingAddress] = useState()
    const [nidNumber, setNidNumber] = useState()
    const [nidPhoto, setNidPhoto] = useState()
    const [tinNumber, setTinNumber] = useState()
    const [tinPhoto, setTinPhoto] = useState()
    const [accountNo, setAccountNo] = useState()
    const [depositSlip, setDepositSlip] = useState()
    const [bank, setBank] = useState()
    const [branch, setBranch] = useState()

    const [changeDataError, setChangeDataError] = useState()
    const [investorNameError, setInvestorNameError] = useState()
    const [mailingAddressError, setMailingAddressError] = useState()
    const [nidNumberError, setNidNumberError] = useState()
    const [nidPhotoError, setNidPhotoError] = useState()
    const [tinNumberError, setTinNumberError] = useState()
    const [tinPhotoError, setTinPhotoError] = useState()
    const [accountNoError, setAccountNoError] = useState()
    const [depositSlipError, setDepositSlipError] = useState()
    const [bankError, setBankError] = useState()
    const [branchError, setBranchError] = useState()

    const changeIndex={
        0:'Investor Name',
        1:'Mailing Address',
        2:'NID',
        3:'TIN',
        4:'Bank Name',
        // 5:'Branch Name',
        // 6:'Account No.',
        // 7:'Cheque'
    }

    useEffect(() => {
        let token;
        if (data && data.user && data.user.token && data.user.token !== prevToken.current) {
            token = data.user.token;
            prevToken.current = token
            setIsLoading(true);
            fetchData(token);
            fetchBankList(token)
        }

    }, [data?.user?.token]);

    const fetchData = async (token) => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/personal-information';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer ' + String(token)
                }
            });
            const data = await res.json();
            console.log(data)
            if (data.status == 'success') {
                setInvestorName(data.investor.investor_name)
                setMailingAddress(data.investor.mailing_address)
                setNidNumber(data.investor.nid)
                setTinNumber(data.investor.tin)
                setBank(data.investor.bank_id)
                setBranch(data.investor.branch_id)
                setInvestor(data.investor)

                fetchBranchList(data.investor.bank_id, token)

            } else if (res.status == 401) {
                Swal.fire({
                    position: "top-end",
                    icon: "warning",
                    title: data.message,
                    showConfirmButton: false,
                    timer: 1000,
                }).then((result) => {
                    if (result.dismiss === Swal.DismissReason.timer) {
                        signOut();
                    }
                });
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        } finally {
            setIsLoading(false)
        }
    };

    const fetchBankList = async (token) => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/bank-list';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer ' + String(token)
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                setBankList(data.bank_list)
            } else if (res.status == 401) {
                Swal.fire({
                    position: "top-end",
                    icon: "warning",
                    title: data.message,
                    showConfirmButton: false,
                    timer: 1000,
                }).then((result) => {
                    if (result.dismiss === Swal.DismissReason.timer) {
                        signOut();
                    }
                });
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        }
    };

    const fetchBranchList = async (bank_id, token) => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/branch-list?bank_id=' + bank_id;
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer ' + String(token)
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                setBranchList(data.branch_list)
            } else if (res.status == 401) {
                Swal.fire({
                    position: "top-end",
                    icon: "warning",
                    title: data.message,
                    showConfirmButton: false,
                    timer: 1000,
                }).then((result) => {
                    if (result.dismiss === Swal.DismissReason.timer) {
                        signOut();
                    }
                });
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        }
    };


    const handleInputChange = (e, setStateFunction, index) => {
        let element = e.target
        element.classList.add(styles.invalid)
        let children = element.parentElement.children;
        children[children.length - 1].textContent = element.validationMessage

        const value = element.value

        if(element.name=='changeData'){
            setInvestorName('')
            setMailingAddress('')
            setNidNumber('')
            setNidPhoto('')
            setTinNumber('')
            setTinPhoto('')
            setAccountNo('')
            setBank('')
            setBranch('')
            setDepositSlip('')
        }

        if (element.type == 'file') {
            setStateFunction(e.target.files[0])
        }else if (element.name == 'bank') {
            fetchBranchList(value, prevToken.current)
            setStateFunction(value)
        }
        else {
            setStateFunction(value)
        }

    };

    const ValidationHandle = (e) => {
        e.preventDefault()
        let element = e.target
        element.classList.add(styles.invalid)
        let children = element.parentElement.children;
        children[children.length - 1].textContent = element.validationMessage
    }

    const handleSubmit = async (e) => {
        e.preventDefault()
        setIsLoading(true)

        const formData = new FormData();
        
        formData.append('name', (investorName!=undefined?investorName:''))
        formData.append('mailing_address', (mailingAddress!=undefined?mailingAddress:''))
        formData.append('nid', (nidNumber!=undefined?nidNumber:''))
        formData.append('nid_photo', nidPhoto)
        formData.append('tin', (tinNumber!=undefined?tinNumber:''))
        formData.append('tin_photo', tinPhoto)
        formData.append('bank_id', (bank!=undefined?bank:''))
        formData.append('branch_id', (branch!=undefined?branch:''))
        formData.append('bank_account_no', (accountNo!=undefined?accountNo:''))
        formData.append('bank_leaf', depositSlip)
        formData.append('change_field',changeData)

        const url = process.env.NEXT_PUBLIC_API_URL + '/update-personal-information';
        try {
            const response = await fetch(url, {
                method: 'POST',
                headers: {
                    'Authorization': 'Bearer ' + String(prevToken.current)
                },
                body: formData
            });

            if (response.status == 500) {
                throw new Error('Internal server error');
            }
            const data = await response.json();
            if (response.status != 200) {
                const setters = {
                    name: setInvestorNameError,
                    mailing_address: setMailingAddressError,
                    nid: setNidNumberError,
                    nid_photo: setNidPhotoError,
                    tin: setTinNumberError,
                    tin_photo: setTinPhotoError,
                    bank_id: setBankError,
                    branch_id: setBranchError,
                    bank_account_no: setAccountNoError,
                    bank_leaf: setDepositSlipError
                };
                if (data.errors == undefined) {
                    const message = data.message
                    throw new Error(message);
                } else {
                    Object.entries(data.errors).forEach(([key, value]) => {
                        const setterName = key;
                        const setterFunction = setters[setterName];
                        if (setterFunction) {
                            setterFunction(value[0]);
                        }
                    });
                }
            }

            if (data.status == 'success') {
                Swal.fire({
                    position: "top-end",
                    icon: "success",
                    title: data.message,
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        } catch (error) {
            if (error instanceof TypeError) {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            } else {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: error.message,
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        } finally {
            setIsLoading(false)
        }

    };

    if (isLoading) {
        return (
            <Loading loading={isLoading} />
        )
    }

    return (

        <>
            <form className={`${styles.d_flex} ${styles.flex_direction_col}`} onSubmit={handleSubmit}>
                <div className={`${styles.d_flex} ${styles.flex_direction_col_md} ${styles.flex_justify_center} ${styles.flex_wrap} ${styles.flex_no_wrap}`}>
                    <div className={`${styles.formcontrol} ${styles.mx_10} ${styles.flex_19} ${styles.flex_direction_col}`}>
                        <select
                            className={styles.input}
                            defaultValue={changeData}
                            required
                            onChange={(e) => handleInputChange(e, setChangeData)}
                            name={`changeData`}
                            onInvalid={e => ValidationHandle(e)}
                        >
                            <option disabled></option>
                            {
                                changeIndex && Object.keys(changeIndex).length > 0 ?
                                    (
                                        Object.entries(changeIndex).map(([key, value]) => {
                                            return <option
                                                value={key}
                                                key={key}
                                            >
                                                {value}
                                            </option>
                                        })
                                    ) :
                                    (
                                        <option disabled>Data not available</option>
                                    )

                            }
                        </select>
                        <label
                            className={`${styles.label} ${styles.text_size_13}`}
                        >Select</label>
                        {
                            changeDataError ?
                                (
                                    <span
                                        className={`${styles.text_left} ${styles.back_invalid}`}
                                    >
                                        {changeDataError}
                                    </span>
                                ) :
                                (
                                    <span
                                        className={`${styles.text_left} ${styles.invalid_message}`}
                                    >
                                    </span>
                                )
                        }
                    </div>
                </div>

                <div className={`${styles.d_flex} ${styles.flex_direction_col_md} ${styles.flex_justify_center} ${styles.flex_wrap} ${styles.flex_no_wrap}`}>
                    {
                        changeData=='0'&&
                        <div className={`${styles.formcontrol} ${styles.mx_10} ${styles.flex_19} ${styles.flex_direction_col}`}>
                            <input
                                className={styles.input}
                                type="text"
                                defaultValue={investor.investor_name}
                                required
                                onChange={(e) => handleInputChange(e, setInvestorName)}
                                name={`investorName`}
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            >Investor Name</label>
                            {
                                investorNameError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {investorNameError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                    }
                    {
                        changeData=='1'&&
                        <div className={`${styles.formcontrol} ${styles.mx_10} ${styles.flex_19} ${styles.flex_direction_col}`}>
                            <input
                                className={styles.input}
                                type="text"
                                defaultValue={investor.mailing_address}
                                required
                                onChange={(e) => handleInputChange(e, setMailingAddress)}
                                name={`mailingAddress`}
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            > Mailing Address </label>
                            {
                                mailingAddressError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {mailingAddressError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                    }

                    {
                        changeData=='2'&&
                        <div className={`${styles.formcontrol} ${styles.mx_10} ${styles.flex_19} ${styles.flex_direction_col}`}>
                            <input
                                className={styles.input}
                                type="text"
                                required
                                onChange={(e) => handleInputChange(e, setNidNumber)}
                                name="nidNumber"
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            > NID Number </label>
                            {
                                nidNumberError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {nidNumberError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                    }

                    {
                        (changeData=='2' || changeData=='0')&&
                        <div className={`${styles.formcontrol} ${styles.mx_10} ${styles.flex_19} ${styles.flex_direction_col}`}>
                            <input
                                className={styles.input}
                                type="file"
                                defaultValue={investor.nidPhoto}
                                required
                                onChange={(e) => handleInputChange(e, setNidPhoto)}
                                name={`nidPhoto`}
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            > NID Photo</label>
                            {
                                nidPhotoError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {nidPhotoError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                    }

                    {
                        changeData=='3'&&
                        <div className={`${styles.formcontrol} ${styles.mx_10} ${styles.flex_19} ${styles.flex_direction_col}`}>
                            <input
                                className={styles.input}
                                type="text"
                                defaultValue={investor.tinNumber}
                                required
                                onChange={(e) => handleInputChange(e, setTinNumber)}
                                name={`tinNumber`}
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            > TIN Number</label>
                            {
                                tinNumberError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {tinNumberError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                    }

                    {
                        changeData=='3'&&
                        <div className={`${styles.formcontrol} ${styles.mx_10} ${styles.flex_19} ${styles.flex_direction_col}`}>
                            <input
                                className={styles.input}
                                type="file"
                                required
                                onChange={(e) => handleInputChange(e, setTinPhoto)}
                                name="tinPhoto"
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            > TIN Photo </label>
                            {
                                tinPhotoError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {tinPhotoError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                    }


                    {
                        (changeData=='4' || changeData=='5' || changeData=='6' || changeData=='7')&&
                        <div className={`${styles.formcontrol} ${styles.mx_10} ${styles.flex_19} ${styles.flex_direction_col}`}>
                            <select
                                className={styles.input}
                                defaultValue={bank}
                                required
                                onChange={(e) => handleInputChange(e, setBank)}
                                name={`bank`}
                                onInvalid={e => ValidationHandle(e)}
                            >
                                <option disabled></option>
                                {
                                    bankList && Object.keys(bankList).length > 0 ?
                                        (
                                            bankList.map((data, key) => {
                                                return <option
                                                    value={data.org_id}
                                                    key={data.org_id}
                                                >
                                                    {data.org_name}
                                                </option>
                                            })
                                        ) :
                                        (
                                            <option disabled>Data not available</option>
                                        )

                                }
                            </select>
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            >Bank Name</label>
                            {
                                bankError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {bankError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                    }

                    {
                        (changeData=='4' || changeData=='5' || changeData=='6' || changeData=='7')&&
                        <div className={`${styles.formcontrol} ${styles.mx_10} ${styles.flex_19} ${styles.flex_direction_col}`}>
                            <select
                                className={styles.input}
                                defaultValue={branch}
                                required
                                onChange={(e) => handleInputChange(e, setBranch)}
                                name={`branch`}
                                onInvalid={e => ValidationHandle(e)}
                            >
                                <option disabled></option>
                                {
                                    branchList && Object.keys(branchList).length > 0 ?
                                        (
                                            branchList.map((data, key) => {
                                                return <option
                                                    value={data.branch_id}
                                                    key={data.branch_id}
                                                >
                                                    {data.branch_name}
                                                </option>
                                            })
                                        ) :
                                        (
                                            <option disabled>Data not available</option>
                                        )

                                }
                            </select>
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            >Branch Name</label>
                            {
                                branchError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {branchError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                    }

                    {
                        (changeData=='4' || changeData=='5' || changeData=='6' || changeData=='7')&&
                        <div className={`${styles.formcontrol} ${styles.mx_10} ${styles.flex_19} ${styles.flex_direction_col}`}>
                            <input
                                className={styles.input}
                                type="text"
                                defaultValue={investor.bank_account_no}
                                required
                                onChange={(e) => handleInputChange(e, setAccountNo)}
                                name={`accountNo`}
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            > Account No. </label>
                            {
                                accountNoError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {accountNoError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                    }

                    {
                        (changeData=='4' || changeData=='5' || changeData=='6' || changeData=='7')&&
                        <div className={`${styles.formcontrol} ${styles.mx_10} ${styles.flex_19} ${styles.flex_direction_col}`}>
                            <input
                                className={styles.input}
                                type="file"
                                required
                                onChange={(e) => handleInputChange(e, setDepositSlip)}
                                name="depositSlip"
                                onInvalid={e => ValidationHandle(e)}
                            />
                            <label
                                className={`${styles.label} ${styles.text_size_13}`}
                            > Cheque Leaf </label>
                            {
                                depositSlipError ?
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.back_invalid}`}
                                        >
                                            {depositSlipError}
                                        </span>
                                    ) :
                                    (
                                        <span
                                            className={`${styles.text_left} ${styles.invalid_message}`}
                                        >
                                        </span>
                                    )
                            }
                        </div>
                    }
                </div>
                {
                    changeData&&
                    <div className={`${styles.formcontrol} ${styles.my_30} ${styles.d_flex} ${styles.flex_space_around} `}>
                        <button
                            className={styles.input_btn}
                        >Submit</button>
                    </div>
                }

            </form>

            <div className={`${styles.d_flex} ${styles.mx_20}`}>

            </div>
        </>
    );
};

export default ClientComponent;
