'use client';
import React, { useState, useEffect, useRef } from 'react';
import styles from "../../assets/style.module.css";
import { useSession } from "next-auth/react";
import Loading from '../loading';
import Swal from 'sweetalert2';
import { signOut } from 'next-auth/react';
// import { PieChart, Pie, Cell, Tooltip, Legend } from "recharts";
import { Pie } from 'react-chartjs-2'
import { Chart as ChartJS, ArcElement, Tooltip, Legend } from 'chart.js';

ChartJS.register(ArcElement, Tooltip, Legend);


// const COLORS = ['#2ba9da', '#0070bb', '#2a2f8d'];
const top3StockColor = ['#2ba9da', '#0070bb', '#2a2f8d'];

const StockChart = () => {
    const [investorPoftfolio, setInvestorPortfolio] = useState([]);
    const [isLoading, setIsLoading] = useState(false);
    const { data } = useSession();
    const prevToken = useRef(null);

    useEffect(() => {
        let token;
        if (data?.user?.token && data.user.token !== prevToken.current) {
            token = data.user.token;
            prevToken.current = token;
            setIsLoading(true);
            fetchPortfolioData(token);
        }
    }, [data?.user?.token]);

    const fetchPortfolioData = async (token) => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/dashboard-stock-info';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    "Content-Type": "application/json",
                    "Authorization": `Bearer ${token}`,
                },
            });
            const responseData = await res.json();
            if (responseData.status === 'success') {               
                setInvestorPortfolio(responseData.top_stock);
            } else if (res.status === 401) {
                Swal.fire({
                    position: "top-end",
                    icon: "warning",
                    title: responseData.message,
                    showConfirmButton: false,
                    timer: 1000,
                }).then(() => {
                    signOut();
                });
            }
        } catch (error) {
            Swal.fire({
                position: "top-end",
                icon: "error",
                title: 'The server is not responding. Please wait for a moment.',
                showConfirmButton: false,
                timer: 2000,
            });
        } finally {
            setIsLoading(false);
        }
    };

    if (isLoading) {
        // return <Loading loading={isLoading} />;
    }
    
    
    const chartData = investorPoftfolio.map((item) => ({
        name: item.symbol,
        value: parseFloat(item.total_cost_amount),
    }));

    const chartJsChartData = {
        labels: chartData.map((item) => item.name),
        datasets: [
            {
                data: chartData.map((item) => item.value),
                backgroundColor: chartData.map((item, index) => top3StockColor[index]),
            }
        ]
    }

    return (
        <div className={'col-md-6'}>
            {investorPoftfolio.length > 0 ? (
                <div className={`${styles['chart-container']}`}>
                    <div>
                        <h5>Top 3 Stocks</h5>
                        <Pie data={chartJsChartData} />
                    </div>
                </div> 
            ) : (
                <h2>No data available for the Stock</h2>
            )}
        </div>    
    );
};

export default StockChart;
