<?php

namespace App\Http\Controllers\Dashboard;

use Carbon\Carbon;
use App\Models\BusinessDate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DashboardPortfolioStatementController extends Controller
{
    public function portfolioStatement()
    {
        $user                    = Auth::user();
		$businessDate            = BusinessDate::latest('business_date')->first();
        
        $portfolioStatementSql = "            
                SELECT NVL ((P_PORTFOLIO_STATEMENT_TEMP.TOTAL_DEPOSIT), 0)
                        AS CURRENT_DEPOSIT,
                    NVL ((P_PORTFOLIO_STATEMENT_TEMP.COST_VALUE_SECURITIES), 0)
                        AS COST_VALUE_SECURITIES,
                    NVL ((P_PORTFOLIO_STATEMENT_TEMP.MARKET_VALUE_SECURITIES), 0)
                        AS MARKET_VALUE_SECURITIES,
                    0 AS CURRENT_ASSET_LIABILITIES,
                    NVL ((P_PORTFOLIO_STATEMENT_TEMP.EQUITY), 0)
                        AS EQUITY,
                    NVL (
                        (  P_PORTFOLIO_STATEMENT_TEMP.REALIZE_GAIN_LOSS
                            + P_PORTFOLIO_STATEMENT_TEMP.UNREALIZE_GAIN_LOSS
                            + P_PORTFOLIO_STATEMENT_TEMP.DIVIDEND_INCOME),
                        0)
                        AS NET_GAIN_LOSS
                FROM P_PORTFOLIO_STATEMENT_TEMP,
                    IS_INVESTOR_DETAILS             INVDET
                WHERE     P_PORTFOLIO_STATEMENT_TEMP.PORTFOLIO_CODE = INVDET.PORTFOLIO_CODE
                    AND INVDET.PORTFOLIO_CODE = :investor_code
                    AND P_PORTFOLIO_STATEMENT_TEMP.BUSINESS_DATE =
                        (SELECT MAX (P_PORTFOLIO_STATEMENT_TEMP.BUSINESS_DATE)
                            FROM P_PORTFOLIO_STATEMENT_TEMP,
                                L_BUSINESS_DATE                 BDAT
                            WHERE     P_PORTFOLIO_STATEMENT_TEMP.PORTFOLIO_CODE =
                                    INVDET.PORTFOLIO_CODE
                                AND P_PORTFOLIO_STATEMENT_TEMP.BUSINESS_DATE =
                                    BDAT.BUSINESS_DATE
                                AND INVDET.PORTFOLIO_CODE = :investor_code
                                AND P_PORTFOLIO_STATEMENT_TEMP.BUSINESS_DATE <= :business_date
                                )
            ";

            $portfolioStatementResult = DB::select(
                $portfolioStatementSql,
                [
                    'business_date' => Carbon::createFromFormat('Y-m-d H:i:s', $businessDate->business_date)->format('Y-m-d'),
                    'investor_code' => $user->investor_code,
                ]
            );


            $portfolioStatementResultArr = [];

            foreach ($portfolioStatementResult as $key => $value) {
                foreach ($value as $columnName => $val) {
                    if ('net_gain_loss' == $columnName) {
                        $columnValue = ($val < 0) ? '(' . number_format(abs($val), 2) . ')' : number_format($val, 2);
                    } else {
                        $columnValue = number_format($val, 2);
                    }

                    $portfolioStatementResultArr[$key][$columnName] = $columnValue;
                }
            }


            return response()->json([
                'status'          => 'success',
                'dashboard_portfolio_statement' => collect($portfolioStatementResultArr)->first(),
            ]);
    }

    public function dashboardSummaryInfo()
    {
        $user                    = Auth::user();
		$businessDate            = BusinessDate::latest('business_date')->first();
        
        $summarySql = "   SELECT A.PORTFOLIO_CODE,
                                CASE NVL (B.APPLICANT_NAME, '$')
                                    WHEN '$'
                                    THEN
                                        (CASE
                                                WHEN A.OPERATION_MODE_ID = 1 THEN A.INVESTOR_NAME
                                                ELSE A.INSTITUTION_NAME
                                            END)
                                    ELSE
                                        A.INVESTOR_NAME || ' and ' || B.APPLICANT_NAME
                                END
                                    AS INVESTOR_NAME,
                                ROUND (NVL (C.COST_VALUE_SECURITIES, 0), 2)
                                    AS COST_VALUE_SECURITIES,
                                ROUND (NVL (C.MARKET_VALUE_SECURITIES, 0), 2)
                                    AS MARKET_VALUE_SECURITIES,
                                ROUND (NVL (C.EQUITY_AT_MARKET, 0), 2)
                                    AS EQUITY_AT_MARKET,
                                ROUND (NVL (C.CMR_RATION, 0), 2)
                                    AS CMR_RATION,
                                CASE
                                    WHEN NVL (C.PURCHASE_POWER, 0) < 0
                                    THEN
                                        '(' || TO_CHAR (ROUND (NVL (C.PURCHASE_POWER, 0), 2)) || ')'
                                    ELSE
                                        TO_CHAR (ROUND (NVL (C.PURCHASE_POWER, 0), 2))
                                END
                                    AS PURCHASE_POWER,
                                 
                                                ROUND (
                                                    ABS (
                                                            NVL (C.REALIZE_GAIN_LOSS, 0)
                                                        + NVL (C.UNREALIZE_GAIN_LOSS, 0)
                                                        + NVL (C.RECEIVED_DIVIDEND, 0)),
                                                    2) AS NET_GAIN_LOSS
                            FROM IS_INVESTOR_DETAILS         A,
                                IS_JOINT_APPLICANT          B,
                                P_PORTFOLIO_STATEMENT_TEMP  C
                            WHERE     A.INVESTOR_DETAILS_ID = B.INVESTOR_DETAILS_ID(+)
                                AND A.PORTFOLIO_CODE = C.PORTFOLIO_CODE(+)
                                AND A.PORTFOLIO_CODE = :investor_code
                                AND C.BUSINESS_DATE = :business_date
                        ";

            $summaryResult = DB::select(
                $summarySql,
                [
                    'business_date' => Carbon::createFromFormat('Y-m-d H:i:s', $businessDate->business_date)->format('Y-m-d'),
                    'investor_code' => $user->investor_code,
                ]
            ); 
             
            
            return response()->json([
                'status'          => 'success',
                'dashboard_summary' => $summaryResult,  
            ]);
    }
    public function dashboardStockInfo()
    {
        $user                    = Auth::user();
		$businessDate            = BusinessDate::latest('business_date')->first();
        
        
            $topStockSql = "SELECT SI.SYMBOL, SI.TOTAL_COST_AMOUNT, SI.TOTAL_MKT_AMOUNT
                        FROM (  SELECT MWINSTDET.SYMBOL
                                            AS SYMBOL,
                                        ROUND(NVL (ISCMS.TOTAL_SHARE * ISCMS.AVG_RATE, 0),2)
                                            AS TOTAL_COST_AMOUNT,
                                        ROUND(NVL (P_CAP_MKT_PRICE.CLOSE_PRICE * ISCMS.TOTAL_SHARE, 0),2)
                                            AS TOTAL_MKT_AMOUNT
                                    FROM GS_SECTOR            GSECT,
                                        GS_SATTLEMENT_CAT    SATCAT,
                                        IS_CAP_MKT_STOCK     ISCMS
                                        LEFT JOIN
                                        (SELECT BSHARE.PORTFOLIO_CODE,
                                                BSHARE.INSTRUMENT_DETAILS_ID,
                                                BSHARE.BLOCK_SHARE
                                            FROM IS_BLOCK_SHARE_STOCK BSHARE
                                        WHERE IS_BLOCK_SHARE_ID =
                                                (SELECT MAX (IS_BLOCK_SHARE_ID)
                                                    FROM IS_BLOCK_SHARE_STOCK
                                                WHERE     PORTFOLIO_CODE = BSHARE.PORTFOLIO_CODE
                                                        AND INSTRUMENT_DETAILS_ID =
                                                            BSHARE.INSTRUMENT_DETAILS_ID)) BLKSHR
                                            ON     BLKSHR.INSTRUMENT_DETAILS_ID =
                                                    ISCMS.INSTRUMENT_DETAILS_ID
                                                AND BLKSHR.PORTFOLIO_CODE = ISCMS.PORTFOLIO_CODE,
                                        (SELECT SYMBOL,
                                                INSTRUMENT_DETAILS_ID,
                                                MARGIN_OR_NONMARGIN_FLAG
                                            FROM LS_MARKET_WISE_INSTRUMENT
                                        WHERE MARKET_DETAILS_ID = 61) MWINSTDET,
                                        LS_INSTRUMENT_DETAILS LSID
                                        LEFT JOIN
                                        (SELECT P_PE_RATIO.INSTRUMENT_DETAILS_ID,
                                                P_PE_RATIO.RATIO_VALUE
                                            FROM P_PE_RATIO
                                        WHERE P_PE_RATIO.BUSINESS_DATE =
                                                (SELECT MAX (P_PE_RATIO.BUSINESS_DATE)
                                                    FROM P_PE_RATIO
                                                WHERE P_PE_RATIO.BUSINESS_DATE <=:business_date))
                                        PE_RATIO
                                            ON PE_RATIO.INSTRUMENT_DETAILS_ID =
                                                LSID.INSTRUMENT_DETAILS_ID
                                        LEFT JOIN
                                        (SELECT CMPH.INSTRUMENT_DETAILS_ID, CMPH.CLOSE_PRICE
                                            FROM P_CAP_MKT_PRICE_HISTORY CMPH,
                                                LS_INSTRUMENT_DETAILS  INSTDET
                                        WHERE     INSTDET.INSTRUMENT_DETAILS_ID =
                                                    CMPH.INSTRUMENT_DETAILS_ID
                                                AND CMPH.BUSINESS_DATE =
                                                    (SELECT MAX (
                                                                P_CAP_MKT_PRICE_HISTORY.BUSINESS_DATE)
                                                        FROM P_CAP_MKT_PRICE_HISTORY
                                                    WHERE     P_CAP_MKT_PRICE_HISTORY.BUSINESS_DATE <=
                                                                :business_date
                                                            AND INSTDET.INSTRUMENT_DETAILS_ID =
                                                                P_CAP_MKT_PRICE_HISTORY.INSTRUMENT_DETAILS_ID))
                                        P_CAP_MKT_PRICE
                                            ON P_CAP_MKT_PRICE.INSTRUMENT_DETAILS_ID =
                                                LSID.INSTRUMENT_DETAILS_ID
                                WHERE     ISCMS.CAP_MKT_STOCK_ID =
                                            (SELECT MAX (ISCMSD.CAP_MKT_STOCK_ID)
                                                FROM IS_CAP_MKT_STOCK ISCMSD
                                            WHERE     ISCMSD.INSTRUMENT_DETAILS_ID =
                                                        ISCMS.INSTRUMENT_DETAILS_ID
                                                    AND ISCMS.PORTFOLIO_CODE = ISCMSD.PORTFOLIO_CODE
                                                    AND LSID.INSTRUMENT_DETAILS_ID =
                                                        ISCMSD.INSTRUMENT_DETAILS_ID
                                                    AND ISCMSD.BUSINESS_DATE <= :business_date)
                                        AND ISCMS.PORTFOLIO_CODE = :investor_code
                                        AND ISCMS.TOTAL_SHARE > 0
                                        AND MWINSTDET.INSTRUMENT_DETAILS_ID =
                                            LSID.INSTRUMENT_DETAILS_ID
                                        AND GSECT.SECTOR_ID = LSID.SECTOR_ID
                                        AND SATCAT.SATTLEMENT_CAT_ID = LSID.SATTLEMENT_CAT_ID
                                ORDER BY TOTAL_COST_AMOUNT DESC) SI
                        WHERE ROWNUM <= 3 
                        ";

            $topStockResult = DB::select(
                $topStockSql,
                [
                    'business_date' => Carbon::createFromFormat('Y-m-d H:i:s', $businessDate->business_date)->format('Y-m-d'),
                    'investor_code' => $user->investor_code,
                ]
            ); 

            
            
            return response()->json([
                'status'          => 'success',
                'top_stock' => $topStockResult, 
            ]);
    }
    public function dashboardSectorInfo()
    {
        $user                    = Auth::user();
		$businessDate            = BusinessDate::latest('business_date')->first();
        
        $topSectorSql = " SELECT SEI.SECTOR_NAME, SEI.TOTAL_COST_AMOUNT, SEI.TOTAL_MKT_AMOUNT
                                    FROM (  SELECT GSECT.SECTOR_NAME
                                                        AS SECTOR_NAME,
                                                   ROUND( SUM (NVL (ISCMS.TOTAL_SHARE * ISCMS.AVG_RATE, 0)),2)
                                                        AS TOTAL_COST_AMOUNT,
                                                     ROUND(SUM (NVL (P_CAP_MKT_PRICE.CLOSE_PRICE * ISCMS.TOTAL_SHARE, 0)),2)
                                                        AS TOTAL_MKT_AMOUNT
                                                FROM GS_SECTOR            GSECT,
                                                    GS_SATTLEMENT_CAT    SATCAT,
                                                    IS_CAP_MKT_STOCK     ISCMS
                                                    LEFT JOIN
                                                    (SELECT BSHARE.PORTFOLIO_CODE,
                                                            BSHARE.INSTRUMENT_DETAILS_ID,
                                                            BSHARE.BLOCK_SHARE
                                                        FROM IS_BLOCK_SHARE_STOCK BSHARE
                                                    WHERE IS_BLOCK_SHARE_ID =
                                                            (SELECT MAX (IS_BLOCK_SHARE_ID)
                                                                FROM IS_BLOCK_SHARE_STOCK
                                                            WHERE     PORTFOLIO_CODE = BSHARE.PORTFOLIO_CODE
                                                                    AND INSTRUMENT_DETAILS_ID =
                                                                        BSHARE.INSTRUMENT_DETAILS_ID)) BLKSHR
                                                        ON     BLKSHR.INSTRUMENT_DETAILS_ID =
                                                                ISCMS.INSTRUMENT_DETAILS_ID
                                                            AND BLKSHR.PORTFOLIO_CODE = ISCMS.PORTFOLIO_CODE,
                                                    (SELECT SYMBOL,
                                                            INSTRUMENT_DETAILS_ID,
                                                            MARGIN_OR_NONMARGIN_FLAG
                                                        FROM LS_MARKET_WISE_INSTRUMENT
                                                    WHERE MARKET_DETAILS_ID = 61) MWINSTDET,
                                                    LS_INSTRUMENT_DETAILS LSID
                                                    LEFT JOIN
                                                    (SELECT P_PE_RATIO.INSTRUMENT_DETAILS_ID,
                                                            P_PE_RATIO.RATIO_VALUE
                                                        FROM P_PE_RATIO
                                                    WHERE P_PE_RATIO.BUSINESS_DATE =
                                                            (SELECT MAX (P_PE_RATIO.BUSINESS_DATE)
                                                                FROM P_PE_RATIO
                                                            WHERE P_PE_RATIO.BUSINESS_DATE <= :business_date))
                                                    PE_RATIO
                                                        ON PE_RATIO.INSTRUMENT_DETAILS_ID =
                                                            LSID.INSTRUMENT_DETAILS_ID
                                                    LEFT JOIN
                                                    (SELECT CMPH.INSTRUMENT_DETAILS_ID, CMPH.CLOSE_PRICE
                                                        FROM P_CAP_MKT_PRICE_HISTORY CMPH,
                                                            LS_INSTRUMENT_DETAILS  INSTDET
                                                    WHERE     INSTDET.INSTRUMENT_DETAILS_ID =
                                                                CMPH.INSTRUMENT_DETAILS_ID
                                                            AND CMPH.BUSINESS_DATE =
                                                                (SELECT MAX (
                                                                            P_CAP_MKT_PRICE_HISTORY.BUSINESS_DATE)
                                                                    FROM P_CAP_MKT_PRICE_HISTORY
                                                                WHERE     P_CAP_MKT_PRICE_HISTORY.BUSINESS_DATE <=
                                                                           :business_date
                                                                        AND INSTDET.INSTRUMENT_DETAILS_ID =
                                                                            P_CAP_MKT_PRICE_HISTORY.INSTRUMENT_DETAILS_ID))
                                                    P_CAP_MKT_PRICE
                                                        ON P_CAP_MKT_PRICE.INSTRUMENT_DETAILS_ID =
                                                            LSID.INSTRUMENT_DETAILS_ID
                                            WHERE     ISCMS.CAP_MKT_STOCK_ID =
                                                        (SELECT MAX (ISCMSD.CAP_MKT_STOCK_ID)
                                                            FROM IS_CAP_MKT_STOCK ISCMSD
                                                        WHERE     ISCMSD.INSTRUMENT_DETAILS_ID =
                                                                    ISCMS.INSTRUMENT_DETAILS_ID
                                                                AND ISCMS.PORTFOLIO_CODE = ISCMSD.PORTFOLIO_CODE
                                                                AND LSID.INSTRUMENT_DETAILS_ID =
                                                                    ISCMSD.INSTRUMENT_DETAILS_ID
                                                                AND ISCMSD.BUSINESS_DATE <= :business_date)
                                                    AND ISCMS.PORTFOLIO_CODE = :investor_code
                                                    AND ISCMS.TOTAL_SHARE > 0
                                                    AND MWINSTDET.INSTRUMENT_DETAILS_ID =
                                                        LSID.INSTRUMENT_DETAILS_ID
                                                    AND GSECT.SECTOR_ID = LSID.SECTOR_ID
                                                    AND SATCAT.SATTLEMENT_CAT_ID = LSID.SATTLEMENT_CAT_ID
                                            GROUP BY GSECT.SECTOR_NAME
                                            ORDER BY TOTAL_COST_AMOUNT DESC) SEI
                                    WHERE ROWNUM <= 3
                        ";

            $topSectorResult = DB::select(
                $topSectorSql,
                [
                    'business_date' => Carbon::createFromFormat('Y-m-d H:i:s', $businessDate->business_date)->format('Y-m-d'),
                    'investor_code' => $user->investor_code,
                ]
            ); 
            
            return response()->json([
                'status'          => 'success',
                'top_sector' => $topSectorResult,
            ]);
    }
}
