<!DOCTYPE html>
<html lang="en">
<head>
    <title><?php echo e($title); ?></title>
    <style>
        @page {
            margin: 0;
            size: a4;
        }
        body {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
            margin: 0;
            padding: 0;
            width: 100%;
        }

        #header {
            position: fixed;
            left: 0;
            top: 0;
            right: 0;
            height: 105px;
            /* background-color: orange; */
            text-align: center;
            /* border: 1px solid red; */
        }

        #footer {
            position: fixed;
            left: 0;
            bottom: 0;
            right: 0;
            height: 60px;
            /* background-color: yellowgreen; */
            text-align: center;
            /* border: 1px solid red; */
        }

        #footer .page {
            text-align: right;
        }

        #footer .page:after {
            content: "  " counter(page, decimal);
        }

        table {
            width: 100%;
            border-collapse: collapse;
            /* border-spacing: -1px; */
            /* border:collapse; */
        }

        .table-data {
            width: 100%;
            padding-bottom: 25px;
            /* page-break-inside: avoid; */
        }

        .table-data tbody td,
        .table-data tbody th {
            /* border: 1px solid #0072bc; */
        }

        .table-data.no-border tbody td,
        .table-data.no-border tbody th,
        .table-data tbody td.no-border,
        .table-data tbody th.no-border {
            border: 1px solid transparent;
        }

        .header-table {
            height: 105px;
            margin-bottom: 5px;
        }

        .footer-table {
            height: 60px;
        }

        /* .header,
        .footer {
            width: 99.5%;
            right: 1px;
            left: 1px;
            position: fixed;
        } */

        .content-wrapper {
            padding: 0 15px;
        }

        p.page-break {
            page-break-before: always;
        }

        p.page-break:last-child {
            page-break-before: avoid;
        }

        /* p:last-child {
            page-break-after: avoid;
        } */
    </style>
</head>
<body>
    <div id="header">
        <div class="content-wrapper">
            <table style="/* background-color: violet; */ margin-top: 15px;">
                <tr>
                    <td style="width: 20%; /* border: 1px solid red; */">
                        <img style="width: 200px;" src="<?php echo e(public_path('images/brack_epl_logo.png')); ?>" alt="" srcset="">
                    </td>
                    <td style="width: 50%; /* border: 1px solid red; */">
                        <table class="header-table-data" style="text-align: center;">
                            <tr>
                                <td style="/* color: #0072bc;  */font-weight: 600; font-size: 18px;">Community Bank Investment Limited</td>
                            </tr>
                            <tr>
                                <td style="/* color: #0072bc;  */font-weight: 600; font-size: 14px;">Portfolio Management</td>
                            </tr>
                            <tr>
                                <td style="/* color: #0072bc;  */font-weight: 600; font-size: 13px;">Head Office</td>
                            </tr>
                            <tr>
                                <td style="/* color: #0072bc;  */font-weight: 600; font-size: 12px;">Police Plaza Concord (Level-12, Tower-2) Gulshan 1, Dhaka-1212.</td>
                            </tr>
                        </table>
                    </td>
                    <td style="width: 30%;"></td>
                </tr>
            </table>
        </div>
    </div>
    <div id="footer">
        <div class="content-wrapper">
            <table style="/* background-color: violet; */">
                <tr>
                    <td style="width: 30%;">
                        <div class="page">Page </div>
                    </td>
                </tr>
            </table>
        </div>
    </div>

    <div id="content" class="content-wrapper">
        <!-- Your main content here -->

        <table class="table-data" style="font-size: 10px;">
        <thead>
            <tr>
                <td>
                    <div class="header-table"></div>
                </td>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td colspan="11" style="border: none;">
                    <table class="table-data no-border" style="font-size: 10px;">
                        <tr>
                            <th style="width: 8%; text-align: left;">Account Type</th>
                            <td style="width: 1%; text-align: center;">:</td>
                            <td style="width: 9%; text-align: left;"><?php echo e($account_type); ?></td>

                            <th style="width: 8%; text-align: left;">Account No</th>
                            <td style="width: 1%; text-align: center;">:</td>
                            <td style="width: 5%; text-align: left;"><?php echo e($account_no); ?></td>

                            <th style="width: 5%; text-align: left;">BO ID</th>
                            <td style="width: 1%; text-align: center;">:</td>
                            <td style="width: 12%; text-align: left;"><?php echo e($bo_no); ?></td>

                            <th style="width: 3%; text-align: left;">Account</th>
                            <td style="width: 1%; text-align: center;">:</td>
                            <td style="width: 3%; text-align: left;"><?php echo e($account_status); ?></td>

                            <th style="width: 3%; text-align: left;">Date</th>
                            <td style="width: 1%; text-align: center;">:</td>
                            <td style="width: 12%; text-align: left;"><?php echo e($account_date); ?></td>
                        </tr>
                        
                        <tr>
                            <th style="text-align: left;">Name</th>
                            <td style="text-align: center;">:</td>
                            <td style="text-align: left;" colspan="4"><?php echo e($account_name); ?></td>

                            
                            <th style="text-align: left;"></th>
                            <td style="text-align: center;"></td>
                            <td style="text-align: left;" colspan="7"></td>
                        </tr>
                        
                        <tr>
                            <th style="text-align: left;">Address</th>
                            <td style="text-align: center;">:</td>
                            <td style="text-align: left;" colspan="13"><?php echo e($account_address); ?></td>
                        </tr>
                    </table>
                </td>
            </tr><?php /**PATH D:\xampp\htdocs\USLWMCBIL-API\resources\views/common/header.blade.php ENDPATH**/ ?>