'use client'
import { useState, useRef, useEffect } from "react";
import { signOut, useSession } from "next-auth/react";
import Swal from "sweetalert2";
import Loading from "../loading";
import styles from "../../assets/style.module.css";

const ClientComponent = () => {
    const [isLoading, setIsLoading] = useState(false)
    const { data } = useSession()
    const prevToken = useRef(null)
    const [investor, setInvestor] = useState([])

    useEffect(() => {
        let token;
        if (data && data.user && data.user.token && data.user.token !== prevToken.current) {
            setIsLoading(true)
            token = data.user.token
            prevToken.current = token
            fetchPersonalInfo(token);
        }
    }, [data?.user?.token])

    const fetchPersonalInfo = async (token) => {
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/acknowledgement-slip';
            const res = await fetch(url, {
                method: "GET",
                headers: {
                    "Accept": "application/json",
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer ' + String(token)
                }
            });
            const data = await res.json();
            if (data.status == 'success') {
                setInvestor(data.nominee_information)
            } else if (res.status == 401) {
                Swal.fire({
                    position: "top-end",
                    icon: "warning",
                    title: data.message,
                    showConfirmButton: false,
                    timer: 1000,
                }).then((result) => {
                    if (result.dismiss === Swal.DismissReason.timer) {
                        signOut();
                    }
                });
            }
        } catch (error) {
            if (error.name == 'TypeError') {
                Swal.fire({
                    position: "top-end",
                    icon: "error",
                    title: 'The server is not responding. Please wait for a moment.',
                    showConfirmButton: false,
                    timer: 2000,
                });
            }
        } finally {
            setIsLoading(false)
        }
    };

    if (isLoading) {
        return (
            <Loading loading={isLoading} />
        )
    }

    return (
        <>
            <div style={{ width: '100%' }} className={`${styles.d_flex} ${styles.mx_20} ${styles.mt_sm_35}`}>

                {
                    investor && Object.keys(investor).length > 0 ? 
                    (
                        <table style={{ width: '100%' }}>
                            <tbody>
                                <tr>
                                    <td>Nominee Name</td>
                                    <td>Nominee Address</td>
                                    <td>Relation</td>
                                    <td>Percentage</td>
                                </tr>

                                {
                                    investor.map((data, index) => {
                                        return <tr key={index}>
                                            <td>{data.nominee_name}</td>
                                            <td>{data.mailing_address}</td>
                                            <td>{data.relation}</td>
                                            <td>{data.share_percentage}</td>
                                        </tr>
                                    })
                                }

                            </tbody>
                        </table>
                    ) : (
                        <div  style={{ 'text-align': 'center', width: '100%' }}>Nominee Not Found</div>
                    )
                }
            </div>
        </>
    )
}

export default ClientComponent;