'use client'
import React, { useState, useEffect, useRef } from 'react';
import { usePathname } from 'next/navigation';
import Sidebar from "../layout/sidebar";
import PageStyles from "../assets/style.module.css";
import LoginStyles from "../assets/login.module.css";

const SideBarVisibility = ({ children }) => {

    const pathname                          = usePathname();
    const [showSidebar, setShowSidebar]     = useState(false);
    const [showChildren, setShowChildren]   = useState(false);
    const [notices,setNotices]              = useState()
    let styles = null;

    if (pathname == '/login' || pathname == '/aboutproduct' || pathname == '/termscondition' || pathname == '/register' || pathname == '/signup' || pathname == '/forgotpassword') {
        styles = LoginStyles;
    } else {
        styles = PageStyles;
    }

    

    useEffect(() => {
        if (pathname == '/login' || pathname == '/aboutproduct' || pathname == '/termscondition' || pathname == '/register' || pathname == '/signup' || pathname == '/forgotpassword') {
            styles = LoginStyles;
            setShowSidebar(false);
            setShowChildren(true)
        } else {
            styles = PageStyles;
            setShowSidebar(true);
            setShowChildren(true)
        }
    }, [pathname]);


    useEffect(()=>{
        fetchNoticeBoard()
    },[])

    const fetchNoticeBoard= async ()=>{
        try {
            const url = process.env.NEXT_PUBLIC_API_URL + '/notices';
            const res = await fetch(url,{
                method:"GET",
                headers:{
                    "Accept":"application/json",
                    "Content-Type":"application/json",
                }
            })

            const data = await res.json()

            if(data.status=='success'){
                setNotices(data.notices)
            }

        } catch (error) {

        }
    }

    return (
        <>
            {showSidebar && <Sidebar/>}
            {showChildren &&
                <div className={styles.content}>
                    
                    {children}
                    <marquee className={`${styles.text_color}`}>
                        {
                            notices && Object.keys(notices).length > 0 &&
                            (
                                notices.map((data,key)=>{
                                    return data.notice
                                })
                            )
                        }
                    </marquee>
                </div>
            }
        </>
    );
};

export default SideBarVisibility;
